/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableList;
import com.mapr.db.impl.OjaiQueryProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentReader;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.exceptions.OjaiException;

public class MaterializedDocumentStream
implements DocumentStream,
OjaiQueryProperties {
    private final List<Document> docList;
    private boolean used = false;
    private boolean closed = false;
    private final OjaiQueryProperties.QueryPath queryPath;
    private final String indexUsed;
    private final FieldPath[] fieldPaths;

    public MaterializedDocumentStream(Document document, OjaiQueryProperties.QueryPath queryPath, String indexUsed, FieldPath ... fieldPath) {
        this.queryPath = queryPath;
        this.indexUsed = indexUsed;
        this.fieldPaths = fieldPath;
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        if (document != null) {
            listBuilder.add((Object)document);
        }
        this.docList = listBuilder.build();
    }

    public MaterializedDocumentStream(OjaiQueryProperties.QueryPath queryPath, String indexUsed) {
        this(null, queryPath, indexUsed, null);
    }

    public void close() throws OjaiException {
        this.closed = true;
    }

    private void checkNotUsed() {
        if (this.closed) {
            throw new OjaiException("This DocumentStream has been closed");
        }
        if (this.used) {
            throw new OjaiException("This DocumentStream has already been used");
        }
    }

    public Iterable<DocumentReader> documentReaders() {
        this.checkNotUsed();
        return new TheIterable();
    }

    public Iterator<Document> iterator() {
        this.checkNotUsed();
        this.used = true;
        return this.docList.iterator();
    }

    public void streamTo(DocumentListener documentListener) {
        this.checkNotUsed();
        this.used = true;
        for (Document doc : this.docList) {
            if (this.closed) {
                return;
            }
            documentListener.documentArrived(doc);
        }
        documentListener.eos();
    }

    public OjaiQueryProperties.QueryPath getQueryPath() {
        return this.queryPath;
    }

    public String getIndexUsed() {
        return this.indexUsed;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("priTablePath", this.indexUsed);
        valueMap.put("queryPath", this.queryPath);
        valueMap.put("projList", this.fieldPaths);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class TheIterable
    implements Iterable<DocumentReader> {
        private TheIterable() {
        }

        @Override
        public Iterator<DocumentReader> iterator() {
            return new DocumentReaders();
        }
    }

    private class DocumentReaders
    implements Iterator<DocumentReader> {
        private final Iterator<Document> iterator;

        public DocumentReaders() {
            this.iterator = MaterializedDocumentStream.this.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DocumentReader next() {
            Document document = this.iterator.next();
            return document.asReader();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

