/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionVisitor;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentReader;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.json.JsonOptions;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class LiteralExpression
extends Expression
implements Value {
    private final Value.Type type;
    private final String string;
    private final long i;
    private final double d;
    private final float f;
    private final boolean b;
    private final OTimestamp timestamp;
    private final OTime time;
    private final ODate date;
    private final OInterval interval;
    private final ByteBuffer byteBuffer;
    private final Map<String, Object> map;
    private final List<Object> list;

    public LiteralExpression() {
        this.type = Value.Type.NULL;
        this.string = null;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.b = false;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(boolean v) {
        this.type = Value.Type.BOOLEAN;
        this.b = v;
        this.string = null;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(int v) {
        this.type = Value.Type.INT;
        this.i = v;
        this.string = null;
        this.b = false;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(byte v) {
        this.type = Value.Type.BYTE;
        this.i = v;
        this.string = null;
        this.b = false;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(short v) {
        this.type = Value.Type.SHORT;
        this.i = v;
        this.string = null;
        this.b = false;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(long v) {
        this.type = Value.Type.LONG;
        this.i = v;
        this.string = null;
        this.b = false;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(String string) {
        this.type = Value.Type.STRING;
        this.string = string;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.b = false;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(ODate v) {
        this.type = Value.Type.DATE;
        this.date = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(OTime v) {
        this.type = Value.Type.TIME;
        this.time = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(OTimestamp v) {
        this.type = Value.Type.TIMESTAMP;
        this.timestamp = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(OInterval v) {
        this.type = Value.Type.INTERVAL;
        this.interval = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(ByteBuffer v) {
        this.type = Value.Type.BINARY;
        this.byteBuffer = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(double v) {
        this.type = Value.Type.DOUBLE;
        this.d = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(float v) {
        this.type = Value.Type.FLOAT;
        this.f = v;
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
        this.list = null;
    }

    public LiteralExpression(Map<String, Object> v) {
        this.type = Value.Type.MAP;
        this.map = ImmutableMap.copyOf(v);
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.list = null;
    }

    public LiteralExpression(List<Object> v) {
        this.type = Value.Type.ARRAY;
        this.list = ImmutableList.copyOf(v);
        this.string = null;
        this.b = false;
        this.i = 0L;
        this.d = 0.0;
        this.f = 0.0f;
        this.timestamp = null;
        this.time = null;
        this.date = null;
        this.interval = null;
        this.byteBuffer = null;
        this.map = null;
    }

    public String getLiteral() {
        switch (this.type) {
            case ARRAY: {
                throw new IllegalStateException("unsupported type conversion (array -> String)");
            }
            case BINARY: {
                throw new IllegalStateException("unimplemented");
            }
            case BOOLEAN: {
                return Boolean.toString(this.b);
            }
            case BYTE: {
                return Byte.toString((byte)this.i);
            }
            case DATE: {
                return String.format("date '%d-%d-%d'", this.date.getYear(), this.date.getMonth(), this.date.getDayOfMonth());
            }
            case DECIMAL: {
                throw new IllegalStateException("unsupported type conversion (Decimal -> String)");
            }
            case DOUBLE: {
                return Double.toString(this.d);
            }
            case FLOAT: {
                return Float.toString(this.f);
            }
            case INT: {
                return Integer.toString((int)this.i);
            }
            case INTERVAL: {
                return this.interval.toString();
            }
            case LONG: {
                return Long.toString(this.i);
            }
            case MAP: {
                throw new IllegalStateException("unsupported type conversion (map -> String)");
            }
            case NULL: {
                return "null";
            }
            case SHORT: {
                return Short.toString((short)this.i);
            }
            case STRING: {
                return '\'' + this.string + '\'';
            }
            case TIME: {
                return String.format("time '%02d:%02d:%02d.%03d'", this.time.getHour(), this.time.getMinute(), this.time.getSecond(), this.time.getMilliSecond());
            }
            case TIMESTAMP: {
                return String.format("timestamp '%04d-%02d-%02d %02d:%02d:%02d.%03d'", this.timestamp.getYear(), this.timestamp.getMonth(), this.timestamp.getDayOfMonth(), this.timestamp.getHour(), this.timestamp.getMinute(), this.timestamp.getSecond(), this.timestamp.getMilliSecond());
            }
        }
        throw new IllegalStateException("Unknown switch case: " + this.type);
    }

    @Override
    public void emitSql(StringBuilder sb, String tableAlias) {
        sb.append(this.getLiteral());
    }

    @Override
    public boolean structuralEquals(Expression e) {
        return e instanceof LiteralExpression;
    }

    @Override
    public int structuralHashCode() {
        return -267531522;
    }

    public DocumentReader asReader() {
        throw new IllegalStateException("unimplemented");
    }

    public ByteBuffer getBinary() {
        Preconditions.checkState((this.type == Value.Type.BINARY ? 1 : 0) != 0);
        return this.byteBuffer;
    }

    public boolean getBoolean() {
        Preconditions.checkState((this.type == Value.Type.BOOLEAN ? 1 : 0) != 0);
        return this.b;
    }

    public byte getByte() {
        Preconditions.checkState((this.type == Value.Type.BYTE ? 1 : 0) != 0);
        return (byte)this.i;
    }

    public ODate getDate() {
        Preconditions.checkState((this.type == Value.Type.DATE ? 1 : 0) != 0);
        return this.date;
    }

    public int getDateAsInt() {
        Preconditions.checkState((this.type == Value.Type.DATE ? 1 : 0) != 0);
        return this.date.toDaysSinceEpoch();
    }

    public BigDecimal getDecimal() {
        throw new OjaiException("unsupported datatype (BigDecimal)");
    }

    public double getDouble() {
        Preconditions.checkState((this.type == Value.Type.DOUBLE ? 1 : 0) != 0);
        return this.d;
    }

    public float getFloat() {
        Preconditions.checkState((this.type == Value.Type.FLOAT ? 1 : 0) != 0);
        return this.f;
    }

    public int getInt() {
        Preconditions.checkState((this.type == Value.Type.INT ? 1 : 0) != 0);
        return (int)this.i;
    }

    public OInterval getInterval() {
        Preconditions.checkState((this.type == Value.Type.INTERVAL ? 1 : 0) != 0);
        return this.interval;
    }

    public long getIntervalAsLong() {
        Preconditions.checkState((this.type == Value.Type.INTERVAL ? 1 : 0) != 0);
        return this.interval.getTimeInMillis();
    }

    public List<Object> getList() {
        throw new OjaiException("unsupported datatype (array)");
    }

    public long getLong() {
        Preconditions.checkState((this.type == Value.Type.LONG ? 1 : 0) != 0);
        return this.i;
    }

    public Map<String, Object> getMap() {
        throw new OjaiException("unsupported datatype (map)");
    }

    public Object getObject() {
        switch (this.type) {
            case ARRAY: {
                return this.list;
            }
            case BINARY: {
                return this.byteBuffer;
            }
            case BOOLEAN: {
                return new Boolean(this.b);
            }
            case BYTE: {
                return new Byte((byte)this.i);
            }
            case DATE: {
                return this.date;
            }
            case DECIMAL: {
                throw new IllegalStateException("unimplemented");
            }
            case DOUBLE: {
                return new Double(this.d);
            }
            case FLOAT: {
                return new Float(this.f);
            }
            case INT: {
                return new Integer((int)this.i);
            }
            case INTERVAL: {
                return this.interval;
            }
            case LONG: {
                return new Long(this.i);
            }
            case MAP: {
                return this.map;
            }
            case NULL: {
                return null;
            }
            case SHORT: {
                return new Short((short)this.i);
            }
            case STRING: {
                return this.string;
            }
            case TIME: {
                return this.time;
            }
            case TIMESTAMP: {
                return this.timestamp;
            }
        }
        throw new IllegalStateException("Unknown switch case: " + this.type);
    }

    public short getShort() {
        Preconditions.checkState((this.type == Value.Type.SHORT ? 1 : 0) != 0);
        return (short)this.i;
    }

    public String getString() {
        Preconditions.checkState((this.type == Value.Type.STRING ? 1 : 0) != 0);
        return this.string;
    }

    public OTime getTime() {
        Preconditions.checkState((this.type == Value.Type.TIME ? 1 : 0) != 0);
        return this.time;
    }

    public int getTimeAsInt() {
        Preconditions.checkState((this.type == Value.Type.TIME ? 1 : 0) != 0);
        return this.time.getMilliSecond();
    }

    public OTimestamp getTimestamp() {
        Preconditions.checkState((this.type == Value.Type.TIMESTAMP ? 1 : 0) != 0);
        return this.timestamp;
    }

    public long getTimestampAsLong() {
        Preconditions.checkState((this.type == Value.Type.TIMESTAMP ? 1 : 0) != 0);
        return this.timestamp.getMillis();
    }

    public Value.Type getType() {
        return this.type;
    }

    public String asJsonString() {
        throw new OjaiException("unimplemented");
    }

    public String asJsonString(JsonOptions jsonOptions) {
        throw new OjaiException("unimplemented");
    }

    @Override
    public void visit(ExpressionVisitor ev) {
        ev.visitLiteral(this);
    }
}

