/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentStream;

public class LimitStream
extends AbstractDocumentFilter {
    private final long limit;
    private long docCount;

    public LimitStream(DocumentStream upstreamStream, ExecutorService executorService, long limit) {
        super(upstreamStream, executorService);
        this.limit = limit;
    }

    @Override
    public boolean documentArrived(Document doc) {
        if (++this.docCount <= this.limit) {
            return super.documentArrived(doc);
        }
        return false;
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put("limit", this.limit);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

