/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.IdCodec;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryDocumentStream;
import com.mapr.ojai.store.impl.RowkeyLookup;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ojai.DocumentListener;
import org.ojai.Value;

public class IdDocumentStream
extends QueryDocumentStream {
    private final OjaiConnection ojaiConnection;
    private final FieldInBundle fib;
    private RowkeyLookup rowkeyLookup;
    private volatile boolean isCanceled;

    public IdDocumentStream(OjaiConnection ojaiConnection, FieldInBundle fib) {
        this.ojaiConnection = ojaiConnection;
        this.fib = fib;
    }

    @Override
    protected void submitQuery(DocumentListener docListener) {
        if (!(docListener instanceof RowkeyLookup)) {
            throw new IllegalArgumentException("unexpected docListener type");
        }
        this.rowkeyLookup = (RowkeyLookup)docListener;
        this.ojaiConnection.getExecutorService().execute(new IdFeeder());
    }

    @Override
    protected void cancelQuery() {
        this.isCanceled = true;
    }

    @Override
    public void getQueryPlan(List<Map<String, Object>> planList) {
        ArrayList<String> fieldBundle = new ArrayList<String>();
        for (LiteralExpression entry : this.fib.values) {
            fieldBundle.add(entry.getLiteral());
        }
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put("fieldPath", this.fib.fieldPath.toString());
        valueMap.put("fieldInBundle", fieldBundle);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class IdFeeder
    implements Runnable {
        private IdFeeder() {
        }

        @Override
        public void run() {
            for (LiteralExpression litExpr : ((IdDocumentStream)IdDocumentStream.this).fib.values) {
                ByteBuffer idBuffer;
                if (IdDocumentStream.this.isCanceled) {
                    return;
                }
                Value.Type idType = litExpr.getType();
                if (idType == Value.Type.BINARY) {
                    idBuffer = litExpr.getBinary();
                } else if (idType == Value.Type.STRING) {
                    idBuffer = IdCodec.encode((String)litExpr.getString());
                } else {
                    throw new IllegalStateException("_id must be a STRING or BINARY value");
                }
                if (IdDocumentStream.this.rowkeyLookup.idArrived(idBuffer)) continue;
                break;
            }
            IdDocumentStream.this.rowkeyLookup.eos();
        }
    }
}

