/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedDrillSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;

public class DrillPreludeFilter
extends AbstractDocumentFilter {
    private final OjaiConnection ojaiConnection;
    private final String sql;
    private final SharedDrillSession sharedDrillSession;
    private volatile DrillDocumentStream drillStream;

    public DrillPreludeFilter(DocumentStream upstreamStream, OjaiConnection ojaiConnection, SharedDrillSession sharedDrillSession, String sql) {
        super(upstreamStream, ojaiConnection.getExecutorService());
        Preconditions.checkArgument((sql != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sharedDrillSession != null ? 1 : 0) != 0);
        this.ojaiConnection = ojaiConnection;
        this.sql = sql;
        this.sharedDrillSession = sharedDrillSession;
        sharedDrillSession.addRef();
    }

    private void superStreamTo(DocumentListener docListener) {
        super.streamTo(docListener);
    }

    @Override
    public void streamTo(DocumentListener docListener) {
        QueryContext queryContext = QueryContext.newBuilder(this.sql).build();
        this.drillStream = new DrillDocumentStream(this.ojaiConnection, queryContext, this.sharedDrillSession);
        this.drillStream.streamTo(new ContinuationListener(docListener));
    }

    @Override
    protected void closeDerived() {
        if (this.drillStream != null) {
            this.drillStream.close();
        }
        this.sharedDrillSession.close();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sql", this.sql);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class ContinuationListener
    implements DocumentListener {
        private final DocumentListener docListener;

        public ContinuationListener(DocumentListener docListener) {
            this.docListener = docListener;
        }

        public boolean documentArrived(Document doc) {
            return true;
        }

        public void eos() {
            DrillPreludeFilter.this.superStreamTo(this.docListener);
        }

        public void failed(Exception e) {
            this.docListener.failed(e);
        }
    }
}

