/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.AsynchronousStreamTo;
import com.mapr.ojai.store.impl.DrillDocumentStream;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.QueryContext;
import com.mapr.ojai.store.impl.SharedDrillSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;

public class DrillPostludeFilter
extends AbstractDocumentFilter {
    private final OjaiConnection ojaiConnection;
    private final String sql;
    private final SharedDrillSession sharedDrillSession;
    private volatile DrillDocumentStream drillStream;

    public DrillPostludeFilter(DocumentStream upstreamStream, OjaiConnection ojaiConnection, SharedDrillSession sharedDrillSession, String sql) {
        super(upstreamStream, ojaiConnection.getExecutorService());
        Preconditions.checkArgument((sql != null ? 1 : 0) != 0);
        Preconditions.checkArgument((sharedDrillSession != null ? 1 : 0) != 0);
        this.ojaiConnection = ojaiConnection;
        this.sql = sql;
        this.sharedDrillSession = sharedDrillSession;
        sharedDrillSession.addRef();
    }

    private void privateClose() {
        this.drillStream.close();
        this.sharedDrillSession.close();
    }

    @Override
    public void eos() {
        QueryContext queryContext = QueryContext.newBuilder(this.sql).build();
        this.drillStream = new DrillDocumentStream(this.ojaiConnection, queryContext, this.sharedDrillSession);
        ExecutorService executorService = this.ojaiConnection.getExecutorService();
        executorService.execute(new AsynchronousStreamTo(new CleanupListener(), this.drillStream));
        super.eos();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sql", this.sql);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class CleanupListener
    implements DocumentListener {
        private CleanupListener() {
        }

        public boolean documentArrived(Document doc) {
            return false;
        }

        public void eos() {
            DrillPostludeFilter.this.privateClose();
        }

        public void failed(Exception e) {
            DrillPostludeFilter.this.privateClose();
        }
    }
}

