/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ojai.store.impl.TimeoutDocumentFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.exceptions.OjaiException;

public class DocumentListenerToIterator
implements DocumentListener,
Iterator<Document> {
    private static final Document SENTINEL_DOC = MapRDBImpl.newDocument();
    private final ArrayBlockingQueue<Document> docQueue = new ArrayBlockingQueue(1);
    private volatile Thread putThread;
    private volatile boolean keepListening = true;
    private boolean sawEos;
    private Document nextDoc;
    private Exception ex;
    private final TimeoutDocumentFilter timeoutFilter;

    public DocumentListenerToIterator() {
        this(null);
    }

    public DocumentListenerToIterator(TimeoutDocumentFilter timeoutFilter) {
        this.timeoutFilter = timeoutFilter;
    }

    public void terminate() {
        this.keepListening = false;
        this.nextDoc = null;
        this.sawEos = true;
        Thread putThread = this.putThread;
        if (putThread != null) {
            putThread.interrupt();
        }
    }

    private void queuePut(Document doc) {
        if (this.keepListening) {
            try {
                this.putThread = Thread.currentThread();
                this.docQueue.put(doc);
                this.putThread = null;
            }
            catch (InterruptedException ie) {
                this.keepListening = false;
            }
        }
    }

    public boolean documentArrived(Document doc) {
        this.queuePut(doc);
        return this.keepListening;
    }

    public void eos() {
        this.queuePut(SENTINEL_DOC);
    }

    public void failed(Exception ex) {
        this.ex = ex;
        this.queuePut(SENTINEL_DOC);
        this.keepListening = false;
    }

    private boolean advanceToNext() {
        if (this.nextDoc != null) {
            return true;
        }
        if (this.sawEos) {
            return false;
        }
        try {
            if (this.timeoutFilter == null) {
                this.nextDoc = this.docQueue.take();
            } else {
                this.timeoutFilter.startTimer();
                this.nextDoc = this.docQueue.take();
                this.timeoutFilter.cancelTimer();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.nextDoc != SENTINEL_DOC) {
            return true;
        }
        this.sawEos = true;
        this.nextDoc = null;
        if (this.ex != null) {
            if (this.ex instanceof OjaiException) {
                throw (OjaiException)this.ex;
            }
            throw new OjaiException((Throwable)this.ex);
        }
        return false;
    }

    @Override
    public boolean hasNext() {
        return this.advanceToNext();
    }

    @Override
    public Document next() {
        if (this.advanceToNext()) {
            Document resultDoc = this.nextDoc;
            this.nextDoc = null;
            return resultDoc;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

