/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.BaseJsonTable;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBIndexImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.fs.jni.IndexSyncStateTracker;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import com.mapr.ojai.store.impl.SharedResource;
import com.mapr.ojai.store.impl.SharedTable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.Path;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;

public class CommitWaitStream
extends AbstractDocumentFilter {
    private final SharedResource<BaseJsonTable> sharedTable;
    private final MapRDBTableImpl dbTable;
    private final String commitContext;
    private boolean isUsed = false;
    private final String priTablePath;

    public CommitWaitStream(DocumentStream upstreamStream, ExecutorService executorService, SharedResource<BaseJsonTable> sharedTable, String commitContext) {
        super(upstreamStream, executorService);
        BaseJsonTable argTable = sharedTable.get();
        if (argTable instanceof MapRDBTableImpl) {
            this.dbTable = (MapRDBTableImpl)argTable;
            this.sharedTable = sharedTable;
            sharedTable.addRef();
        } else if (argTable instanceof MapRDBIndexImpl) {
            Path tablePath = ((MapRDBIndexImpl)argTable).getTablePath();
            this.dbTable = (MapRDBTableImpl)MapRDBImpl.getTable((Path)tablePath);
            this.sharedTable = new SharedTable((BaseJsonTable)this.dbTable);
        } else {
            throw new IllegalArgumentException("unexpected table implementation " + argTable.getClass());
        }
        this.priTablePath = this.dbTable.getPath().toString();
        this.commitContext = commitContext;
    }

    private void superStreamTo(DocumentListener docListener) {
        super.streamTo(docListener);
    }

    @Override
    public void streamTo(DocumentListener docListener) {
        Preconditions.checkState((!this.isUsed ? 1 : 0) != 0);
        this.executorService.execute(new DeferredStreamTo(docListener));
        this.isUsed = true;
    }

    @Override
    protected void closeDerived() {
        this.sharedTable.release();
        super.closeDerived();
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", this.getClass().getSimpleName());
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("commitContext", this.commitContext);
        valueMap.put("primaryTable", this.priTablePath);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }

    private class DeferredStreamTo
    implements Runnable {
        private final DocumentListener docListener;

        public DeferredStreamTo(DocumentListener docListener) {
            this.docListener = docListener;
        }

        @Override
        public void run() {
            IndexSyncStateTracker tracker = CommitWaitStream.this.dbTable.createIndexSyncStateTracker(CommitWaitStream.this.commitContext);
            try {
                while (!tracker.haveIndexesSynced()) {
                    long waitMs = tracker.getEstimatedWaitMs();
                    Thread.sleep(waitMs);
                }
            }
            catch (IOException ioe) {
                this.docListener.failed((Exception)ioe);
                return;
            }
            catch (InterruptedException ie) {
                this.docListener.failed((Exception)ie);
                return;
            }
            CommitWaitStream.this.superStreamTo(this.docListener);
        }
    }
}

