/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentStream;
import com.mapr.ojai.store.impl.AsynchronousStreamTo;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.ojai.Document;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.exceptions.OjaiException;

public abstract class AbstractDocumentFilter
extends AbstractDocumentStream
implements DocumentListener,
OjaiQueryProperties {
    private boolean keepListening = true;
    protected final DocumentStream upstreamStream;
    private volatile DocumentListener downstreamListener;
    private final CountDownLatch haveListener = new CountDownLatch(1);
    protected final ExecutorService executorService;

    public AbstractDocumentFilter(DocumentStream upstreamStream, ExecutorService executorService) {
        this.upstreamStream = upstreamStream;
        this.executorService = executorService;
    }

    private void waitForListener() {
        if (this.downstreamListener == null) {
            try {
                this.haveListener.await();
            }
            catch (InterruptedException ie) {
                throw new OjaiException((Throwable)ie);
            }
        }
    }

    public boolean documentArrived(Document doc) {
        this.waitForListener();
        if (this.keepListening) {
            this.keepListening = this.downstreamListener.documentArrived(doc);
        }
        return this.keepListening;
    }

    public void eos() {
        this.waitForListener();
        this.downstreamListener.eos();
    }

    public void failed(Exception ex) {
        this.waitForListener();
        this.downstreamListener.failed(ex);
    }

    @Override
    protected void closeDerived() throws OjaiException {
        this.keepListening = false;
        this.upstreamStream.close();
    }

    @Override
    public void streamTo(DocumentListener docListener) {
        Preconditions.checkState((this.downstreamListener == null ? 1 : 0) != 0, (Object)"there is already a listener");
        this.downstreamListener = docListener;
        this.haveListener.countDown();
        this.executorService.execute(new AsynchronousStreamTo(this, this.upstreamStream));
        super.streamTo(docListener);
    }

    public OjaiQueryProperties.QueryPath getQueryPath() {
        return ((OjaiQueryProperties)this.upstreamStream).getQueryPath();
    }

    public String getIndexUsed() {
        return ((OjaiQueryProperties)this.upstreamStream).getIndexUsed();
    }
}

