/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.QueryParser;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.drill.exec.util.GuavaPatcher;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;

@Category(value={ClusterTest.class})
public class TestQueryParser
extends BaseTest {
    private static final String tableName = "queryTab";
    static Table table;
    static Connection con;

    @BeforeClass
    public static void setup() throws Exception {
        GuavaPatcher.patch();
        con = DriverManager.getConnection((String)"ojai:mapr:");
        table = DBTests.createOrReplaceTable((String)tableName);
    }

    @AfterClass
    public static void cleanUp() {
        table.close();
    }

    @Test
    public void testQueryCond() {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        String cond = "{\"$where\":{\"$eq\":{\"_id\":\"k2\"}}}";
        QueryParser qParser = new QueryParser();
        Query resQuery = qParser.parseQuery(cond);
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());
             DocumentStream ds = store.findQuery(resQuery);){
            int count = 0;
            for (Document doc : ds) {
                ++count;
                Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
            }
            Assert.assertEquals((long)1L, (long)count);
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testQueryProj() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String proj = "{\"$select\":[\"_id\",\"zip\"]}";
            Query resQuery = qParser.parseQuery(proj);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                for (Document doc : ds) {
                    String id = doc.getIdString();
                    Assert.assertNotNull((Object)id);
                    ++count;
                    Assert.assertTrue((id.equals("k1") || id.equals("k2") ? 1 : 0) != 0);
                    if (!id.equals("k2")) continue;
                    Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testQueryProjSingle() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String proj = "{\"$select\":[\"zip\"]}";
            Query resQuery = qParser.parseQuery(proj);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                for (Document doc : ds) {
                    Assert.assertNotNull((Object)doc.getId());
                    ++count;
                    Assert.assertTrue((doc.size() == 0 || doc.size() == 1 ? 1 : 0) != 0);
                    if (doc.size() != 1) continue;
                    Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testQueryProjSingleNoBracket() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String proj = "{\"$select\":\"zip\"}";
            Query resQuery = qParser.parseQuery(proj);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                for (Document doc : ds) {
                    ++count;
                    Assert.assertNotNull((Object)doc.getIdString());
                    Assert.assertTrue((doc.size() == 0 || doc.size() == 1 ? 1 : 0) != 0);
                    if (doc.size() != 1) continue;
                    Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testQueryLimit() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String off = "{\"$limit\":1}";
            Query resQuery = qParser.parseQuery(off);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                for (Document doc : ds) {
                    ++count;
                    Assert.assertEquals((Object)"k1", (Object)doc.getIdString());
                    Assert.assertEquals((long)350L, (long)doc.getInt("a.b"));
                    Assert.assertEquals((Object)"Holger Way", (Object)doc.getString("s"));
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Test
    public void testQueryOffset() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String off = "{\"$offset\":1}";
            Query resQuery = qParser.parseQuery(off);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                for (Document doc : ds) {
                    ++count;
                    Assert.assertEquals((Object)"k2", (Object)doc.getIdString());
                    Assert.assertEquals((Object)"95134", (Object)doc.getString("zip"));
                    Assert.assertEquals((long)350L, (long)doc.getInt("a.b"));
                    Assert.assertEquals((Object)"Holger Way", (Object)doc.getString("s"));
                }
                Assert.assertEquals((long)1L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }

    @Ignore(value="http://10.250.1.25/show_bug.cgi?id=27655")
    @Test
    public void testQueryOrderBy() throws Exception {
        Document d = MapRDBImpl.newDocument().set("a.b", 350).set("s", "Holger Way");
        table.insertOrReplace("k1", d);
        d.set("zip", "95134");
        d.set("a.b", 200);
        table.insertOrReplace("k2", d);
        table.flush();
        DBTests.waitForRowCount((Path)table.getPath(), (long)2L);
        QueryParser qParser = new QueryParser();
        try (DocumentStore store = con.getStore(DBTests.getTablePath((String)tableName).toString());){
            String off = "{\"$orderby\":\"a.b\"}";
            Query resQuery = qParser.parseQuery(off);
            try (DocumentStream ds = store.findQuery(resQuery);){
                int count = 0;
                boolean hitBefore = false;
                for (Document doc : ds) {
                    System.out.println(doc);
                    if (++count == 1) {
                        Assert.assertFalse((boolean)hitBefore);
                        hitBefore = true;
                        Assert.assertEquals((long)200L, (long)doc.getInt("a.b"));
                    }
                    if (count != 2) continue;
                    Assert.assertTrue((boolean)hitBefore);
                    Assert.assertEquals((long)350L, (long)doc.getInt("a.b"));
                }
                Assert.assertEquals((long)2L, (long)count);
            }
        }
        table.delete("k1");
        table.delete("k2");
    }
}

