/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.collect.ImmutableMap;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={ClusterTest.class})
public class TestProjectionPassthrough
extends OjaiTest {
    private static final int TIMEOUT_SECONDS = 5;
    private static final String NO_SUPPORT_FOR_HETEROGENEOUS_LISTS = "no_support_for_heterogeneous_lists";
    private static final String NO_DISTINCTION_BETWEEN_NULL_AND_NON_EXISTENT_FIELDS = "no_distinction_between_null_and_non-existent_fields";
    private static final String LIMITED_SUPPORT_FOR_FIELDS_WITH_DIFFERENT_SCHEMA = "limited_support_for_fields_with_different_schema";
    private static final String FIELD_NAMES_ARE_CASE_INSENSITIVE = "field_names_are_case_insensitive";
    private static final String PROJECTION_PASSTHROUGH_USERDATA = "projection_passthrough_userdata";
    private static final String PROJECTION_PASSTHROUGH_USERDATA_INDEX = "index_on_field_age_with_covering_fields";
    private static final Connection connection_ = TestProjectionPassthrough.getConnection();

    private DocumentStore getStore(String tableName) {
        DocumentStore docStore = connection_.getStore(TestProjectionPassthrough.getTablePath(tableName));
        Assert.assertNotNull((Object)docStore);
        return docStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_no_support_for_heterogeneous_lists() throws IOException {
        TestProjectionPassthrough.createTableAndLoad(NO_SUPPORT_FOR_HETEROGENEOUS_LISTS);
        try (DocumentStore docStore = this.getStore(NO_SUPPORT_FOR_HETEROGENEOUS_LISTS);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"values"}).where(connection_.newCondition().is("key", QueryCondition.Op.EQUAL, "key1").build()).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)1L, (long)docList.size());
            Document doc0 = docList.get(0);
            DocumentReader reader = doc0.asReader();
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
            Assert.assertEquals((Object)"values", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)reader.next());
            Assert.assertEquals((long)0L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)reader.next());
            Assert.assertEquals((long)1L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)true, (Object)reader.getBoolean());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((long)2L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)"eureka", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.LONG, (Object)reader.next());
            Assert.assertEquals((long)3L, (long)reader.getArrayIndex());
            Assert.assertEquals((long)127L, (long)reader.getLong());
            Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)reader.next());
            Assert.assertEquals((long)4L, (long)reader.getArrayIndex());
            Assert.assertEquals((double)3.4028235, (double)reader.getDouble(), (double)0.0);
            Assert.assertEquals((Object)DocumentReader.EventType.DATE, (Object)reader.next());
            Assert.assertEquals((long)5L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)ODate.parse((String)"2012-10-20"), (Object)reader.getDate());
            Assert.assertEquals((Object)DocumentReader.EventType.TIME, (Object)reader.next());
            Assert.assertEquals((long)6L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)OTime.parse((String)"07:42:46.123"), (Object)reader.getTime());
            Assert.assertEquals((Object)DocumentReader.EventType.TIMESTAMP, (Object)reader.next());
            Assert.assertEquals((long)7L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)OTimestamp.parse((String)"2012-10-20T14:42:46.123Z"), (Object)reader.getTimestamp());
            Assert.assertEquals((Object)DocumentReader.EventType.BINARY, (Object)reader.next());
            Assert.assertEquals((long)8L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
            Assert.assertEquals((long)9L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)reader.next());
            Assert.assertEquals((Object)"a_map", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertEquals((long)9L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
            Assert.assertEquals((long)10L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
            Assert.assertEquals((long)0L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)"an_array", (Object)reader.getString());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
            Assert.assertEquals((long)10L, (long)reader.getArrayIndex());
            Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
            Assert.assertEquals((Object)"values", (Object)reader.getFieldName());
            Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
            Assert.assertNull((Object)reader.next());
        }
        finally {
            TestProjectionPassthrough.closeAndDeleteTable(NO_SUPPORT_FOR_HETEROGENEOUS_LISTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_no_distinction_between_null_and_non_existent_fields() throws IOException {
        TestProjectionPassthrough.createTableAndLoad(NO_DISTINCTION_BETWEEN_NULL_AND_NON_EXISTENT_FIELDS);
        try (DocumentStore docStore = this.getStore(NO_DISTINCTION_BETWEEN_NULL_AND_NON_EXISTENT_FIELDS);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"age"}).where(connection_.newCondition().is("name", QueryCondition.Op.GREATER_OR_EQUAL, "user1").build()).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)3L, (long)docList.size());
            this.verifyNullAndMissingFields(docList.get(0), true, false);
            this.verifyNullAndMissingFields(docList.get(1), true, true);
            this.verifyNullAndMissingFields(docList.get(2), false, false);
        }
        finally {
            TestProjectionPassthrough.closeAndDeleteTable(NO_DISTINCTION_BETWEEN_NULL_AND_NON_EXISTENT_FIELDS);
        }
    }

    private void verifyNullAndMissingFields(Document document, boolean expectAgeField, boolean asNullType) {
        DocumentReader reader = document.asReader();
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        if (expectAgeField) {
            Assert.assertEquals((Object)(asNullType ? DocumentReader.EventType.NULL : DocumentReader.EventType.DOUBLE), (Object)reader.next());
            Assert.assertEquals((Object)"age", (Object)reader.getFieldName());
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_limited_support_for_fields_with_different_schema() throws IOException {
        TestProjectionPassthrough.createTableAndLoad(LIMITED_SUPPORT_FOR_FIELDS_WITH_DIFFERENT_SCHEMA);
        try (DocumentStore docStore = this.getStore(LIMITED_SUPPORT_FOR_FIELDS_WITH_DIFFERENT_SCHEMA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"*"}).where(connection_.newCondition().is("name", QueryCondition.Op.GREATER_OR_EQUAL, "user1").build()).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)4L, (long)docList.size());
            this.verifyDifferentSchemas(docList.get(0).asReader(), DocumentReader.EventType.DOUBLE, 0);
            this.verifyDifferentSchemas(docList.get(1).asReader(), DocumentReader.EventType.STRING, 0);
            this.verifyDifferentSchemas(docList.get(2).asReader(), DocumentReader.EventType.START_MAP, 3);
            this.verifyDifferentSchemas(docList.get(3).asReader(), DocumentReader.EventType.START_ARRAY, 11);
        }
        finally {
            TestProjectionPassthrough.closeAndDeleteTable(LIMITED_SUPPORT_FOR_FIELDS_WITH_DIFFERENT_SCHEMA);
        }
    }

    private void verifyDifferentSchemas(DocumentReader reader, DocumentReader.EventType phoneEventType, int skipEvents) {
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"_id", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"name", (Object)reader.getFieldName());
        Assert.assertEquals((Object)phoneEventType, (Object)reader.next());
        Assert.assertEquals((Object)"phone", (Object)reader.getFieldName());
        for (int i = 0; i < skipEvents; ++i) {
            Assert.assertNotNull((Object)reader.next());
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test_field_names_are_case_insensitive() throws IOException {
        TestProjectionPassthrough.createTableAndLoad(FIELD_NAMES_ARE_CASE_INSENSITIVE);
        try (DocumentStore docStore = this.getStore(FIELD_NAMES_ARE_CASE_INSENSITIVE);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"*"}).where(connection_.newCondition().is("age", QueryCondition.Op.GREATER_OR_EQUAL, 10).build()).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)3L, (long)docList.size());
            this.verifyDocumentsWithDifferentCaseFields(docList.get(0));
            this.verifyDocumentsWithDifferentCaseFields(docList.get(1));
            this.verifyDocumentsWithDifferentCaseFields(docList.get(2));
        }
        finally {
            TestProjectionPassthrough.closeAndDeleteTable(FIELD_NAMES_ARE_CASE_INSENSITIVE);
        }
    }

    private void verifyDocumentsWithDifferentCaseFields(Document doc) {
        DocumentReader reader = doc.asReader();
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"_id", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"AGE", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)reader.next());
        Assert.assertEquals((long)0L, (long)reader.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)reader.next());
        Assert.assertEquals((long)1L, (long)reader.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"AGE", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"Age", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)reader.next());
        Assert.assertEquals((Object)"age", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }

    @BeforeClass
    public static void createUserDataTable() throws Exception {
        TestProjectionPassthrough.createTableAndLoad(PROJECTION_PASSTHROUGH_USERDATA, (Map<String, String>)ImmutableMap.of((Object)"name", (Object)"name", (Object)"data", (Object)"data"));
        DBTests.createIndex((String)PROJECTION_PASSTHROUGH_USERDATA, (String)PROJECTION_PASSTHROUGH_USERDATA_INDEX, (String[])new String[]{"age"}, (String[])new String[]{"name.last", "data.salary"});
        DBTests.waitForRowCount((String)PROJECTION_PASSTHROUGH_USERDATA, (long)5L);
        DBTests.waitForIndexFlush((String)PROJECTION_PASSTHROUGH_USERDATA);
    }

    @AfterClass
    public static void deleteUserDataTable() throws Exception {
        TestProjectionPassthrough.closeAndDeleteTable(PROJECTION_PASSTHROUGH_USERDATA);
        connection_.close();
    }

    @Test
    public void test_bug_28353_array_projection() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"codes[1]"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)5L, (long)docList.size());
            this.verifyProjectedArrays(docList.get(0), 2, DocumentReader.EventType.NULL, DocumentReader.EventType.STRING);
            this.verifyProjectedArrays(docList.get(1), 0, new DocumentReader.EventType[0]);
            this.verifyProjectedArrays(docList.get(2), 0, new DocumentReader.EventType[0]);
            this.verifyProjectedArrays(docList.get(3), 2, DocumentReader.EventType.NULL, DocumentReader.EventType.DOUBLE);
            this.verifyProjectedArrays(docList.get(4), 0, new DocumentReader.EventType[0]);
        }
    }

    private void verifyProjectedArrays(Document doc, int array_length, DocumentReader.EventType ... elemTypes) {
        DocumentReader reader = doc.asReader();
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"codes", (Object)reader.getFieldName());
        for (int i = 0; i < array_length; ++i) {
            Assert.assertEquals((Object)elemTypes[i], (Object)reader.next());
            Assert.assertEquals((long)i, (long)reader.getArrayIndex());
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"codes", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }

    @Test
    public void test_bug_27909_full_table_scan_ordered_field_not_projected() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"age"}).orderBy(new String[]{"name.last"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            for (Document document : docList) {
                Assert.assertNull((Object)document.getValue("name.last"));
            }
        }
    }

    @Ignore(value="https://maprdrill.atlassian.net/browse/MD-2289")
    @Test
    public void test_bug_27909_index_scan_ordered_field_not_projected() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"name.last"}).orderBy(new String[]{"age"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)5L, (long)docList.size());
            for (Document document : docList) {
                Assert.assertNull((Object)document.getValue("age"));
            }
        }
    }

    @Test
    public void test_bug_27909_full_table_scan_ordered_field_projected() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"age", "name.last"}).orderBy(new String[]{"name.last"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)5L, (long)docList.size());
            String previousLastName = "";
            for (Document document : docList) {
                String lastName = document.getString("name.last");
                Assert.assertNotNull((Object)lastName);
                Assert.assertTrue((lastName.compareTo(previousLastName) >= 0 ? 1 : 0) != 0);
                previousLastName = lastName;
            }
        }
    }

    @Test
    public void test_bug_27909_index_scan_ordered_field_projected() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"name.last", "age"}).where("{\"$gt\": {\"age\": 0}}").orderBy(new String[]{"age"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)4L, (long)docList.size());
            int previousAge = Integer.MIN_VALUE;
            for (Document document : docList) {
                int age = document.getInt("age");
                Assert.assertTrue((age >= previousAge ? 1 : 0) != 0);
                previousAge = age;
            }
        }
    }

    @Test
    public void test_covering_query() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"name.last", "data.salary"}).where(connection_.newCondition().is("age", QueryCondition.Op.GREATER, 10).build()).orderBy(new String[]{"_id"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)4L, (long)docList.size());
            this.verifyUserData1(docList.get(0), "Harris", 125000L);
            this.verifyUserData1(docList.get(1), "Russel", "170200");
            this.verifyUserData1(docList.get(2), "Dylan", 136900L);
            this.verifyUserData1(docList.get(3), "Ackert", 112850L);
        }
    }

    private void verifyUserData1(Document user, String lastName, Object salary) {
        DocumentReader.EventType evt = null;
        DocumentReader reader = user.asReader();
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)"data", (Object)reader.getFieldName());
        evt = reader.next();
        Assert.assertEquals((Object)"salary", (Object)reader.getFieldName());
        if (evt == DocumentReader.EventType.LONG) {
            Assert.assertEquals((Object)salary, (Object)reader.getLong());
        } else if (evt == DocumentReader.EventType.STRING) {
            Assert.assertEquals((Object)salary, (Object)reader.getString());
        } else {
            Assert.fail((String)("Unexpected type: " + evt));
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)"name", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"last", (Object)reader.getFieldName());
        Assert.assertEquals((Object)lastName, (Object)reader.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }

    @Test
    public void test_non_covering_query() throws Exception {
        try (DocumentStore docStore = this.getStore(PROJECTION_PASSTHROUGH_USERDATA);){
            Query query = connection_.newQuery().setOption("ojai.mapr.force-drill", (Object)true).select(new String[]{"_id", "codes"}).where(connection_.newCondition().is("age", QueryCondition.Op.GREATER, 20).build()).orderBy(new String[]{"_id"}).build();
            List<Document> docList = OjaiTest.collectStreamingFind(docStore, query, 5, null);
            Assert.assertEquals((long)3L, (long)docList.size());
            this.verifyUserData2(docList.get(0), new DocumentReader.EventType[]{DocumentReader.EventType.DOUBLE, DocumentReader.EventType.STRING, DocumentReader.EventType.DOUBLE});
            this.verifyUserData2(docList.get(1), new DocumentReader.EventType[]{DocumentReader.EventType.TIMESTAMP, DocumentReader.EventType.DOUBLE});
            this.verifyUserData2(docList.get(2), new DocumentReader.EventType[]{DocumentReader.EventType.START_MAP, DocumentReader.EventType.DOUBLE, DocumentReader.EventType.STRING, DocumentReader.EventType.END_MAP});
        }
    }

    private void verifyUserData2(Document user, DocumentReader.EventType[] arrayEvents) {
        DocumentReader reader = user.asReader();
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)reader.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)reader.next());
        Assert.assertEquals((Object)"_id", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"codes", (Object)reader.getFieldName());
        for (DocumentReader.EventType arrayEvent : arrayEvents) {
            Assert.assertEquals((Object)arrayEvent, (Object)reader.next());
        }
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)reader.next());
        Assert.assertEquals((Object)"codes", (Object)reader.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)reader.next());
        Assert.assertNull((Object)reader.next());
    }
}

