/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.Admin;
import com.mapr.db.Table;
import com.mapr.db.impl.AdminImpl;
import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.ojai.store.impl.AbstractDocumentStream;
import com.mapr.ojai.store.impl.DelayDocumentFilter;
import com.mapr.ojai.store.impl.DummyDocumentStream;
import com.mapr.ojai.store.impl.EligibleIndex;
import com.mapr.ojai.store.impl.Expression;
import com.mapr.ojai.store.impl.ExpressionToCondition;
import com.mapr.ojai.store.impl.ExpressionToSql;
import com.mapr.ojai.store.impl.FieldInBundle;
import com.mapr.ojai.store.impl.LiteralExpression;
import com.mapr.ojai.store.impl.OjaiConnection;
import com.mapr.ojai.store.impl.OjaiDriver;
import com.mapr.ojai.store.impl.OjaiQuery;
import com.mapr.ojai.store.impl.OjaiTest;
import com.mapr.ojai.store.impl.QueryAnalyzer;
import com.mapr.ojai.store.impl.StringGenerator;
import com.mapr.ojai.store.impl.TimeoutDocumentFilter;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.QueryTimeoutException;
import org.ojai.store.Connection;
import org.ojai.store.DocumentStore;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.types.ODate;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

@Category(value={ClusterTest.class})
public class TestOjaiQuery
extends OjaiTest {
    private final OjaiDriver driver = TestOjaiQuery.getDriver();
    private static final int TIMEOUT_SECONDS = 5;
    private static final String[] bug28129States = new String[]{"TX", "MN", "NV", "CA", "NY", "VT", "OR"};

    @Test
    public void testOjaiQuery() {
        Query query = this.driver.newQuery().build();
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)(query instanceof OjaiQuery));
    }

    @Test
    public void testQueryGeneration() {
        Query query1 = this.driver.newQuery();
        query1.select(new String[]{"foo"});
        query1.select(new String[]{"bar.f", "baz[2]"});
        QueryCondition queryCond1 = this.driver.newCondition();
        queryCond1.is("foo", QueryCondition.Op.GREATER_OR_EQUAL, "abc").build();
        query1.where(queryCond1);
        OjaiQuery ojaiQuery1 = (OjaiQuery)query1.build();
        String sqlString1 = ojaiQuery1.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString1, "foo", "bar.f", "baz[2]", "_id");
        Query query2 = this.driver.newQuery();
        OjaiQuery ojaiQuery2 = (OjaiQuery)query2.build();
        String sqlString2 = ojaiQuery2.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString2, "*", "_id");
        Query query3 = this.driver.newQuery();
        QueryCondition queryCond3 = this.driver.newCondition();
        queryCond3.and().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, "abc").is("bar.f", QueryCondition.Op.EQUAL, "Acme").close().build();
        query3.where(queryCond3);
        OjaiQuery ojaiQuery3 = (OjaiQuery)query3.build();
        String sqlString3 = ojaiQuery3.buildSqlString("dfs", "foo");
        TestOjaiQuery.assertEncodedFields(sqlString3, "*", "_id");
    }

    @Test
    public void testQueryGeneration_offset() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.offset(2L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryGeneration_offsetError() {
        Query query = this.driver.newQuery().select(new String[]{"foo"}).offset(-2L).build();
    }

    @Test
    public void testQueryGeneration_offset_limit() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(2L);
        query.offset(4L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    @Test
    public void testQueryGeneration_limit() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(2L);
        OjaiQuery ojaiQuery = (OjaiQuery)query.build();
        String sqlString = ojaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sqlString, "foo", "_id");
    }

    private static void insertBug27262(Connection connection, Table table, String id, int i, String s) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("i1", i);
        doc.set("s1", s);
        table.insert(doc);
    }

    @Ignore(value="http://10.250.1.25/show_bug.cgi?id=26439")
    @Test
    public void testQuery_bug27262() throws Exception {
        String rawTableName = "bug27262";
        this.addCleanupTable("bug27262");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27262");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27262_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "1", 1, "foo");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "2", 2, "bar");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "3", 3, "baz");
            DBTests.waitForIndexFlush((String)"bug27262");
            DBTests.waitForRowCount((String)"bug27262", (long)3L);
            ArrayList emptyIntList = new ArrayList(0);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"i1"}).where(this.driver.newCondition().in("i1", emptyIntList).build()).build();
            try (DocumentStore docStore = ojaiConnection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    Assert.assertNotNull((Object)doc.getIdString());
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug27089() throws Exception {
        String rawTableName = "bug27089";
        this.addCleanupTable("bug27089");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27089");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27089_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "1", 1, "foo");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "2", 42, "bar");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "3", 3, "baz");
            TestOjaiQuery.insertBug27262((Connection)ojaiConnection, table, "4", 17, "tip");
            DBTests.waitForIndexFlush((String)"bug27089");
            DBTests.waitForRowCount((String)"bug27089", (long)4L);
            ArrayList<Integer> intList = new ArrayList<Integer>(0);
            intList.add(17);
            intList.add(42);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"i1"}).where(this.driver.newCondition().in("i1", intList).build()).build();
            try (DocumentStore docStore = ojaiConnection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery((Query)query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    int i = doc.getInt("i1");
                    Assert.assertTrue((boolean)intList.contains(i));
                    ++docCount;
                }
                Assert.assertEquals((long)2L, (long)docCount);
            }
        }
    }

    @Test
    public void testQuery_bug27469() throws Exception {
        String rawTableName = "bug27469";
        this.addCleanupTable("bug27469");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27469");){
            Throwable throwable;
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27469_idx", (boolean)false, (int)0, (String[])new String[]{"i1"}, null, null);
            TestOjaiQuery.insertBug27262((Connection)connection, table, "1", 1, "foo");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "2", 42, "bar");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "3", 3, "baz");
            TestOjaiQuery.insertBug27262((Connection)connection, table, "4", 17, "tip");
            DBTests.waitForIndexFlush((String)"bug27469");
            DBTests.waitForRowCount((String)"bug27469", (long)4L);
            Query queryNotEquals = connection.newQuery().select(new String[]{"i1", "_id"}).where(this.driver.newCondition().is("i1", QueryCondition.Op.NOT_EQUAL, 17).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);){
                throwable = null;
                try (DocumentStream docStream = docStore.findQuery(queryNotEquals);){
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        int i1 = doc.getInt("i1");
                        Assert.assertNotEquals((long)17L, (long)i1);
                        ++docCount;
                    }
                    Assert.assertEquals((long)3L, (long)docCount);
                }
                catch (Throwable docCount) {
                    throwable = docCount;
                    throw docCount;
                }
            }
            ArrayList<Integer> intList = new ArrayList<Integer>(0);
            intList.add(17);
            intList.add(42);
            Query query = connection.newQuery().select(new String[]{"i1", "_id"}).where(connection.newCondition().notIn("i1", intList).build()).build();
            throwable = null;
            try (DocumentStore docStore = connection.getStore(tableName);){
                DocumentStream docStream = docStore.findQuery(query);
                Object object = null;
                try {
                    int docCount = 0;
                    for (Document doc : docStream) {
                        String id = doc.getIdString();
                        Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                        int i = doc.getInt("i1");
                        Assert.assertFalse((boolean)intList.contains(i));
                        ++docCount;
                    }
                    Assert.assertEquals((long)2L, (long)docCount);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throw throwable2;
                }
                finally {
                    if (docStream != null) {
                        if (object != null) {
                            try {
                                docStream.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            docStream.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryGeneration_limitError() {
        Query query = this.driver.newQuery();
        query.select(new String[]{"foo"});
        query.limit(-2L);
    }

    private Query makeEhcTestCase(Query query, String s1, String s2) {
        QueryCondition queryCond = this.driver.newCondition();
        queryCond.and().is("foo", QueryCondition.Op.GREATER_OR_EQUAL, s1).is("bar.f", QueryCondition.Op.EQUAL, s2).close().build();
        query.select(new String[]{"foo"}).select(new String[]{"bar"}).limit(17L).offset(42L).where(queryCond);
        return query.build();
    }

    @Test
    public void testQuery_equals_hashCode() {
        OjaiQuery query1 = (OjaiQuery)this.driver.newQuery();
        this.makeEhcTestCase((Query)query1, "abc", "Acme");
        OjaiQuery query2 = (OjaiQuery)this.driver.newQuery();
        this.makeEhcTestCase((Query)query2, "abc", "Excelsior");
        Assert.assertTrue((boolean)query1.structuralEquals(query2));
        Assert.assertEquals((long)query1.structuralHashCode(), (long)query2.structuralHashCode());
        Equivalence.Wrapper wrap1 = OjaiQuery.EQUIVALENCE.wrap((Object)query1);
        Equivalence.Wrapper wrap2 = OjaiQuery.EQUIVALENCE.wrap((Object)query2);
        Assert.assertTrue((boolean)wrap1.equals((Object)wrap2));
        Assert.assertEquals((long)wrap1.hashCode(), (long)wrap2.hashCode());
        QueryCondition queryCond3 = this.driver.newCondition();
        queryCond3.or().is("x", QueryCondition.Op.EQUAL, "x").is("y", QueryCondition.Op.EQUAL, "y").close().build();
        OjaiQuery query3 = (OjaiQuery)this.driver.newQuery();
        query3.select(new String[]{"baz"}).where(queryCond3).build();
        Assert.assertFalse((boolean)query3.structuralEquals(query1));
        Assert.assertNotEquals((long)query3.structuralHashCode(), (long)query1.structuralHashCode());
        Equivalence.Wrapper wrap3 = OjaiQuery.EQUIVALENCE.wrap((Object)query3);
        Assert.assertFalse((boolean)wrap3.equals((Object)wrap1));
        Assert.assertNotEquals((long)wrap3.hashCode(), (long)wrap1.hashCode());
    }

    @Test
    public void testFlatteningLogicalOperators() {
        OjaiQuery query1 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().build()).build();
        String sql1 = query1.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql1, "*", "_id");
        OjaiQuery query2 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").and().is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().close().build()).build();
        String sql2 = query2.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql2, "*", "_id");
        OjaiQuery query3 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").close().and().is("baz", QueryCondition.Op.EQUAL, "z").is("gleep", QueryCondition.Op.EQUAL, "w").close().close().build()).build();
        String sql3 = query3.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql3, "*", "_id");
        OjaiQuery query4 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().and().is("foo", QueryCondition.Op.EQUAL, "x").is("bar", QueryCondition.Op.EQUAL, "y").close().or().is("baz", QueryCondition.Op.EQUAL, "z").is("baz", QueryCondition.Op.EQUAL, "q").or().is("baz", QueryCondition.Op.EQUAL, "r").is("baz", QueryCondition.Op.EQUAL, "s").close().close().and().is("gleep", QueryCondition.Op.EQUAL, "w").is("flubber", QueryCondition.Op.EQUAL, "t").close().close().build()).build();
        String sql4 = query4.buildSqlString("dfs", "mytable");
        TestOjaiQuery.assertEncodedFields(sql4, "*", "_id");
    }

    @Test
    public void testIdEquals() {
        String theId = "x";
        OjaiQuery queryId = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "x").build()).build();
        QueryAnalyzer idAnalzyer = queryId.getQueryAnalyzer();
        Assert.assertTrue((boolean)idAnalzyer.isIdEquals());
        Assert.assertEquals((Object)"x", (Object)idAnalzyer.getIdForLookup());
        OjaiQuery queryOther = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().is("foo", QueryCondition.Op.EQUAL, "x").build()).build();
        QueryAnalyzer otherAnalyzer = queryOther.getQueryAnalyzer();
        Assert.assertFalse((boolean)otherAnalyzer.isIdEquals());
    }

    private static boolean hasSameLiterals(List<String> idList, List<LiteralExpression> values) {
        if (idList.size() != values.size()) {
            return false;
        }
        ArrayList<String> sortedIdList = new ArrayList<String>(idList);
        Collections.sort(sortedIdList);
        ArrayList<String> sortedValueList = new ArrayList<String>(values.size());
        for (LiteralExpression litExpr : values) {
            sortedValueList.add(litExpr.getString());
        }
        Collections.sort(sortedValueList);
        return sortedIdList.equals(sortedValueList);
    }

    @Test
    public void testFieldIn() {
        LinkedList<String> idList = new LinkedList<String>();
        idList.add("x");
        idList.add("y");
        idList.add("z");
        idList.add("w");
        OjaiQuery queryIn = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().in(DocumentConstants.ID_FIELD, idList).build()).build();
        QueryAnalyzer inAnalyzer = queryIn.getQueryAnalyzer();
        FieldInBundle fibIn = inAnalyzer.getFieldInBundle();
        Assert.assertNotNull((Object)fibIn);
        Assert.assertEquals((Object)DocumentConstants.ID_FIELD, (Object)fibIn.fieldPath);
        Assert.assertTrue((boolean)TestOjaiQuery.hasSameLiterals(idList, fibIn.values));
        OjaiQuery queryOrEquals = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().or().or().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "z").is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "w").close().is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "y").is(DocumentConstants.ID_FIELD, QueryCondition.Op.EQUAL, "x").close().build()).build();
        QueryAnalyzer orEqualsAnalyzer = queryOrEquals.getQueryAnalyzer();
        FieldInBundle fibOrEquals = orEqualsAnalyzer.getFieldInBundle();
        Assert.assertNotNull((Object)fibOrEquals);
        Assert.assertEquals((Object)DocumentConstants.ID_FIELD, (Object)fibOrEquals.fieldPath);
        Assert.assertTrue((boolean)TestOjaiQuery.hasSameLiterals(idList, fibOrEquals.values));
    }

    private static Document insertAbc(OjaiConnection ojaiConnection, Table table, String id, int a, int b, int c) {
        Document document = ojaiConnection.newDocument();
        document.set("_id", id);
        document.set("a", a);
        document.set("b", b);
        document.set("c", c);
        table.insert(document);
        return document;
    }

    @Test
    public void testPlanning_eligibleIndexes() throws Exception {
        String rawTableName = "ei_one";
        this.addCleanupTable("ei_one");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_one");){
            Path tablePath = table.getPath();
            OjaiQuery querya = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).where(this.driver.newCondition().and().is("a", QueryCondition.Op.LESS, 42).is("a", QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            List indexes = querya.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)0L, (long)indexes.size());
            String coveringName = "aIdx";
            DBTests.createIndex((Table)table, (String)"aIdx", (boolean)false, (int)0, (String[])new String[]{"a"}, null, (String[])new String[]{"b"});
            indexes = querya.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            IndexDesc indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            String goldConditiona = "((a < {\"$numberLong\":42}) and (a >= {\"$numberLong\":12}))";
            QueryCondition scanConditiona = querya.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"((a < {\"$numberLong\":42}) and (a >= {\"$numberLong\":12}))", (Object)scanConditiona.toString());
            String nonCoveringName = "cIdx";
            DBTests.createIndex((Table)table, (String)"cIdx", (boolean)false, (int)0, (String[])new String[]{"c"}, null, null);
            indexes = querya.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)1L, (long)indexes.size());
            eligibleIndex = (EligibleIndex)indexes.get(0);
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            OjaiQuery queryac = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is("a", QueryCondition.Op.LESS, 42).is("c", QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            indexes = queryac.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)2L, (long)indexes.size());
            Collections.sort(indexes, new Comparator<EligibleIndex>(){

                @Override
                public int compare(EligibleIndex o1, EligibleIndex o2) {
                    return DBTests.getNameWithoutPath((String)o1.indexDesc.getIndexName()).compareTo(DBTests.getNameWithoutPath((String)o2.indexDesc.getIndexName()));
                }
            });
            eligibleIndex = (EligibleIndex)indexes.get(0);
            indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"aIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertFalse((boolean)eligibleIndex.isCovering);
            String goldScanConditionaOpen = "(a < {\"$numberLong\":42})";
            QueryCondition scanConditionaOpen = queryac.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"(a < {\"$numberLong\":42})", (Object)scanConditionaOpen.toString());
            eligibleIndex = (EligibleIndex)indexes.get(1);
            indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"cIdx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertFalse((boolean)eligibleIndex.isCovering);
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            String goldScanConditioncOpen = "(c >= {\"$numberLong\":12})";
            QueryCondition scanConditioncOpen = queryac.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"(c >= {\"$numberLong\":12})", (Object)scanConditioncOpen.toString());
            Document includedDoc = TestOjaiQuery.insertAbc(ojaiConnection, table, "1", 30, 45, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "2", 45, 100, 17);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "3", 50, 144, 0);
            table.flush();
            DBTests.waitForIndexFlush((Path)tablePath);
            DocumentStore docStore = ojaiConnection.getStore(tablePath.toString());
            OjaiTest.DocumentStreamRef docRef = new OjaiTest.DocumentStreamRef();
            Query queryaeq = this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).where(this.driver.newCondition().is("a", QueryCondition.Op.EQUAL, 30).build()).build();
            List<Document> queryaeqResult = OjaiTest.collectStreamingFind(docStore, queryaeq, 5, docRef);
            Assert.assertEquals((long)1L, (long)queryaeqResult.size());
            Assert.assertTrue((boolean)OjaiTest.isNearlyEqual(includedDoc, queryaeqResult.get(0)));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docRef.docStream));
            List<Document> queryaResult = OjaiTest.collectStreamingFind(docStore, (Query)querya, 5, docRef);
            Assert.assertEquals((long)1L, (long)queryaResult.size());
            Assert.assertTrue((boolean)OjaiTest.isNearlyEqual(includedDoc, queryaResult.get(0)));
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docRef.docStream));
        }
    }

    @Test
    public void testPlanning_sortKeyIndexSuffix() throws Exception {
        String rawTableName = "ei_suffix_sort";
        this.addCleanupTable("ei_suffix_sort");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_suffix_sort");){
            Path tablePath = table.getPath();
            OjaiQuery querya = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"}).select(new String[]{"b"}).select(new String[]{"c"}).where(this.driver.newCondition().and().is("a", QueryCondition.Op.EQUAL, 42).is("b", QueryCondition.Op.EQUAL, 17).close().build()).orderBy("c", SortOrder.ASC).build();
            List indexes = querya.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)0L, (long)indexes.size());
            String coveringName = "abc_Idx";
            DBTests.createIndex((Table)table, (String)"abc_Idx", (boolean)false, (int)0, (String[])new String[]{"a", "b", "c"}, (SortOrder[])new SortOrder[]{SortOrder.DESC}, null);
            indexes = querya.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            IndexDesc indexDesc = eligibleIndex.indexDesc;
            Assert.assertEquals((Object)"abc_Idx", (Object)DBTests.getNameWithoutPath((String)indexDesc.getIndexName()));
            Assert.assertEquals((Object)tablePath.toString(), (Object)indexDesc.getPrimaryTablePath());
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            String goldConditiona = "((a = {\"$numberLong\":42}) and (b = {\"$numberLong\":17}))";
            QueryCondition scanConditiona = querya.getScanCondition(ojaiConnection, eligibleIndex);
            Assert.assertEquals((Object)"((a = {\"$numberLong\":42}) and (b = {\"$numberLong\":17}))", (Object)scanConditiona.toString());
            TestOjaiQuery.insertAbc(ojaiConnection, table, "1", 41, 16, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "2", 43, 18, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "3", 42, 17, 7);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "4", 42, 17, 5);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "5", 42, 17, 6);
            TestOjaiQuery.insertAbc(ojaiConnection, table, "6", 42, 17, 4);
            DBTests.waitForIndexFlush((Path)tablePath);
            DBTests.waitForRowCount((String)"ei_suffix_sort", (long)6L);
            DocumentStore docStore = ojaiConnection.getStore(tablePath.toString());
            DocumentStream docStream = docStore.findQuery((Query)querya);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
            int docCount = 0;
            int lastC = Integer.MIN_VALUE;
            for (Document doc : docStream) {
                ++docCount;
                int c = doc.getInt("c");
                Assert.assertTrue((c > lastC ? 1 : 0) != 0);
                lastC = c;
            }
            Assert.assertEquals((long)4L, (long)docCount);
        }
    }

    @Ignore(value="http://10.250.1.25/show_bug.cgi?id=27662")
    @Test
    public void testPlanning_hashedIndexSort() throws Exception {
        String rawTableName = "ei_hashed";
        this.addCleanupTable("ei_hashed");
        AdminImpl admin = DBTests.admin();
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"ei_hashed");){
            Path tablePath = table.getPath();
            DBTests.createIndex((Table)table, (String)"ei_hashed_hashedIdx", (boolean)true, (int)2, (String[])new String[]{"c"}, null, null);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"a", "b", "c"}).where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, 42).build()).build();
            List indexes = query.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)1L, (long)indexes.size());
            OjaiQuery querySort = (OjaiQuery)this.driver.newQuery().select(new String[]{"a", "b", "c"}).where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, 42).build()).orderBy("c", SortOrder.ASC).build();
            indexes = querySort.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)0L, (long)indexes.size());
        }
    }

    @Test
    public void testQuery_analyzerPruning() {
        String tableAlias = "t";
        FieldPath fpa = FieldPath.parseFrom((String)"a");
        HashSet<FieldPath> aSet = new HashSet<FieldPath>(1);
        aSet.add(fpa);
        FieldPath fpc = FieldPath.parseFrom((String)"c");
        HashSet<FieldPath> cSet = new HashSet<FieldPath>(1);
        cSet.add(fpc);
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            OjaiQuery oq1 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is(fpa, QueryCondition.Op.LESS, 42).is(fpc, QueryCondition.Op.GREATER_OR_EQUAL, 12).close().build()).build();
            QueryAnalyzer qa1 = oq1.getQueryAnalyzer();
            String a1SqlGold = "(t.`a` < 42)";
            Expression a1Expr = qa1.getPrunedExpression(aSet);
            String a1Sql = ExpressionToSql.convert((Expression)a1Expr, (String)"t");
            Assert.assertEquals((Object)"(t.`a` < 42)", (Object)a1Sql);
            String a1CondGold = "(a < {\"$numberLong\":42})";
            QueryCondition aqc1 = ExpressionToCondition.convert((Expression)a1Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"(a < {\"$numberLong\":42})", (Object)aqc1.toString());
            String c1SqlGold = "(t.`c` >= 12)";
            Expression c1Expr = qa1.getPrunedExpression(cSet);
            String c1Sql = ExpressionToSql.convert((Expression)c1Expr, (String)"t");
            Assert.assertEquals((Object)"(t.`c` >= 12)", (Object)c1Sql);
            String c1CondGold = "(c >= {\"$numberLong\":12})";
            QueryCondition cqc1 = ExpressionToCondition.convert((Expression)c1Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"(c >= {\"$numberLong\":12})", (Object)cqc1.toString());
            ImmutableList aList = ImmutableList.of((Object)19, (Object)23, (Object)47);
            OjaiQuery oq2 = (OjaiQuery)this.driver.newQuery().where(this.driver.newCondition().and().is(fpa, QueryCondition.Op.LESS, 42).is(fpc, QueryCondition.Op.GREATER_OR_EQUAL, 12).and().is("b", QueryCondition.Op.EQUAL, 7).is(fpc, QueryCondition.Op.LESS, 144).in(fpa, (List)aList).close().close().build()).build();
            QueryAnalyzer qa2 = oq2.getQueryAnalyzer();
            String a2SqlGold = "((t.`a` < 42) and ((t.`a` = 19) or (t.`a` = 23) or (t.`a` = 47)))";
            Expression a2Expr = qa2.getPrunedExpression(aSet);
            String a2Sql = ExpressionToSql.convert((Expression)a2Expr, (String)"t");
            Assert.assertEquals((Object)"((t.`a` < 42) and ((t.`a` = 19) or (t.`a` = 23) or (t.`a` = 47)))", (Object)a2Sql);
            String a2CondGold = "((a < {\"$numberLong\":42}) and ((a = {\"$numberLong\":19}) or (a = {\"$numberLong\":23}) or (a = {\"$numberLong\":47})))";
            QueryCondition aqc2 = ExpressionToCondition.convert((Expression)a2Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"((a < {\"$numberLong\":42}) and ((a = {\"$numberLong\":19}) or (a = {\"$numberLong\":23}) or (a = {\"$numberLong\":47})))", (Object)aqc2.toString());
            String c2SqlGold = "((t.`c` >= 12) and (t.`c` < 144))";
            Expression c2Expr = qa2.getPrunedExpression(cSet);
            String c2Sql = ExpressionToSql.convert((Expression)c2Expr, (String)"t");
            Assert.assertEquals((Object)"((t.`c` >= 12) and (t.`c` < 144))", (Object)c2Sql);
            String c2CondGold = "((c >= {\"$numberLong\":12}) and (c < {\"$numberLong\":144}))";
            QueryCondition cqc2 = ExpressionToCondition.convert((Expression)c2Expr, (OjaiConnection)ojaiConnection);
            Assert.assertEquals((Object)"((c >= {\"$numberLong\":12}) and (c < {\"$numberLong\":144}))", (Object)cqc2.toString());
        }
    }

    @Test
    public void testQueryGeneration_udf() {
        Query sizeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().sizeOf("foo", QueryCondition.Op.GREATER_OR_EQUAL, 2L).build());
        OjaiQuery sizeOfOjaiQuery = (OjaiQuery)sizeOfQuery.build();
        String sizeOfSqlString = sizeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(sizeOfSqlString, "foo", "_id");
        Query typeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().typeOf("foo", Value.Type.STRING).build());
        OjaiQuery typeOfOjaiQuery = (OjaiQuery)typeOfQuery.build();
        String typeOfSqlString = typeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(typeOfSqlString, "foo", "_id");
        Query notTypeOfQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().notTypeOf("foo", Value.Type.INT).build());
        OjaiQuery notTypeOfOjaiQuery = (OjaiQuery)notTypeOfQuery.build();
        String notTypeOfSqlString = notTypeOfOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(notTypeOfSqlString, "foo", "_id");
        Query matchesQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().matches("foo", "[0-9]+").build());
        OjaiQuery matchesOjaiQuery = (OjaiQuery)matchesQuery.build();
        String matchesSqlString = matchesOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(matchesSqlString, "foo", "_id");
        Query notMatchesQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().notMatches("foo", "[0-9]+").build());
        OjaiQuery notMatchesOjaiQuery = (OjaiQuery)notMatchesQuery.build();
        String notMatchesSqlString = notMatchesOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(notMatchesSqlString, "foo", "_id");
        LinkedList<Integer> equalsList = new LinkedList<Integer>();
        equalsList.add(17);
        equalsList.add(42);
        equalsList.add(2010);
        Query equalsQuery = this.driver.newQuery().select(new String[]{"foo"}).where(this.driver.newCondition().equals("foo", equalsList).build());
        OjaiQuery equalsOjaiQuery = (OjaiQuery)equalsQuery.build();
        String equalsSqlString = equalsOjaiQuery.buildSqlString("dfs", "sometable");
        TestOjaiQuery.assertEncodedFields(equalsSqlString, "foo", "_id");
    }

    @Test
    public void testQueryOnInt() throws Exception {
        QueryOnInt test = new QueryOnInt();
        String rawTableName = "conditionOnIntTest";
        this.addCleanupTable("conditionOnIntTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnIntTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnIntTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnIntTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnIntTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnTime() throws Exception {
        QueryOnTime test = new QueryOnTime();
        String rawTableName = "conditionOnTimeTest";
        this.addCleanupTable("conditionOnTimeTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnTimeTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnTimeTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnTimeTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnTimeTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnTimestamp() throws Exception {
        QueryOnTimestamp test = new QueryOnTimestamp();
        String rawTableName = "conditionOnTimestampTest";
        this.addCleanupTable("conditionOnTimestampTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnTimestampTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, "conditionOnTimestampTest", table);
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnTimestampTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnTimestampTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueryOnDate() throws Exception {
        String rawTableName = "conditionOnDateTest";
        this.addCleanupTable("conditionOnDateTest");
        QueryOnDate test = new QueryOnDate();
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnDateTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            test.insertDocs((Connection)connection, table, "conditionOnDateTest");
            try (DocumentStore docStore = connection.getStore(tableName);){
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
                DBTests.createIndex((Table)table, (String)"conditionOnDateTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnDateTest");
                test.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    @Test
    public void testQueriesOnDateTimestampTime() throws Exception {
        String rawTableName = "conditionOnDateTimestampTimeTest";
        this.addCleanupTable("conditionOnDateTimestampTimeTest");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"conditionOnDateTimestampTimeTest");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            QueriesOnDateTimestampTime.insertDocs((Connection)connection, table);
            DBTests.waitForRowCount((String)"conditionOnDateTimestampTimeTest", (long)9L);
            try (DocumentStore docStore = connection.getStore(tableName);){
                DBTests.createIndex((Table)table, (String)"conditionOnDateTimestampTimeTest_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
                DBTests.waitForIndexFlush((String)"conditionOnDateTimestampTimeTest");
                QueriesOnDateTimestampTime.runQueries((Connection)connection, docStore, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    private static void insertBug27093(Connection connection, Table table, String id, ODate d1, ODate d2) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("d1", d1);
        doc.set("d2", d2);
        table.insert(doc);
    }

    @Test
    public void testQuery_bug27093() throws Exception {
        String rawTableName = "bug27093";
        this.addCleanupTable("bug27093");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27093");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug27093_idx";
            DBTests.createIndex((Table)table, (String)"bug27093_idx", (boolean)false, (int)0, (String[])new String[]{"d1", "d2"}, null, null);
            ODate theDate = new ODate(2001, 4, 5);
            TestOjaiQuery.insertBug27093((Connection)connection, table, "1", new ODate(2000, 3, 4), new ODate(2017, 5, 15));
            TestOjaiQuery.insertBug27093((Connection)connection, table, "2", theDate, new ODate(2017, 5, 15));
            TestOjaiQuery.insertBug27093((Connection)connection, table, "3", new ODate(2002, 5, 6), new ODate(2017, 5, 15));
            DBTests.waitForIndexFlush((String)"bug27093");
            DBTests.waitForRowCount((String)"bug27093", (long)3L);
            Query query = connection.newQuery().select(new String[]{"d1"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, theDate).close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)"2", (Object)id);
                    ODate d1 = doc.getDate("d1");
                    Assert.assertEquals((Object)theDate, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                Assert.assertEquals((Object)"bug27093_idx", (Object)TestOjaiQuery.getIndexUsed(docStream));
            }
        }
    }

    private static void insertBug27256(Connection connection, Table table, String id, String bytesAsString, int i) {
        Document doc = connection.newDocument();
        doc.setId(id);
        ByteBuffer d1 = ByteBuffer.wrap(bytesAsString.getBytes());
        doc.set("b1", d1);
        doc.set("i1", i);
        table.insert(doc);
    }

    @Test
    public void testQuery_bug27256() throws Exception {
        String rawTableName = "q_binary";
        this.addCleanupTable("q_binary");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"q_binary");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"q_binary_idx", (boolean)false, (int)0, (String[])new String[]{"b1"}, null, null);
            String theOne = "The quick brown fox jumped over the lazy dog.";
            byte[] theOneBytes = "The quick brown fox jumped over the lazy dog.".getBytes();
            ByteBuffer theOneBuffer = ByteBuffer.wrap(theOneBytes);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "1", "foo", 1);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "2", "The quick brown fox jumped over the lazy dog.", 2);
            TestOjaiQuery.insertBug27256((Connection)ojaiConnection, table, "3", "bar", 3);
            DBTests.waitForIndexFlush((String)"q_binary");
            DBTests.waitForRowCount((String)"q_binary", (long)3L);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"b1"}).where(this.driver.newCondition().and().is("b1", QueryCondition.Op.EQUAL, theOneBuffer).close().build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertEquals((Object)"2", (Object)id);
                ByteBuffer b1 = doc.getBinary("b1");
                Assert.assertArrayEquals((byte[])theOneBytes, (byte[])b1.array());
                ++docCount;
            }
            Assert.assertEquals((long)1L, (long)docCount);
        }
    }

    @Test
    public void testQuery_bug27302() throws Exception {
        String rawTableName = "bug27302";
        this.addCleanupTable("bug27302");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27302");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27302_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, null, null);
            int nRows = 300;
            StringGenerator idGenerator = new StringGenerator(5, 27302L);
            Random valueGenerator = new Random(27302L);
            for (int i = 0; i < 300; ++i) {
                Document doc = ojaiConnection.newDocument();
                String id = idGenerator.nextUniqueString();
                int value = valueGenerator.nextInt(10);
                doc.setId(id);
                doc.set("v1", value);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27302");
            DBTests.waitForRowCount((String)"bug27302", (long)300L);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"_id"}).where(this.driver.newCondition().and().is("_id", QueryCondition.Op.GREATER, "ccc").is("v1", QueryCondition.Op.GREATER, 4).close().build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document doc : docStream) {
                Assert.assertNotNull((Object)doc.getId());
                ++docCount;
            }
            Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQuery_bug27529() throws Exception {
        String rawTableName = "bug27529";
        this.addCleanupTable("bug27529");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27529");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27529_idx", (boolean)false, (int)0, (String[])new String[]{"v1.a"}, null, null);
            int nRows = 300;
            StringGenerator idGenerator = new StringGenerator(5, 27529L);
            Random valueGenerator = new Random(27529L);
            int v1aGenerator = 0;
            for (int i = 0; i < 300; ++i) {
                Document doc = ojaiConnection.newDocument();
                String id = idGenerator.nextUniqueString();
                doc.setId(id);
                int v1a = ++v1aGenerator;
                int v1b = valueGenerator.nextInt(100);
                int v2 = valueGenerator.nextInt(100);
                Document vDoc = ojaiConnection.newDocument();
                vDoc.set("a", v1a);
                vDoc.set("b", v1b);
                doc.set("v1", vDoc);
                doc.set("v2", v2);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27529");
            DBTests.waitForRowCount((String)"bug27529", (long)300L);
            int v1aBound = 250;
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"v1.a", "_id"}).where(this.driver.newCondition().is("v1.a", QueryCondition.Op.GREATER, 250).build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document doc : docStream) {
                Assert.assertNotNull((Object)doc.getId());
                ++docCount;
            }
            Assert.assertEquals((long)50L, (long)docCount);
        }
    }

    @Test
    public void testQuery_timeoutFilter() {
        try (final OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            ExecutorService executorService = ojaiConnection.getExecutorService();
            DummyDocumentStream dummyStream = new DummyDocumentStream(executorService){
                private int idGen;

                @Override
                protected Document nextDocument() {
                    ++this.idGen;
                    Document doc = ojaiConnection.newDocument();
                    doc.setId(Integer.toString(this.idGen));
                    doc.set("i", this.idGen);
                    return doc;
                }
            };
            DelayDocumentFilter delayFilter = new DelayDocumentFilter((DocumentStream)dummyStream, executorService, 5000);
            try (TimeoutDocumentFilter timeoutFilter = new TimeoutDocumentFilter((DocumentStream)delayFilter, executorService, 2000L);){
                final CountDownLatch failedSignal = new CountDownLatch(1);
                long startTime = System.currentTimeMillis();
                timeoutFilter.streamTo(new DocumentListener(){

                    public boolean documentArrived(Document arg0) {
                        Assert.fail();
                        return false;
                    }

                    public void eos() {
                        Assert.fail();
                    }

                    public void failed(Exception ex) {
                        Assert.assertTrue((boolean)(ex instanceof QueryTimeoutException));
                        failedSignal.countDown();
                    }
                });
                int testTimeout = 6000;
                try {
                    failedSignal.await(6000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    Assert.fail();
                }
                long endTime = System.currentTimeMillis();
                long elapsedTime = endTime - startTime;
                Assert.assertTrue((elapsedTime < 6000L ? 1 : 0) != 0);
                System.out.println("Actual time elapsed " + elapsedTime);
            }
        }
    }

    @Test
    public void testQuery_iteratorTimeout() throws Exception {
        try (final OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();){
            final ExecutorService executorService = ojaiConnection.getExecutorService();
            final long[] sleep = new long[]{100L, 500L, 3000L};
            AbstractDocumentStream documentSource = new AbstractDocumentStream(){
                int idGenerator = 0;

                public void streamTo(final DocumentListener docListener) {
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            for (long sleepTime : sleep) {
                                try {
                                    Thread.sleep(sleepTime);
                                }
                                catch (InterruptedException ie) {
                                    Assert.fail((String)ie.toString());
                                }
                                Document doc = ojaiConnection.newDocument();
                                doc.setId(Integer.toString(++idGenerator));
                                docListener.documentArrived(doc);
                            }
                            docListener.eos();
                        }
                    });
                }
            };
            try (TimeoutDocumentFilter timeoutFilter = new TimeoutDocumentFilter((DocumentStream)documentSource, executorService, 2000L);){
                int docCount = 0;
                boolean timedOut = false;
                try {
                    for (Document doc : timeoutFilter) {
                        Assert.assertNotNull((Object)doc.getIdString());
                        ++docCount;
                        Thread.sleep(5000L);
                    }
                }
                catch (QueryTimeoutException qte) {
                    timedOut = true;
                }
                Assert.assertTrue((boolean)timedOut);
                Assert.assertEquals((long)2L, (long)docCount);
            }
        }
    }

    @Test(expected=QueryTimeoutException.class)
    public void testQuery_timeoutOption() throws Exception {
        String rawTableName = "timeout_option";
        this.addCleanupTable("timeout_option");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"timeout_option");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"timeout_option_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, null, null);
            int nRows = 300;
            StringGenerator idGenerator = new StringGenerator(5, 27302L);
            Random valueGenerator = new Random(27302L);
            for (int i = 0; i < 300; ++i) {
                Document doc = ojaiConnection.newDocument();
                String id = idGenerator.nextUniqueString();
                int value = valueGenerator.nextInt(10);
                doc.setId(id);
                doc.set("v1", value);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"timeout_option");
            DBTests.waitForRowCount((String)"timeout_option", (long)300L);
            OjaiQuery query = (OjaiQuery)this.driver.newQuery().setTimeout(1L).select(new String[]{"_id"}).where(this.driver.newCondition().is("v1", QueryCondition.Op.GREATER, 4).build()).build();
            DocumentStore docStore = ojaiConnection.getStore(tableName);
            DocumentStream docStream = docStore.findQuery((Query)query);
            int docCount = 0;
            for (Document doc : docStream) {
                ++docCount;
            }
        }
    }

    @Test
    public void testFindWithUnbuiltQuery() throws Exception {
        String rawTableName = "testFindWithUnbuiltQuery";
        this.addCleanupTable("testFindWithUnbuiltQuery");
        try (OjaiConnection ojaiConnection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"testFindWithUnbuiltQuery");){
            String tableName = table.getPath().toString();
            try (DocumentStore docStore = ojaiConnection.getStore(tableName);){
                OjaiQuery query = (OjaiQuery)this.driver.newQuery().select(new String[]{"a"});
                docStore.findQuery((Query)query);
                Assert.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testQuery_bug27042() throws Exception {
        String rawTableName = "bug27042";
        this.addCleanupTable("bug27042");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27042");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug27042_idx", (boolean)false, (int)0, (String[])new String[]{"v1"}, null, null);
            int nRows = 40;
            for (int i = 1; i <= 40; ++i) {
                Document doc = connection.newDocument();
                doc.setId(Integer.toString(i));
                OTimestamp v = new OTimestamp(1, 2, 3, 4, 5, 6 + i, 7);
                doc.set("v1", v);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27042");
            DBTests.waitForRowCount((String)"bug27042", (long)40L);
            OTimestamp midTs = new OTimestamp(1, 2, 3, 4, 5, 26, 7);
            Query query = connection.newQuery().select(new String[]{"v1"}).where(connection.newCondition().is("v1", QueryCondition.Op.GREATER, midTs).build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    OTimestamp v = doc.getTimestamp("v1");
                    Assert.assertTrue((v.compareTo(midTs) > 0 ? 1 : 0) != 0);
                    ++docCount;
                }
                Assert.assertEquals((long)20L, (long)docCount);
            }
        }
    }

    @Test
    public void testApi_bug27883() {
        Query query = this.driver.newQuery().select(new String[]{"a", "_id"}).where(this.driver.newCondition().build()).build();
    }

    @Test
    public void testPlanning_bug27679() throws Exception {
        String rawTableName = "bug27679";
        this.addCleanupTable("bug27679");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27679");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug27679_idx";
            DBTests.createIndex((Table)table, (String)"bug27679_idx", (boolean)false, (int)0, (String[])new String[]{"a", "b", "c", "d"}, null, null);
            int nRows = 10;
            for (int i = 1; i <= 10; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                doc.set("a", i);
                doc.set("b", i * 10);
                doc.set("c", i * 100);
                doc.set("d", i * 1000);
                table.insert(doc);
            }
            DBTests.waitForIndexFlush((String)"bug27679");
            DBTests.waitForRowCount((String)"bug27679", (long)10L);
            Query query = connection.newQuery().select(new String[]{"a", "b", "c"}).where(connection.newCondition().and().is("a", QueryCondition.Op.EQUAL, 5).is("c", QueryCondition.Op.EQUAL, 500).close().build()).build();
            OjaiQuery ojaiQuery = (OjaiQuery)query;
            AdminImpl admin = DBTests.admin();
            List indexes = ojaiQuery.analyzeQuery((Admin)admin, tablePath);
            Assert.assertEquals((long)1L, (long)indexes.size());
            EligibleIndex eligibleIndex = (EligibleIndex)indexes.get(0);
            Assert.assertTrue((boolean)eligibleIndex.isCovering);
            Assert.assertEquals((Object)"bug27679_idx", (Object)eligibleIndex.indexDesc.getIndexName());
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.valueOf(id) > 0 ? 1 : 0) != 0);
                    int a = doc.getInt("a");
                    int b = doc.getInt("b");
                    int c = doc.getInt("c");
                    Integer dObject = doc.getIntObj("d");
                    Assert.assertNull((Object)dObject);
                    Assert.assertTrue((c == b * 10 ? 1 : 0) != 0);
                    Assert.assertTrue((b == a * 10 ? 1 : 0) != 0);
                    Assert.assertEquals((long)5L, (long)a);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
                Assert.assertEquals((Object)"bug27679_idx", (Object)TestOjaiQuery.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testSort_bug27655() throws Exception {
        String rawTableName = "bug27655";
        this.addCleanupTable("bug27655");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27655");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 17;
            Random random = new Random(27655L);
            for (int i = 1; i <= 17; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                Document docA = connection.newDocument();
                docA.set("b", random.nextInt(10000));
                doc.set("a", docA);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27655", (long)17L);
            Query query = connection.newQuery().select(new String[]{"a.b"}).orderBy(new String[]{"a.b"}).build();
            int docCount = 0;
            int lastAb = Integer.MIN_VALUE;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    int ab = doc.getInt("a.b");
                    Assert.assertTrue((String)("last a.b = " + lastAb + ", this a.b = " + ab), (ab >= lastAb ? 1 : 0) != 0);
                    lastAb = ab;
                    ++docCount;
                }
                Assert.assertEquals((long)17L, (long)docCount);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DRILL, (Object)TestOjaiQuery.getQueryPath(docStream));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQuery_bug27939() {
        Query query = this.driver.newQuery().setTimeout(-1L).select(new String[]{"foo"}).build();
    }

    @Test
    public void testQuery_bug27967() throws Exception {
        String rawTableName = "bug27967";
        this.addCleanupTable("bug27967");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27967");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            int nRows = 13;
            for (int i = 1; i <= 13; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                doc.set("i", i);
                doc.set("b", i % 2 == 0);
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug27967", (long)13L);
            Query query = connection.newQuery().select(new String[]{"b", "_id"}).where(connection.newCondition().is("b", QueryCondition.Op.EQUAL, true).build()).build();
            int docCount = 0;
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    boolean b = doc.getBoolean("b");
                    Assert.assertTrue((boolean)b);
                    Integer iObject = doc.getIntObj("i");
                    Assert.assertNull((Object)iObject);
                    ++docCount;
                }
                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                Assert.assertTrue((docCount < 13 ? 1 : 0) != 0);
                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
            }
        }
    }

    private static void bug27990Query(Connection connection, String tableName) {
        int docCount = 0;
        try (DocumentStore docStore = connection.getStore(tableName);
             DocumentStream docStream = docStore.find();){
            for (Document doc : docStream) {
                String id = doc.getIdString();
                Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                ++docCount;
            }
            Assert.assertEquals((long)4L, (long)docCount);
            Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)TestOjaiQuery.getQueryPath(docStream));
        }
    }

    @Test
    public void testQuery_bug27990() throws Exception {
        String rawTableName = "bug27990";
        this.addCleanupTable("bug27990");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug27990");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            Document doc1 = connection.newDocument();
            doc1.setId("1");
            doc1.set("a", 1);
            doc1.set("b", 1);
            table.insert(doc1);
            Document doc2 = connection.newDocument();
            doc2.setId("2");
            doc2.set("a", 0);
            doc2.set("b", 1);
            table.insert(doc2);
            Document doc3 = connection.newDocument();
            doc3.setId("3");
            doc3.set("a", 0);
            doc3.set("b", connection.newDocument());
            table.insert(doc3);
            Document doc4 = connection.newDocument();
            doc4.setId("4");
            doc4.set("a", new ArrayList(0));
            doc4.set("b", 1);
            table.insert(doc4);
            DBTests.waitForRowCount((String)"bug27990", (long)4L);
            TestOjaiQuery.bug27990Query((Connection)connection, tableName);
            DBTests.createIndex((Table)table, (String)"bug27990_idx", (boolean)false, (int)0, (String[])new String[]{"a", "b"}, null, null);
            DBTests.waitForIndexFlush((String)"bug27990");
            TestOjaiQuery.bug27990Query((Connection)connection, tableName);
        }
    }

    @Test
    @Category(value={ClusterTest.class})
    public void testQuery_bug27926() {
        try (OjaiConnection connection = TestOjaiQuery.getConnection();){
            Query query = connection.newQuery().where(connection.newCondition().is("b", QueryCondition.Op.EQUAL, "pk").build()).where(connection.newCondition().is("a", QueryCondition.Op.EQUAL, 3).build()).build();
            Assert.assertNotNull((Object)query);
        }
    }

    @Test
    public void testQuery_bug28129() throws Exception, InterruptedException {
        String rawTableName = "bug28129";
        this.addCleanupTable("bug28129");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28129");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            DBTests.createIndex((Table)table, (String)"bug28129_idx", (boolean)false, (int)0, (String[])new String[]{"city", "state"}, null, null);
            int nCities = 5;
            int nRows = 237;
            String pickedCity = null;
            String pickedState = null;
            StringGenerator stringGenerator = new StringGenerator(128, 28129L);
            for (int i = 1; i <= 237; ++i) {
                Document doc = connection.newDocument();
                String id = Integer.toString(i);
                doc.setId(id);
                String city = "City" + i % 5;
                String state = bug28129States[i % bug28129States.length];
                if (i >= 118 && pickedCity == null) {
                    pickedCity = city;
                    pickedState = state;
                }
                doc.set("city", city);
                doc.set("state", state);
                doc.set("other", stringGenerator.nextUniqueString());
                doc.set("more", stringGenerator.nextUniqueString());
                table.insert(doc);
            }
            DBTests.waitForRowCount((String)"bug28129", (long)237L);
            DBTests.waitForIndexFlush((String)"bug28129");
            String theCity = pickedCity;
            String theState = pickedState;
            Query query = connection.newQuery().select(new String[]{"other", "city", "state"}).where(connection.newCondition().and().is("city", QueryCondition.Op.EQUAL, theCity).is("state", QueryCondition.Op.EQUAL, theState).close().build()).build();
            int nThreads = 17;
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch continueLatch = new CountDownLatch(17);
            ExecutorService executorService = connection.getExecutorService();
            for (int i = 0; i < 17; ++i) {
                executorService.execute(new Runnable((Connection)connection, tableName, startLatch, query, theCity, theState, continueLatch){
                    final /* synthetic */ Connection val$connection;
                    final /* synthetic */ String val$tableName;
                    final /* synthetic */ CountDownLatch val$startLatch;
                    final /* synthetic */ Query val$query;
                    final /* synthetic */ String val$theCity;
                    final /* synthetic */ String val$theState;
                    final /* synthetic */ CountDownLatch val$continueLatch;
                    {
                        this.val$connection = connection;
                        this.val$tableName = string;
                        this.val$startLatch = countDownLatch;
                        this.val$query = query;
                        this.val$theCity = string2;
                        this.val$theState = string3;
                        this.val$continueLatch = countDownLatch2;
                    }

                    @Override
                    public void run() {
                        int docCount = 0;
                        try (DocumentStore docStore = this.val$connection.getStore(this.val$tableName);){
                            try {
                                this.val$startLatch.await(30L, TimeUnit.SECONDS);
                            }
                            catch (InterruptedException ie) {
                                Assert.fail();
                            }
                            try (DocumentStream docStream = docStore.findQuery(this.val$query);){
                                for (Document doc : docStream) {
                                    String id = doc.getIdString();
                                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                                    String city = doc.getString("city");
                                    Assert.assertEquals((Object)this.val$theCity, (Object)city);
                                    String state = doc.getString("state");
                                    Assert.assertEquals((Object)this.val$theState, (Object)state);
                                    ++docCount;
                                }
                                Assert.assertTrue((docCount > 0 ? 1 : 0) != 0);
                                Assert.assertTrue((docCount < 237 ? 1 : 0) != 0);
                                Assert.assertEquals((Object)OjaiQueryProperties.QueryPath.DIRECT, (Object)OjaiTest.getQueryPath(docStream));
                            }
                        }
                        this.val$continueLatch.countDown();
                    }
                });
            }
            startLatch.countDown();
            continueLatch.await(60L, TimeUnit.SECONDS);
        }
    }

    private static void idFilterInsert(Connection connection, Table table, String id, int i, String s) {
        Document doc = connection.newDocument();
        doc.setId(id);
        doc.set("i", i);
        doc.set("s", s);
        table.insert(doc);
    }

    @Test
    public void testQuery_idFilter() throws Exception {
        String rawTableName = "idFilter";
        this.addCleanupTable("idFilter");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"idFilter");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "idFilter_idx";
            DBTests.createIndex((Table)table, (String)"idFilter_idx", (boolean)false, (int)0, (String[])new String[]{"i"}, null, null);
            TestOjaiQuery.idFilterInsert((Connection)connection, table, "1", 1, "foo");
            TestOjaiQuery.idFilterInsert((Connection)connection, table, "2", 42, "bar");
            TestOjaiQuery.idFilterInsert((Connection)connection, table, "3", 3, "baz");
            TestOjaiQuery.idFilterInsert((Connection)connection, table, "4", 17, "tip");
            DBTests.waitForIndexFlush((String)"idFilter");
            DBTests.waitForRowCount((String)"idFilter", (long)4L);
            Query query = this.driver.newQuery().where(this.driver.newCondition().and().is("i", QueryCondition.Op.EQUAL, 17).is("_id", QueryCondition.Op.EQUAL, "5").close().build()).build();
            try (DocumentStore docStore = connection.getStore(tableName);
                 DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    System.out.println(doc);
                    ++docCount;
                }
                Assert.assertEquals((long)0L, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)"idFilter", (Object)OjaiTest.getIndexUsed(docStream));
            }
        }
    }

    @Test
    public void testQuery_bug28085() throws Exception {
        String rawTableName = "bug28085";
        this.addCleanupTable("bug28085");
        try (OjaiConnection connection = TestOjaiQuery.getConnection();
             Table table = DBTests.createOrGetTable((String)"bug28085");){
            Path tablePath = table.getPath();
            String tableName = tablePath.toString();
            String indexName = "bug28085_idx";
            DBTests.createIndex((Table)table, (String)"bug28085_idx", (boolean)false, (int)0, (String[])new String[]{"c"}, null, null);
            String cString = "a string";
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap cMap = builder.put((Object)"hcssim", (Object)17).put((Object)"hhg2tg", (Object)42).build();
            Document doc1 = connection.newDocument();
            doc1.setId("1");
            doc1.set("c", "a string");
            table.insert(doc1);
            Document doc2 = connection.newDocument();
            doc2.setId("2");
            Serializable doc2c = new ArrayList<String>(3);
            doc2c.add("x");
            doc2c.add("y");
            doc2c.add("z");
            doc2.set("c", doc2c);
            table.insert(doc2);
            Document doc3 = connection.newDocument();
            doc3.setId("3");
            doc3.set("c", (Map)cMap);
            table.insert(doc3);
            DBTests.waitForRowCount((String)"bug28085", (long)3L);
            DBTests.waitForIndexFlush((String)"bug28085");
            Query queryScalar = this.driver.newQuery().where(this.driver.newCondition().is("c", QueryCondition.Op.EQUAL, "a string").build()).build();
            DocumentStore docStore = connection.getStore(tableName);
            doc2c = null;
            try (DocumentStream docStream = docStore.findQuery(queryScalar);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    String c = doc.getString("c");
                    Assert.assertEquals((Object)"a string", (Object)c);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
                Assert.assertEquals((Object)"bug28085_idx", (Object)OjaiTest.getIndexUsed(docStream));
            }
            catch (Throwable throwable) {
                doc2c = throwable;
                throw throwable;
            }
            finally {
                if (docStore != null) {
                    if (doc2c != null) {
                        try {
                            docStore.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)doc2c).addSuppressed(throwable);
                        }
                    } else {
                        docStore.close();
                    }
                }
            }
            Query queryMap = this.driver.newQuery().where(this.driver.newCondition().equals("c", (Map)cMap).build()).build();
            try (DocumentStore docStore2 = connection.getStore(tableName);
                 DocumentStream docStream = docStore2.findQuery(queryMap);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertTrue((Integer.parseInt(id) > 0 ? 1 : 0) != 0);
                    Map c = doc.getMap("c");
                    Assert.assertEquals((Object)cMap, (Object)c);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                TestOjaiQuery.assertQueryPath(docStream, OjaiQueryProperties.QueryPath.DIRECT);
            }
        }
    }

    private static class QueriesOnDateTimestampTime {
        private QueriesOnDateTimestampTime() {
        }

        static void insertDocs(Connection connection, Table table) {
            QueryOnDate.insertDoc(connection, table, "1", QueryOnDate.date1, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "2", QueryOnDate.date2, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "3", QueryOnDate.date3, ODate.parse((String)"2016-05-15"));
            QueryOnTimestamp.insertDoc(connection, table, "4", QueryOnTimestamp.timestamp1, OTimestamp.parse((String)"2007-01-10T20:00:21.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "5", QueryOnTimestamp.timestamp2, OTimestamp.parse((String)"2000-01-31T22:02:05.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "6", QueryOnTimestamp.timestamp3, OTimestamp.parse((String)"2015-03-14T10:10:10.000+00:00"));
            QueryOnTime.insertDoc(connection, table, "7", QueryOnTime.time1, OTime.parse((String)"20:00:21"));
            QueryOnTime.insertDoc(connection, table, "8", QueryOnTime.time2, OTime.parse((String)"22:02:05"));
            QueryOnTime.insertDoc(connection, table, "9", QueryOnTime.time3, OTime.parse((String)"10:10:10"));
        }

        static void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnDate.date2, "1", QueryOnDate.date1, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnDate.date2, "2", QueryOnDate.date2, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnDate.date2, "3", QueryOnDate.date3, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnTimestamp.timestamp2, "4", QueryOnTimestamp.timestamp1, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnTimestamp.timestamp2, "5", QueryOnTimestamp.timestamp2, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnTimestamp.timestamp2, "6", QueryOnTimestamp.timestamp3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.LESS, QueryOnTime.time2, "9", QueryOnTime.time3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.EQUAL, QueryOnTime.time2, "8", QueryOnTime.time2, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.GREATER, QueryOnTime.time2, "7", QueryOnTime.time1, expectedPath);
        }
    }

    private static class QueryOnDate {
        static final ODate date1 = ODate.parse((String)"1-03-04");
        static final ODate date2 = ODate.parse((String)"1969-09-22");
        static final ODate date3 = ODate.parse((String)"4526002-05-01");

        private QueryOnDate() {
        }

        private static void insertDoc(Connection connection, Table table, String id, ODate ts1, ODate ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        public void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            QueryOnDate.insertDoc(connection, table, "1", date1, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "2", date2, ODate.parse((String)"2017-05-15"));
            QueryOnDate.insertDoc(connection, table, "3", date3, ODate.parse((String)"2016-05-15"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, ODate queryDate, String expectedId, ODate expectedDate, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryDate).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    ODate d1 = doc.getDate("d1");
                    Assert.assertEquals((Object)expectedDate, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        public void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.LESS, date2, "1", date1, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.EQUAL, date2, "2", date2, expectedPath);
            QueryOnDate.runQuery(connection, docStore, QueryCondition.Op.GREATER, date2, "3", date3, expectedPath);
        }
    }

    private static class QueryOnTimestamp {
        static final OTimestamp timestamp1 = OTimestamp.parse((String)"10-03-14T20:12:21.000+00:00");
        static final OTimestamp timestamp2 = OTimestamp.parse((String)"1969-12-31T20:12:21.000+00:00");
        static final OTimestamp timestamp3 = OTimestamp.parse((String)"148818705-10-07T09:58:24.613Z");

        private QueryOnTimestamp() {
        }

        private static void insertDoc(Connection connection, Table table, String id, OTimestamp ts1, OTimestamp ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        void insertDocs(Connection connection, String rawTableName, Table table) throws IOException {
            QueryOnTimestamp.insertDoc(connection, table, "1", timestamp1, OTimestamp.parse((String)"2007-01-10T20:00:21.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "2", timestamp2, OTimestamp.parse((String)"2000-01-31T22:02:05.000+00:00"));
            QueryOnTimestamp.insertDoc(connection, table, "3", timestamp3, OTimestamp.parse((String)"2015-03-14T10:10:10.000+00:00"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, OTimestamp queryTimestamp, String expectedId, OTimestamp expectedTimestamp, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryTimestamp).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    OTimestamp d1 = doc.getTimestamp("d1");
                    Assert.assertEquals((Object)expectedTimestamp, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        public void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.LESS, timestamp2, "1", timestamp1, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.EQUAL, timestamp2, "2", timestamp2, expectedPath);
            QueryOnTimestamp.runQuery(connection, docStore, QueryCondition.Op.GREATER, timestamp2, "3", timestamp3, expectedPath);
        }
    }

    private static class QueryOnTime {
        static final OTime time1 = OTime.parse((String)"20:12:22");
        static final OTime time2 = OTime.parse((String)"20:12:21");
        static final OTime time3 = OTime.parse((String)"10:12:21");

        private QueryOnTime() {
        }

        private static void insertDoc(Connection connection, Table table, String id, OTime ts1, OTime ts2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", ts1);
            doc.set("d2", ts2);
            table.insert(doc);
        }

        private void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            QueryOnTime.insertDoc(connection, table, "1", time1, OTime.parse((String)"20:00:21"));
            QueryOnTime.insertDoc(connection, table, "2", time2, OTime.parse((String)"22:02:05"));
            QueryOnTime.insertDoc(connection, table, "3", time3, OTime.parse((String)"10:10:10"));
            DBTests.waitForRowCount((String)rawTableName, (long)3L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, QueryCondition.Op op, OTime queryTime, String expectedId, OTime expectedTime, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().is("d1", op, queryTime).build()).build();
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    OTime d1 = doc.getTime("d1");
                    Assert.assertEquals((Object)expectedTime, (Object)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        private void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.LESS, time2, "3", time3, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.EQUAL, time2, "2", time2, expectedPath);
            QueryOnTime.runQuery(connection, docStore, QueryCondition.Op.GREATER, time2, "1", time1, expectedPath);
        }
    }

    private static class QueryOnInt {
        static final int nDocs = 20;
        static final int condOperand1 = 10;
        static final int condOperand2 = 10;

        private QueryOnInt() {
        }

        private static void insertDoc(Connection connection, Table table, String id, int i1, int i2) {
            Document doc = connection.newDocument();
            doc.setId(id);
            doc.set("d1", i1);
            doc.set("d2", i2);
            table.insert(doc);
        }

        private void insertDocs(Connection connection, Table table, String rawTableName) throws IOException {
            for (int i = 0; i < 20; ++i) {
                QueryOnInt.insertDoc(connection, table, "" + i, 10, i);
            }
            DBTests.waitForRowCount((String)rawTableName, (long)20L);
        }

        private static void runQuery(Connection connection, DocumentStore docStore, Query query, String expectedId, int expectedInt, OjaiQueryProperties.QueryPath expectedPath) {
            try (DocumentStream docStream = docStore.findQuery(query);){
                int docCount = 0;
                for (Document doc : docStream) {
                    String id = doc.getIdString();
                    Assert.assertEquals((Object)expectedId, (Object)id);
                    int d1 = doc.getInt("d1");
                    Assert.assertEquals((long)expectedInt, (long)d1);
                    ++docCount;
                }
                Assert.assertEquals((long)1L, (long)docCount);
                Assert.assertEquals((Object)expectedPath, (Object)OjaiTest.getQueryPath(docStream));
            }
        }

        private void runQueries(Connection connection, DocumentStore docStore, OjaiQueryProperties.QueryPath expectedPath) {
            Query query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, 10).is("d2", QueryCondition.Op.EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.EQUAL, 10).is("d2", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d2", QueryCondition.Op.GREATER_OR_EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d1", QueryCondition.Op.GREATER_OR_EQUAL, 10).is("d2", QueryCondition.Op.EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
            query = connection.newQuery().select(new String[]{"d1", "_id"}).where(connection.newCondition().and().is("d1", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d1", QueryCondition.Op.GREATER_OR_EQUAL, 10).is("d2", QueryCondition.Op.LESS_OR_EQUAL, 10).is("d2", QueryCondition.Op.GREATER_OR_EQUAL, 10).close().build()).build();
            QueryOnInt.runQuery(connection, docStore, query, "10", 10, expectedPath);
        }
    }
}

