/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ojai.store.impl;

import com.mapr.db.impl.OjaiQueryProperties;
import com.mapr.ojai.store.impl.AbstractDocumentFilter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.ojai.DocumentListener;
import org.ojai.DocumentStream;

public class DelayDocumentFilter
extends AbstractDocumentFilter {
    private static final Timer timer = new Timer("DelayDocumentFilter", true);
    private final int delayMs;

    public DelayDocumentFilter(DocumentStream upstreamStream, ExecutorService executorService, int delayMs) {
        super(upstreamStream, executorService);
        this.delayMs = delayMs;
    }

    private void superStreamTo(DocumentListener docListener) {
        super.streamTo(docListener);
    }

    public void streamTo(final DocumentListener docListener) {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                DelayDocumentFilter.this.superStreamTo(docListener);
            }
        }, this.delayMs);
    }

    public void getQueryPlan(List<Map<String, Object>> planList) {
        if (this.upstreamStream == null) {
            return;
        }
        ((OjaiQueryProperties)this.upstreamStream).getQueryPlan(planList);
        HashMap<String, Object> myMap = new HashMap<String, Object>();
        myMap.put("streamName", ((Object)((Object)this)).getClass().getSimpleName());
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        valueMap.put("delayMs", this.delayMs);
        myMap.put("parameters", valueMap);
        planList.add(myMap);
    }
}

