/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.client.impl;

import com.google.common.base.Preconditions;
import com.mapr.data.db.proto.DeleteRequest;
import com.mapr.data.db.proto.DeleteResponse;
import com.mapr.data.db.proto.ErrorCode;
import com.mapr.data.db.proto.FindByIdRequest;
import com.mapr.data.db.proto.FindByIdResponse;
import com.mapr.data.db.proto.FindRequest;
import com.mapr.data.db.proto.FindResponse;
import com.mapr.data.db.proto.InsertMode;
import com.mapr.data.db.proto.InsertOrReplaceRequest;
import com.mapr.data.db.proto.InsertOrReplaceResponse;
import com.mapr.data.db.proto.MapRDbServerGrpc;
import com.mapr.data.db.proto.PayloadEncoding;
import com.mapr.data.db.proto.UpdateRequest;
import com.mapr.data.db.proto.UpdateResponse;
import com.mapr.db.client.impl.ConnectionImpl;
import com.mapr.db.client.impl.DocumentMutationImpl;
import com.mapr.db.client.impl.GrpcDocumentStore;
import com.mapr.db.client.impl.GrpcQueryResult;
import com.mapr.db.client.impl.QueryImpl;
import com.mapr.db.client.impl.RpcErrorHandler;
import io.grpc.StatusRuntimeException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.JsonString;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.json.JsonOptions;
import org.ojai.json.impl.JsonValueBuilder;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.QueryResult;
import org.ojai.store.exceptions.MultiOpException;
import org.ojai.store.exceptions.StoreException;
import org.ojai.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentStoreImpl
implements GrpcDocumentStore {
    private static final Logger logger = LoggerFactory.getLogger(DocumentStoreImpl.class);
    private static final String[] EMPTY_FIELDPATH_ARRAY = new String[0];
    private final String tablePath;
    private final ConnectionImpl connection;
    private final Document options;

    public DocumentStoreImpl(ConnectionImpl connection, String tablePath, Document options) {
        this.connection = connection;
        this.tablePath = tablePath;
        this.options = options;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void flush() throws StoreException {
    }

    public void beginTrackingWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void beginTrackingWrites(String previousWritesContext) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public String endTrackingWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void clearTrackedWrites() throws StoreException {
        throw new UnsupportedOperationException();
    }

    public Document findById(String _id) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), (QueryCondition)null, EMPTY_FIELDPATH_ARRAY);
    }

    public Document findById(Value _id) throws StoreException {
        return this.findById(_id, (QueryCondition)null, EMPTY_FIELDPATH_ARRAY);
    }

    public Document findById(String _id, String ... fieldPaths) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), (QueryCondition)null, fieldPaths);
    }

    public Document findById(String _id, FieldPath ... fieldPaths) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), (QueryCondition)null, Fields.toFieldPathStringArray((FieldPath[])fieldPaths));
    }

    public Document findById(Value _id, String ... fieldPaths) throws StoreException {
        return this.findById(_id, (QueryCondition)null, fieldPaths);
    }

    public Document findById(Value _id, FieldPath ... fieldPaths) throws StoreException {
        return this.findById(_id, (QueryCondition)null, Fields.toFieldPathStringArray((FieldPath[])fieldPaths));
    }

    public Document findById(String _id, QueryCondition condition) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), condition, EMPTY_FIELDPATH_ARRAY);
    }

    public Document findById(Value _id, QueryCondition condition) throws StoreException {
        return this.findById(_id, condition, EMPTY_FIELDPATH_ARRAY);
    }

    public Document findById(String _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), condition, fieldPaths);
    }

    public Document findById(String _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        return this.findById((Value)JsonValueBuilder.initFromObject((Object)_id), condition, Fields.toFieldPathStringArray((FieldPath[])fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        return this.findById(_id, condition, Fields.toFieldPathStringArray((FieldPath[])fieldPaths));
    }

    public Document findById(Value _id, QueryCondition condition, String ... fieldPaths) throws StoreException {
        Preconditions.checkNotNull((Object)fieldPaths);
        Document doc = this.connection.newDocument().setId(_id);
        String json_document = this.asJsonString((JsonString)doc);
        FindByIdRequest.Builder requestBuilder = FindByIdRequest.newBuilder().setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(json_document);
        if (fieldPaths.length > 0) {
            requestBuilder.addAllProjections(Arrays.asList(fieldPaths));
        }
        if (condition != null) {
            requestBuilder.setJsonCondition(this.asJsonString((JsonString)condition));
        }
        try {
            FindByIdResponse response = this.getBlockingStub().findById(requestBuilder.build());
            switch (response.getError().getErrCode()) {
                case NO_ERROR: {
                    Document edoc = Json.newDocument((String)response.getJsonDocument());
                    logger.trace("Document with _id {} found.", (Object)edoc.getId());
                    return edoc;
                }
                case DOCUMENT_NOT_FOUND: {
                    return null;
                }
            }
            throw RpcErrorHandler.handleRpcError(response.getError());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.findById(_id, condition, fieldPaths);
            }
            throw e;
        }
    }

    @Override
    public QueryResult find(Query query) throws StoreException {
        return this.find(query, false);
    }

    @Override
    public QueryResult find(Query query, boolean includeQueryPlan) throws StoreException {
        Preconditions.checkNotNull((Object)query);
        FindRequest request = FindRequest.newBuilder().setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonQuery(query.asJsonString()).setIncludeQueryPlan(includeQueryPlan).build();
        try {
            Iterator<FindResponse> responses = this.getBlockingStub().find(request);
            return new GrpcQueryResult(query, responses);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.find(query);
            }
            throw e;
        }
    }

    @Override
    public QueryResult find(Query query, Long timeoutMilliseconds) throws StoreException {
        return this.find(query, timeoutMilliseconds, false);
    }

    @Override
    public QueryResult find(Query query, Long timeoutMilliseconds, boolean includeQueryPlan) throws StoreException {
        Preconditions.checkNotNull((Object)query);
        FindRequest request = FindRequest.newBuilder().setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonQuery(query.asJsonString()).setIncludeQueryPlan(includeQueryPlan).build();
        try {
            Iterator<FindResponse> responses = ((MapRDbServerGrpc.MapRDbServerBlockingStub)this.getBlockingStub().withDeadlineAfter(timeoutMilliseconds, TimeUnit.MILLISECONDS)).find(request);
            return new GrpcQueryResult(query, responses);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.find(query);
            }
            throw e;
        }
    }

    @Override
    public QueryResult find() throws StoreException {
        return this.find(QueryImpl.EMPTY_QUERY);
    }

    @Override
    public QueryResult find(boolean includeQueryPlan) throws StoreException {
        return this.find(QueryImpl.EMPTY_QUERY, includeQueryPlan);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds) throws StoreException {
        return this.find(QueryImpl.EMPTY_QUERY, timeoutMilliseconds);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds, boolean includeQueryPlan) throws StoreException {
        return this.find(QueryImpl.EMPTY_QUERY, timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult findQuery(Query query) throws StoreException {
        return this.find(query);
    }

    @Override
    public QueryResult findQuery(Query query, boolean includeQueryPlan) throws StoreException {
        return this.find(query, includeQueryPlan);
    }

    @Override
    public QueryResult findQuery(Query query, Long timeoutMilliseconds) throws StoreException {
        return this.find(query, timeoutMilliseconds);
    }

    @Override
    public QueryResult findQuery(Query query, Long timeoutMilliseconds, boolean includeQueryPlan) throws StoreException {
        return this.find(query, timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult findQuery(String queryJSON) throws StoreException {
        return this.find(this.connection.newQuery(queryJSON));
    }

    @Override
    public QueryResult findQuery(String queryJSON, boolean includeQueryPlan) throws StoreException {
        return this.find(this.connection.newQuery(queryJSON), includeQueryPlan);
    }

    @Override
    public QueryResult findQuery(String queryJSON, Long timeoutMilliseconds) throws StoreException {
        return this.find(this.connection.newQuery(queryJSON), timeoutMilliseconds);
    }

    @Override
    public QueryResult findQuery(String queryJSON, Long timeoutMilliseconds, boolean includeQueryPlan) throws StoreException {
        return this.find(this.connection.newQuery(queryJSON), timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult find(String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths));
    }

    @Override
    public QueryResult find(boolean includeQueryPlan, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), includeQueryPlan);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), timeoutMilliseconds);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds, boolean includeQueryPlan, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult find(FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths));
    }

    @Override
    public QueryResult find(boolean includeQueryPlan, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), includeQueryPlan);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), timeoutMilliseconds);
    }

    @Override
    public QueryResult find(Long timeoutMilliseconds, boolean includeQueryPlan, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths), timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition, Long timeoutMilliseconds) throws StoreException {
        return this.find(new QueryImpl().where(condition), timeoutMilliseconds);
    }

    @Override
    public QueryResult find(QueryCondition condition, boolean includeQueryPlan, Long timeoutMilliseconds) throws StoreException {
        return this.find(new QueryImpl().where(condition), timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition) throws StoreException {
        return this.find(new QueryImpl().where(condition));
    }

    @Override
    public QueryResult find(QueryCondition condition, boolean includeQueryPlan) throws StoreException {
        return this.find(new QueryImpl().where(condition), includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition));
    }

    @Override
    public QueryResult find(QueryCondition condition, boolean includeQueryPlan, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition, Long timeoutMilliseconds, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), timeoutMilliseconds);
    }

    @Override
    public QueryResult find(QueryCondition condition, Long timeoutMilliseconds, boolean includeQueryPlan, String ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), timeoutMilliseconds, includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition));
    }

    @Override
    public QueryResult find(QueryCondition condition, boolean includeQueryPlan, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), includeQueryPlan);
    }

    @Override
    public QueryResult find(QueryCondition condition, Long timeoutMilliseconds, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), timeoutMilliseconds);
    }

    @Override
    public QueryResult find(QueryCondition condition, Long timeoutMilliseconds, boolean includeQueryPlan, FieldPath ... fieldPaths) throws StoreException {
        return this.find(new QueryImpl().select(fieldPaths).where(condition), timeoutMilliseconds, includeQueryPlan);
    }

    public void insertOrReplace(Document doc) throws StoreException {
        this.insertOrReplaceCommon(doc, InsertMode.INSERT_OR_REPLACE);
    }

    private void insertOrReplaceCommon(Document doc, InsertMode insertMode) throws StoreException {
        InsertOrReplaceRequest.Builder request = InsertOrReplaceRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setInsertMode(insertMode).setJsonDocument(doc.asJsonString(JsonOptions.WITH_TAGS));
        try {
            InsertOrReplaceResponse response = this.getBlockingStub().insertOrReplace(request.build());
            if (response.getError().getErrCode() != ErrorCode.NO_ERROR) {
                throw RpcErrorHandler.handleRpcError(response.getError());
            }
            logger.trace("Document with _id {} inserted with mode {}.", (Object)doc.getId(), (Object)insertMode);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                this.insertOrReplaceCommon(doc, insertMode);
            }
            throw e;
        }
    }

    private MapRDbServerGrpc.MapRDbServerBlockingStub getBlockingStub() {
        return this.connection.getBlockingStub();
    }

    public void insertOrReplace(String _id, Document r) throws StoreException {
        this.insertOrReplace((Value)JsonValueBuilder.initFromObject((Object)_id), r);
    }

    public void insertOrReplace(Value _id, Document doc) throws StoreException {
        doc.set(DocumentConstants.ID_FIELD, _id);
        this.insertOrReplace(doc);
    }

    public void insertOrReplace(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(DocumentStream stream) throws MultiOpException {
        StreamSupport.stream(stream.spliterator(), true).forEach(this::insertOrReplace);
    }

    public void insertOrReplace(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insertOrReplace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void update(String _id, DocumentMutation mutation) throws StoreException {
        this.update((Value)JsonValueBuilder.initFromObject((Object)_id), mutation);
    }

    public void update(Value _id, DocumentMutation mutation) throws StoreException {
        String jsonDocument = this.connection.newDocument().setId(_id).asJsonString(JsonOptions.WITH_TAGS);
        String jsonMutation = mutation.asJsonString();
        UpdateRequest.Builder request = UpdateRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(jsonDocument).setJsonMutation(jsonMutation);
        try {
            UpdateResponse response = this.getBlockingStub().update(request.build());
            if (response.getError().getErrCode() != ErrorCode.NO_ERROR) {
                throw RpcErrorHandler.handleRpcError(response.getError());
            }
            logger.trace("Document with _id {} updated.", (Object)_id);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                this.update(_id, mutation);
            }
            throw e;
        }
    }

    public void delete(String _id) throws StoreException {
        this.delete((Value)JsonValueBuilder.initFromObject((Object)_id));
    }

    public void delete(Value _id) throws StoreException {
        String jsonDocument = this.connection.newDocument().setId(_id).asJsonString(JsonOptions.WITH_TAGS);
        DeleteRequest.Builder request = DeleteRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(jsonDocument);
        try {
            DeleteResponse response = this.getBlockingStub().delete(request.build());
            if (response.getError().getErrCode() != ErrorCode.NO_ERROR) {
                throw RpcErrorHandler.handleRpcError(response.getError());
            }
            logger.trace("Document with _id {} deleted.", (Object)_id);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                this.delete(_id);
            }
            throw e;
        }
    }

    public void delete(Document doc) throws StoreException {
        this.delete(doc.getId());
    }

    public void delete(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void delete(DocumentStream stream) throws MultiOpException {
        StreamSupport.stream(stream.spliterator(), true).forEach(this::delete);
    }

    public void delete(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void delete(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insert(String _id, Document doc) throws StoreException {
        doc.set(DocumentConstants.ID_FIELD, _id);
        this.insert(doc);
    }

    public void insert(Value _id, Document doc) throws StoreException {
        this.insert(doc.setId(_id));
    }

    public void insert(Document doc) throws StoreException {
        this.insertOrReplaceCommon(doc, InsertMode.INSERT);
    }

    public void insert(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insert(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void insert(DocumentStream stream) throws MultiOpException {
        StreamSupport.stream(stream.spliterator(), true).forEach(this::insert);
    }

    public void insert(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void insert(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void replace(String _id, Document doc) throws StoreException {
        doc.set(DocumentConstants.ID_FIELD, _id);
        this.replace(doc);
    }

    public void replace(Value _id, Document doc) throws StoreException {
        this.replace(doc.setId(_id));
    }

    public void replace(Document doc) throws StoreException {
        this.insertOrReplaceCommon(doc, InsertMode.REPLACE);
    }

    public void replace(Document doc, FieldPath fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void replace(Document doc, String fieldAsKey) throws StoreException {
        throw new UnsupportedOperationException();
    }

    public void replace(DocumentStream stream) throws MultiOpException {
        StreamSupport.stream(stream.spliterator(), true).forEach(this::replace);
    }

    public void replace(DocumentStream stream, FieldPath fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void replace(DocumentStream stream, String fieldAsKey) throws MultiOpException {
        throw new UnsupportedOperationException();
    }

    public void increment(String _id, String field, byte inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(String _id, String field, short inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(String _id, String field, int inc) throws StoreException {
        DocumentMutation mutation = new DocumentMutationImpl().increment(field, inc);
        this.update(_id, mutation);
    }

    public void increment(String _id, String field, long inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(String _id, String field, float inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(String _id, String field, double inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(String _id, String field, BigDecimal inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, byte inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, short inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, int inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, long inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, float inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, double inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public void increment(Value _id, String field, BigDecimal inc) throws StoreException {
        this.update(_id, new DocumentMutationImpl().increment(field, inc));
    }

    public boolean checkAndUpdate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        return this.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndUpdate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        return this.checkAndMutate(_id, condition, mutation);
    }

    public boolean checkAndMutate(String _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        return this.checkAndMutate((Value)JsonValueBuilder.initFromObject((Object)_id), condition, mutation);
    }

    public boolean checkAndMutate(Value _id, QueryCondition condition, DocumentMutation mutation) throws StoreException {
        String jsonDocument = this.connection.newDocument().setId(_id).asJsonString(JsonOptions.WITH_TAGS);
        String jsonMutation = mutation.asJsonString();
        String jsonCondition = condition.asJsonString();
        UpdateRequest.Builder request = UpdateRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(jsonDocument).setJsonCondition(jsonCondition).setJsonMutation(jsonMutation);
        try {
            UpdateResponse response = this.getBlockingStub().update(request.build());
            switch (response.getError().getErrCode()) {
                case NO_ERROR: {
                    return true;
                }
                case DOCUMENT_NOT_FOUND: {
                    return false;
                }
            }
            throw RpcErrorHandler.handleRpcError(response.getError());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.checkAndMutate(_id, condition, mutation);
            }
            throw e;
        }
    }

    public boolean checkAndDelete(String _id, QueryCondition condition) throws StoreException {
        return this.checkAndDelete((Value)JsonValueBuilder.initFromObject((Object)_id), condition);
    }

    public boolean checkAndDelete(Value _id, QueryCondition condition) throws StoreException {
        String jsonDocument = this.connection.newDocument().setId(_id).asJsonString(JsonOptions.WITH_TAGS);
        DeleteRequest.Builder request = DeleteRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setJsonDocument(jsonDocument).setJsonCondition(condition.asJsonString());
        try {
            DeleteResponse response = this.getBlockingStub().delete(request.build());
            switch (response.getError().getErrCode()) {
                case NO_ERROR: {
                    logger.trace("Document with _id {} deleted.", (Object)_id);
                    return true;
                }
                case DOCUMENT_NOT_FOUND: {
                    return false;
                }
            }
            throw RpcErrorHandler.handleRpcError(response.getError());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.checkAndDelete(_id, condition);
            }
            throw e;
        }
    }

    public boolean checkAndReplace(String _id, QueryCondition condition, Document doc) throws StoreException {
        return this.checkAndReplace((Value)JsonValueBuilder.initFromObject((Object)_id), condition, doc);
    }

    public boolean checkAndReplace(Value _id, QueryCondition condition, Document doc) throws StoreException {
        String jsonDocument = doc.setId(_id).asJsonString(JsonOptions.WITH_TAGS);
        String jsonCondition = condition.asJsonString();
        InsertOrReplaceRequest.Builder request = InsertOrReplaceRequest.newBuilder();
        request.setTablePath(this.tablePath).setPayloadEncoding(PayloadEncoding.JSON_ENCODING).setInsertMode(InsertMode.REPLACE).setJsonDocument(jsonDocument).setJsonCondition(jsonCondition);
        try {
            InsertOrReplaceResponse response = this.getBlockingStub().insertOrReplace(request.build());
            switch (response.getError().getErrCode()) {
                case NO_ERROR: {
                    logger.trace("Document with _id {} replaced.", (Object)doc.getId());
                    return true;
                }
                case DOCUMENT_NOT_FOUND: {
                    return false;
                }
            }
            throw RpcErrorHandler.handleRpcError(response.getError());
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.connection.clearJWTToken();
                return this.checkAndReplace(_id, condition, doc);
            }
            throw e;
        }
    }

    public void close() throws StoreException {
    }

    private String asJsonString(JsonString jsonObj) {
        return jsonObj == null ? "{}" : jsonObj.asJsonString(JsonOptions.WITH_TAGS);
    }

    Document getOptions() {
        return this.options;
    }
}

