/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.client.impl;

import com.mapr.data.db.proto.CreateTableRequest;
import com.mapr.data.db.proto.CreateTableResponse;
import com.mapr.data.db.proto.DeleteTableRequest;
import com.mapr.data.db.proto.ErrorCode;
import com.mapr.data.db.proto.MapRDbServerGrpc;
import com.mapr.data.db.proto.PingRequest;
import com.mapr.data.db.proto.TableExistsRequest;
import com.mapr.data.db.proto.TableExistsResponse;
import com.mapr.db.client.impl.ClientAuthInterceptor;
import com.mapr.db.client.impl.DocumentStoreImpl;
import com.mapr.db.client.impl.GrpcConnection;
import com.mapr.db.client.impl.GrpcDocumentStore;
import com.mapr.db.client.impl.ThinDriver;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.NotSslRecordException;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.net.ConnectException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;
import org.ojai.store.exceptions.ConnectionException;
import org.ojai.store.exceptions.StoreException;
import org.ojai.store.exceptions.StoreExistsException;
import org.ojai.store.exceptions.StoreNotFoundException;
import org.ojai.util.Documents;

public class ConnectionImpl
implements GrpcConnection {
    private static final String KEY_CHECKSERVERIDENTITY = "checkserveridentity";
    private static final String KEY_SSLCA = "sslca";
    private static final String KEY_SSLVALIDATE = "sslvalidate";
    private static final String KEY_AUTH = "auth";
    private static final String KEY_USER = "user";
    private static final String KEY_SSL = "ssl";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_MAX_MSG_SIZE = "maxmsgsize";
    private static final String VALUE_TRUE = "true";
    private static final String[] REQUIRED_OPTIONS;
    private static final String[] VALID_OPTIONS;
    private final Document options;
    private final ThinDriver ojaiDriver;
    private ManagedChannel channel;
    private MapRDbServerGrpc.MapRDbServerBlockingStub blockingStub;
    private String host;
    private int port;
    private ClientAuthInterceptor authInterceptor;
    private boolean isSsl;
    private final PingRequest PING_REQUEST = PingRequest.newBuilder().build();

    ConnectionImpl(ThinDriver ojaiDriver, String connectionString, Document options) {
        this.options = options;
        this.ojaiDriver = ojaiDriver;
        this.parseConnectionString(connectionString);
        this.configure();
        this.connect();
    }

    private void configure() {
        this.isSsl = Boolean.valueOf(Documents.getString((Document)this.options, (String)KEY_SSL, (String)VALUE_TRUE));
    }

    private void parseConnectionString(String connectionString) {
        int paramStart = connectionString.indexOf(63);
        String hostAndPort = paramStart != -1 ? connectionString.substring(0, paramStart) : connectionString;
        String[] addressParts = hostAndPort.split(":");
        this.host = addressParts[0];
        this.port = addressParts.length > 1 ? Integer.parseInt(addressParts[1]) : 5678;
        String user = null;
        String password = null;
        if (paramStart != -1) {
            String[] optionsArray;
            String optionsString = connectionString.substring(paramStart + 1);
            for (String option : optionsArray = optionsString.split(";")) {
                String[] keyVal = option.split("=", 2);
                if (keyVal.length != 2) {
                    throw new IllegalArgumentException("Invalid connection string at key: '" + keyVal[0] + "'");
                }
                String key = keyVal[0].toLowerCase();
                String value = URLDecoder.decode(keyVal[1], StandardCharsets.UTF_8.name());
                if (KEY_PASSWORD.equals(key)) {
                    password = value;
                    this.options.set(key, "########");
                    continue;
                }
                if (KEY_USER.equals(key)) {
                    user = value;
                    this.options.set(key, value);
                    continue;
                }
                this.options.set(key, value);
            }
        }
        for (Map.Entry keyValue : this.options) {
            if (Arrays.binarySearch(VALID_OPTIONS, keyValue.getKey()) >= 0) continue;
            throw new OjaiException("Unrecognized connection option: " + (String)keyValue.getKey());
        }
        for (String optionKey : REQUIRED_OPTIONS) {
            if (this.options.getString(optionKey) != null) continue;
            throw new OjaiException("A required connection option '" + optionKey + "' was not supplied.");
        }
        this.authInterceptor = new ClientAuthInterceptor(user, password);
    }

    private Map<String, Object> configureRetryPolicy() {
        HashMap<String, Object> retryPolicy = new HashMap<String, Object>();
        try {
            retryPolicy.put("maxAttempts", this.options.getDouble("maxAttempts"));
        }
        catch (NoSuchElementException e) {
            retryPolicy.put("maxAttempts", 5.0);
        }
        String initialBackoff = this.options.getString("initialBackoff");
        retryPolicy.put("initialBackoff", initialBackoff == null ? "10s" : initialBackoff);
        String maxBackoff = this.options.getString("maxBackoff");
        retryPolicy.put("maxBackoff", maxBackoff == null ? "30s" : maxBackoff);
        try {
            retryPolicy.put("backoffMultiplier", this.options.getDouble("backoffMultiplier"));
        }
        catch (NoSuchElementException e) {
            retryPolicy.put("backoffMultiplier", 3.0);
        }
        retryPolicy.put("retryableStatusCodes", Arrays.asList("UNAVAILABLE"));
        return retryPolicy;
    }

    private void connect() {
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        HashMap<String, String> name = new HashMap<String, String>();
        name.put("service", "com.mapr.data.db.MapRDbServer");
        methodConfig.put("name", Collections.singletonList(name));
        methodConfig.put("retryPolicy", this.configureRetryPolicy());
        HashMap serviceConfig = new HashMap();
        serviceConfig.put("methodConfig", Collections.singletonList(methodConfig));
        String maxMessageSizeStr = this.options.getString(KEY_MAX_MSG_SIZE);
        int maxMessageSize = maxMessageSizeStr != null ? Integer.parseInt(maxMessageSizeStr) : 0x2000000;
        NettyChannelBuilder channelBuilder = (NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)this.host, (int)this.port).enableRetry()).disableServiceConfigLookUp()).maxInboundMessageSize(maxMessageSize).defaultServiceConfig(serviceConfig)).intercept(new ClientInterceptor[]{this.authInterceptor});
        if (this.isSsl) {
            try {
                String sslCA = this.options.getString(KEY_SSLCA);
                if (sslCA == null) {
                    throw new IllegalArgumentException("SSL is enabled but no SSL CA file has been specified");
                }
                SslContext sslContext = GrpcSslContexts.forClient().trustManager(new File(sslCA)).build();
                channelBuilder.useTransportSecurity().sslContext(sslContext);
            }
            catch (SSLException e) {
                throw new StoreException((Throwable)e);
            }
        } else {
            channelBuilder.usePlaintext();
        }
        this.channel = channelBuilder.build();
        this.blockingStub = MapRDbServerGrpc.newBlockingStub((Channel)this.channel);
        this.pingChannel();
    }

    private void pingChannel() {
        try {
            this.blockingStub.ping(this.PING_REQUEST);
        }
        catch (StatusRuntimeException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            Class<?> causeClass = cause.getClass();
            Status status = e.getStatus();
            switch (status.getCode()) {
                case UNAVAILABLE: {
                    if (ConnectException.class.isAssignableFrom(causeClass)) {
                        throw new ConnectionException(cause.getMessage(), (Throwable)e);
                    }
                    if (this.isSsl && NotSslRecordException.class.isAssignableFrom(causeClass)) {
                        throw new ConnectionException("Attempt to establish SSL connection failed! Server is listening on plain text socket?", (Throwable)e);
                    }
                    if (this.isSsl || !e.getMessage().toLowerCase().contains("network closed")) break;
                    throw new ConnectionException("Attempt to establish plain text connection failed! Server is listening on SSL socket?", (Throwable)e);
                }
                case UNAUTHENTICATED: {
                    throw new ConnectionException("Authentication failed!", (Throwable)e);
                }
            }
            throw new ConnectionException("Connection failed!", (Throwable)e);
        }
    }

    public void close() {
        try {
            this.channel.shutdown();
            this.channel.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new OjaiException((Throwable)e);
        }
    }

    @Override
    public GrpcDocumentStore getStore(String storeName) throws OjaiException {
        return this.getStore(storeName, null);
    }

    @Override
    public GrpcDocumentStore getStore(String storeName, Document options) throws OjaiException {
        if (!this.storeExists(storeName)) {
            throw new StoreNotFoundException(storeName);
        }
        return new DocumentStoreImpl(this, storeName, options);
    }

    public ValueBuilder getValueBuilder() {
        return this.ojaiDriver.getValueBuilder();
    }

    public QueryCondition newCondition() {
        return this.ojaiDriver.newCondition();
    }

    public Document newDocument() {
        return this.ojaiDriver.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return this.ojaiDriver.newDocument(documentJson);
    }

    public Document newDocument(Map<String, Object> document) throws DecodingException {
        return this.ojaiDriver.newDocument(document);
    }

    public Document newDocument(Object document) throws DecodingException {
        return this.ojaiDriver.newDocument(document);
    }

    public DocumentBuilder newDocumentBuilder() {
        return this.ojaiDriver.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return this.ojaiDriver.newMutation();
    }

    public Query newQuery() {
        return this.ojaiDriver.newQuery();
    }

    public Query newQuery(String queryJson) {
        return this.ojaiDriver.newQuery(queryJson);
    }

    public Driver getDriver() {
        return this.ojaiDriver;
    }

    MapRDbServerGrpc.MapRDbServerBlockingStub getBlockingStub() {
        return this.blockingStub;
    }

    Document getOptions() {
        return this.options;
    }

    void clearJWTToken() {
        this.authInterceptor.clearJWTToken();
    }

    @Override
    public GrpcDocumentStore createStore(String storeName) throws OjaiException {
        CreateTableRequest request = CreateTableRequest.newBuilder().setTablePath(storeName).build();
        try {
            CreateTableResponse response = this.blockingStub.createTable(request);
            if (response.getError().getErrCode() == ErrorCode.TABLE_ALREADY_EXISTS) {
                throw new StoreExistsException(storeName);
            }
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.clearJWTToken();
                return this.createStore(storeName);
            }
            throw e;
        }
        return new DocumentStoreImpl(this, storeName, this.options);
    }

    @Override
    public GrpcDocumentStore createStore(String storeName, Document options) throws OjaiException {
        return this.createStore(storeName);
    }

    public boolean deleteStore(String storeName) throws OjaiException {
        DeleteTableRequest request = DeleteTableRequest.newBuilder().setTablePath(storeName).build();
        try {
            this.blockingStub.deleteTable(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.clearJWTToken();
                this.deleteStore(storeName);
            }
            throw e;
        }
        return true;
    }

    public boolean storeExists(String storeName) throws OjaiException {
        TableExistsRequest request = TableExistsRequest.newBuilder().setTablePath(storeName).build();
        try {
            TableExistsResponse response = this.blockingStub.tableExists(request);
            return response.getError().getErrCode() != ErrorCode.TABLE_NOT_FOUND;
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getDescription() != null && e.getStatus().getDescription().equalsIgnoreCase("STATUS_TOKEN_EXPIRED")) {
                this.clearJWTToken();
                return this.storeExists(storeName);
            }
            throw e;
        }
    }

    static {
        Object[] requiredOptions = new String[]{KEY_USER};
        Arrays.sort(requiredOptions);
        REQUIRED_OPTIONS = requiredOptions;
        Object[] validOptions = new String[]{KEY_AUTH, KEY_USER, KEY_PASSWORD, KEY_SSL, KEY_SSLVALIDATE, KEY_SSLCA, KEY_CHECKSERVERIDENTITY, KEY_MAX_MSG_SIZE};
        Arrays.sort(validOptions);
        VALID_OPTIONS = validOptions;
    }
}

