/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.client.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.mapr.db.client.impl.ThinDriver;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.store.QueryCondition;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;

public class QueryConditionImpl
implements QueryCondition {
    private static final ObjectMapper mapper = ThinDriver.getMapper();
    private ObjectNode rootNode = null;
    private Stack<ArrayNode> nodeStack = null;
    private boolean built = false;
    private String jsonString;

    public boolean isEmpty() {
        return this.rootNode == null || this.rootNode.size() == 0;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public QueryCondition and() {
        return this.addContainer("$and");
    }

    public QueryCondition or() {
        return this.addContainer("$or");
    }

    public QueryCondition elementAnd(String fieldPath) {
        return this.addContainer("$elementAnd", fieldPath);
    }

    public QueryCondition elementAnd(FieldPath fieldPath) {
        return this.elementAnd(fieldPath.asPathString());
    }

    public QueryCondition close() {
        if (this.nodeStack == null || this.nodeStack.isEmpty()) {
            throw new IllegalStateException("Not in a condition block.");
        }
        this.nodeStack.pop();
        return this;
    }

    public QueryCondition build() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The condition is already built.");
        Preconditions.checkState((this.nodeStack == null || this.nodeStack.isEmpty() ? 1 : 0) != 0, (Object)"At least one condition group is not closed.");
        try {
            this.jsonString = mapper.writeValueAsString((Object)this.rootNode);
            this.built = true;
            return this;
        }
        catch (JsonProcessingException e) {
            throw new OjaiException((Throwable)e);
        }
    }

    public QueryCondition condition(QueryCondition conditionToAdd) {
        Preconditions.checkNotNull((Object)conditionToAdd);
        if (conditionToAdd == this) {
            throw new IllegalArgumentException("A condition can not be added to itself");
        }
        if (!conditionToAdd.isBuilt()) {
            throw new IllegalArgumentException("The specified condition is not built\n" + conditionToAdd);
        }
        if (conditionToAdd.isEmpty()) {
            throw new IllegalArgumentException("Can not add an empty condition");
        }
        QueryConditionImpl other = (QueryConditionImpl)conditionToAdd;
        Iterator nodeIterator = other.rootNode.fieldNames();
        while (nodeIterator.hasNext()) {
            String tag = (String)nodeIterator.next();
            this.addConditionContainer(tag, other.rootNode.get(tag));
        }
        return this;
    }

    public QueryCondition exists(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.addNode("$exists", path);
    }

    public QueryCondition exists(FieldPath path) {
        Preconditions.checkNotNull((Object)path);
        return this.exists(path.asPathString());
    }

    public QueryCondition notExists(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.addNode("$notexists", path);
    }

    public QueryCondition notExists(FieldPath path) {
        Preconditions.checkNotNull((Object)path);
        return this.notExists(path.asPathString());
    }

    public QueryCondition in(String path, List<? extends Object> listOfValue) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(listOfValue));
        return this.addNode("$in", node);
    }

    public QueryCondition in(FieldPath path, List<? extends Object> listOfValue) {
        Preconditions.checkNotNull((Object)path);
        return this.in(path.asPathString(), listOfValue);
    }

    public QueryCondition notIn(String path, List<? extends Object> listOfValue) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(listOfValue));
        return this.addNode("$notin", node);
    }

    public QueryCondition notIn(FieldPath path, List<? extends Object> listOfValue) {
        Preconditions.checkNotNull((Object)path);
        return this.notIn(path.asPathString(), listOfValue);
    }

    public QueryCondition typeOf(String path, Value.Type type) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, type.name());
        return this.addNode("$typeof", node);
    }

    public QueryCondition typeOf(FieldPath path, Value.Type type) {
        Preconditions.checkNotNull((Object)path);
        return this.typeOf(path.asPathString(), type);
    }

    public QueryCondition notTypeOf(String path, Value.Type type) {
        ObjectNode node = mapper.createObjectNode().put(path, type.name());
        return this.addNode("$nottypeof", node);
    }

    public QueryCondition notTypeOf(FieldPath path, Value.Type type) {
        Preconditions.checkNotNull((Object)path);
        return this.notTypeOf(path.asPathString(), type);
    }

    public QueryCondition matches(String path, String regex) {
        ObjectNode node = mapper.createObjectNode().put(path, regex);
        return this.addNode("$matches", node);
    }

    public QueryCondition matches(FieldPath path, String regex) {
        Preconditions.checkNotNull((Object)path);
        return this.matches(path.asPathString(), regex);
    }

    public QueryCondition notMatches(String path, String regex) {
        ObjectNode node = mapper.createObjectNode().put(path, regex);
        return this.addNode("$notmatches", node);
    }

    public QueryCondition notMatches(FieldPath path, String regex) {
        Preconditions.checkNotNull((Object)path);
        return this.notMatches(path.asPathString(), regex);
    }

    public QueryCondition like(String path, String likeExpression) {
        ObjectNode node = mapper.createObjectNode().put(path, likeExpression);
        return this.addNode("$like", node);
    }

    public QueryCondition like(FieldPath path, String likeExpression) {
        Preconditions.checkNotNull((Object)path);
        return this.like(path.asPathString(), likeExpression);
    }

    public QueryCondition like(String path, String likeExpression, Character escapeChar) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, (JsonNode)mapper.createArrayNode().add(likeExpression).add(String.valueOf(escapeChar)));
        return this.addNode("$like", node);
    }

    public QueryCondition like(FieldPath path, String likeExpression, Character escapeChar) {
        Preconditions.checkNotNull((Object)path);
        return this.like(path.asPathString(), likeExpression, escapeChar);
    }

    public QueryCondition notLike(String path, String likeExpression) {
        ObjectNode node = mapper.createObjectNode().put(path, likeExpression);
        return this.addNode("$notlike", node);
    }

    public QueryCondition notLike(FieldPath path, String likeExpression) {
        Preconditions.checkNotNull((Object)path);
        return this.notLike(path.asPathString(), likeExpression);
    }

    public QueryCondition notLike(String path, String likeExpression, Character escapeChar) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, (JsonNode)mapper.createArrayNode().add(likeExpression).add(String.valueOf(escapeChar)));
        return this.addNode("$notlike", node);
    }

    public QueryCondition notLike(FieldPath path, String likeExpression, Character escapeChar) {
        Preconditions.checkNotNull((Object)path);
        return this.notLike(path.asPathString(), likeExpression, escapeChar);
    }

    public QueryCondition is(String path, QueryCondition.Op op, boolean value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, boolean value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, String value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, String value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, byte value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, (short)value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, byte value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, short value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, short value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, int value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, int value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, long value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, long value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, float value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, float value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, double value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, double value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, BigDecimal value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode node = mapper.createObjectNode().put(path, value);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, BigDecimal value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, ODate value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode valnode = mapper.createObjectNode().put("$dateDay", value.toDateStr());
        ObjectNode node = (ObjectNode)mapper.createObjectNode().set(path, (JsonNode)valnode);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, ODate value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, OTime value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode valnode = mapper.createObjectNode().put("$time", value.toTimeStr());
        ObjectNode node = (ObjectNode)mapper.createObjectNode().set(path, (JsonNode)valnode);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, OTime value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, OTimestamp value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode valnode = mapper.createObjectNode().put("$date", value.toString());
        ObjectNode node = (ObjectNode)mapper.createObjectNode().set(path, (JsonNode)valnode);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, OTimestamp value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, OInterval value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode valnode = mapper.createObjectNode().put("$interval", value.toString());
        ObjectNode node = (ObjectNode)mapper.createObjectNode().set(path, (JsonNode)valnode);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, OInterval value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition is(String path, QueryCondition.Op op, ByteBuffer value) {
        Preconditions.checkNotNull((Object)path);
        ObjectNode valnode = mapper.createObjectNode().put("$binary", Base64.getEncoder().encodeToString(value.array()));
        ObjectNode node = (ObjectNode)mapper.createObjectNode().set(path, (JsonNode)valnode);
        return this.addNode(op.getTagName(), node);
    }

    public QueryCondition is(FieldPath path, QueryCondition.Op op, ByteBuffer value) {
        Preconditions.checkNotNull((Object)path);
        return this.is(path.asPathString(), op, value);
    }

    public QueryCondition equals(String path, Map<String, ? extends Object> value) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(value));
        return this.addNode("$eq", node);
    }

    public QueryCondition equals(FieldPath path, Map<String, ? extends Object> value) {
        Preconditions.checkNotNull((Object)path);
        return this.equals(path.asPathString(), value);
    }

    public QueryCondition equals(String path, List<? extends Object> value) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(value));
        return this.addNode("$eq", node);
    }

    public QueryCondition equals(FieldPath path, List<? extends Object> value) {
        Preconditions.checkNotNull((Object)path);
        return this.equals(path.asPathString(), value);
    }

    public QueryCondition notEquals(String path, Map<String, ? extends Object> value) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(value));
        return this.addNode("$ne", node);
    }

    public QueryCondition notEquals(FieldPath path, Map<String, ? extends Object> value) {
        Preconditions.checkNotNull((Object)path);
        return this.notEquals(path.asPathString(), value);
    }

    public QueryCondition notEquals(String path, List<? extends Object> value) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, mapper.valueToTree(value));
        return this.addNode("$ne", node);
    }

    public QueryCondition notEquals(FieldPath path, List<? extends Object> value) {
        Preconditions.checkNotNull((Object)path);
        return this.notEquals(path.asPathString(), value);
    }

    public QueryCondition sizeOf(String path, QueryCondition.Op op, long size) {
        ObjectNode node = mapper.createObjectNode();
        node.set(path, (JsonNode)mapper.createObjectNode().put(op.getTagName(), size));
        return this.addNode("$sizeof", node);
    }

    public QueryCondition sizeOf(FieldPath path, QueryCondition.Op op, long size) {
        Preconditions.checkNotNull((Object)path);
        return this.sizeOf(path.asPathString(), op, size);
    }

    public String asJsonString() {
        Preconditions.checkState((boolean)this.built, (Object)"QueryCondition is not built!");
        return this.jsonString;
    }

    private QueryCondition addConditionContainer(String containerTag, JsonNode nodeName) {
        this.checkNotBuilt();
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        ArrayNode andNodes = (ArrayNode)nodeName;
        ObjectNode childNode = mapper.createObjectNode();
        childNode.set(containerTag, (JsonNode)andNodes);
        if (this.rootNode == null) {
            this.rootNode = childNode;
        } else {
            this.nodeStack.peek().add((JsonNode)childNode);
        }
        return this;
    }

    private QueryCondition addContainer(String containerTag, String nodeName) {
        this.checkNotBuilt();
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        ArrayNode andNodes = mapper.createArrayNode();
        ObjectNode childNode = mapper.createObjectNode();
        childNode.set(nodeName, (JsonNode)andNodes);
        ObjectNode topNode = mapper.createObjectNode();
        topNode.set(containerTag, (JsonNode)childNode);
        if (this.rootNode == null) {
            this.rootNode = topNode;
        } else {
            this.nodeStack.peek().add((JsonNode)topNode);
        }
        this.nodeStack.push(andNodes);
        return this;
    }

    private QueryCondition addContainer(String containerTag) {
        this.checkNotBuilt();
        if (this.nodeStack == null) {
            this.nodeStack = new Stack();
        }
        ArrayNode andNodes = mapper.createArrayNode();
        ObjectNode childNode = mapper.createObjectNode();
        childNode.set(containerTag, (JsonNode)andNodes);
        if (this.rootNode == null) {
            this.rootNode = childNode;
        } else {
            this.nodeStack.peek().add((JsonNode)childNode);
        }
        this.nodeStack.push(andNodes);
        return this;
    }

    private QueryCondition addNode(String nodeName, ObjectNode nodeObj) {
        this.checkNotBuilt();
        this.checkNodeState();
        ObjectNode childNode = mapper.createObjectNode();
        childNode.set(nodeName, (JsonNode)nodeObj);
        if (this.rootNode == null) {
            this.rootNode = childNode;
        } else {
            this.nodeStack.peek().add((JsonNode)childNode);
        }
        return this;
    }

    private QueryCondition addNode(String nodeName, String nodeValue) {
        this.checkNotBuilt();
        this.checkNodeState();
        ObjectNode childNode = mapper.createObjectNode();
        childNode.put(nodeName, nodeValue);
        if (this.rootNode == null) {
            this.rootNode = childNode;
        } else {
            this.nodeStack.peek().add((JsonNode)childNode);
        }
        return this;
    }

    private void checkNodeState() {
        Preconditions.checkState((this.rootNode == null || this.nodeStack != null ? 1 : 0) != 0, (Object)"A condition can only be added as root or a child of another logical connecter.");
    }

    private void checkNotBuilt() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The condition is already built.");
    }

    public String toString() {
        return this.jsonString;
    }
}

