/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.client.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.mapr.db.client.impl.ConnectionImpl;
import com.mapr.db.client.impl.DocumentMutationImpl;
import com.mapr.db.client.impl.QueryConditionImpl;
import com.mapr.db.client.impl.QueryImpl;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.exceptions.DecodingException;
import org.ojai.exceptions.OjaiException;
import org.ojai.exceptions.ParseException;
import org.ojai.json.Json;
import org.ojai.store.Connection;
import org.ojai.store.DocumentMutation;
import org.ojai.store.Driver;
import org.ojai.store.DriverManager;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.ValueBuilder;

public class ThinDriver
implements Driver {
    private static final Driver DRIVER_INSTANCE = new ThinDriver();
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public Document newDocument() {
        return Json.newDocument();
    }

    public Document newDocument(String documentJson) throws DecodingException {
        return Json.newDocument((String)documentJson);
    }

    public Document newDocument(Map<String, Object> map) throws DecodingException {
        return Json.newDocument(map);
    }

    public Document newDocument(Object bean) throws DecodingException {
        return Json.newDocument((Object)bean);
    }

    public DocumentBuilder newDocumentBuilder() {
        return Json.newDocumentBuilder();
    }

    public DocumentMutation newMutation() {
        return new DocumentMutationImpl();
    }

    public QueryCondition newCondition() {
        return new QueryConditionImpl();
    }

    public ValueBuilder getValueBuilder() {
        return Json.getValueBuilder();
    }

    public boolean accepts(String url) {
        return url.startsWith("ojai:mapr:thin:@");
    }

    public Connection connect(String url, Document options) throws OjaiException {
        Preconditions.checkArgument((boolean)this.accepts(url), (String)"Invalid OJAI URL! URL must start with %s.", (Object)"ojai:mapr:thin:@");
        String connectionParams = url.substring(url.indexOf(64) + 1);
        return new ConnectionImpl(this, connectionParams, options);
    }

    public String getName() {
        return "MapR OJAI Thin Driver";
    }

    public String toString() {
        return this.getName();
    }

    public Query newQuery() {
        return new QueryImpl();
    }

    public Query newQuery(String queryJson) {
        return ThinDriver.parseJsonQuery(queryJson);
    }

    private static Query parseJsonQuery(String queryJson) {
        JSONObject jsonObj = new JSONObject(queryJson);
        QueryImpl query = new QueryImpl();
        jsonObj.keySet().forEach(key -> {
            switch (key) {
                case "$limit": {
                    query.limit(jsonObj.getLong(key));
                    break;
                }
                case "$offset": {
                    query.offset(jsonObj.getLong(key));
                    break;
                }
                case "$select": {
                    JSONArray jsonArray = jsonObj.getJSONArray(key);
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        query.select(jsonArray.getString(i));
                    }
                    break;
                }
                case "$orderby": {
                    JSONObject sortedFields = jsonObj.getJSONObject(key);
                    sortedFields.keySet().forEach(orderKey -> query.orderBy((String)orderKey, sortedFields.getString(orderKey).toUpperCase()));
                    break;
                }
                case "$where": {
                    query.where(jsonObj.getJSONObject(key));
                    break;
                }
                default: {
                    throw new ParseException(String.format("Unable to parse given query due to an unknown key: %s", key));
                }
            }
        });
        return query;
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    static {
        DriverManager.registerDriver((Driver)DRIVER_INSTANCE);
    }
}

