/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.client.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.mapr.db.client.impl.QueryConditionImpl;
import com.mapr.db.client.impl.ThinDriver;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.exceptions.OjaiException;
import org.ojai.exceptions.TypeException;
import org.ojai.store.Query;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;
import org.ojai.util.Fields;

public class QueryImpl
implements Query {
    static Query EMPTY_QUERY = new QueryImpl().build();
    private boolean built = false;
    private final HashSet<FieldPath> selectFields = new HashSet();
    private QueryCondition queryCondition = null;
    private List<Map.Entry<FieldPath, SortOrder>> sortKeys = null;
    private long limit = -1L;
    private long offset = -1L;
    private String jsonString;

    QueryImpl() {
    }

    public Query setOption(String optionName, Object value) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Object getOption(String optionName) {
        throw new UnsupportedOperationException();
    }

    public Query setOptions(Document options) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query setTimeout(long timeoutInMilliseconds) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query waitForTrackedWrites(String writesContext) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public Query select(String ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        return this.select(Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Query select(FieldPath ... fieldPaths) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)fieldPaths);
        this.checkNotBuilt();
        Collections.addAll(this.selectFields, fieldPaths);
        return this;
    }

    public Query where(String conditionJson) throws OjaiException, IllegalArgumentException {
        return this.where(new JSONObject(conditionJson));
    }

    Query where(JSONObject jsonCondition) {
        QueryConditionImpl condition = new QueryConditionImpl();
        this.parseCondition(jsonCondition, condition);
        this.where(condition.build());
        return this;
    }

    private void parseCondition(JSONObject jsonCondition, QueryCondition condition) {
        jsonCondition.keySet().forEach(key -> {
            switch (key) {
                case "$and": {
                    condition.and();
                    JSONArray jsonArrayAnd = jsonCondition.getJSONArray(key);
                    for (int i = 0; i < jsonArrayAnd.length(); ++i) {
                        this.parseCondition(jsonArrayAnd.getJSONObject(i), condition);
                    }
                    condition.close();
                    break;
                }
                case "$or": {
                    condition.or();
                    JSONArray jsonArrayOr = jsonCondition.getJSONArray(key);
                    for (int i = 0; i < jsonArrayOr.length(); ++i) {
                        this.parseCondition(jsonArrayOr.getJSONObject(i), condition);
                    }
                    condition.close();
                    break;
                }
                case "$ge": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.GREATER_OR_EQUAL, jsonObject.get(k)));
                    break;
                }
                case "$eq": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.EQUAL, jsonObject.get(k)));
                    break;
                }
                case "$lt": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.LESS, jsonObject.get(k)));
                    break;
                }
                case "$le": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.LESS_OR_EQUAL, jsonObject.get(k)));
                    break;
                }
                case "$ne": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.NOT_EQUAL, jsonObject.get(k)));
                    break;
                }
                case "$gt": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> this.executeMethod(condition, (String)k, QueryCondition.Op.GREATER, jsonObject.get(k)));
                    break;
                }
                case "$elementAnd": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> {
                        condition.elementAnd(k);
                        JSONArray jsonArrayElementAnd = jsonObject.getJSONArray(k);
                        for (int i = 0; i < jsonArrayElementAnd.length(); ++i) {
                            this.parseCondition(jsonArrayElementAnd.getJSONObject(i), condition);
                        }
                    });
                    condition.close();
                    break;
                }
                case "$exists": {
                    condition.exists(jsonCondition.getString(key));
                    break;
                }
                case "$notexists": {
                    condition.notExists(jsonCondition.getString(key));
                    break;
                }
                case "$in": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    this.inNotIn(jsonObject, (arg_0, arg_1) -> ((QueryCondition)condition).in(arg_0, arg_1));
                    break;
                }
                case "$notin": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    this.inNotIn(jsonObject, (arg_0, arg_1) -> ((QueryCondition)condition).notIn(arg_0, arg_1));
                    break;
                }
                case "$typeof": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.typeOf(k, (Value.Type)jsonObject.get(k)));
                    break;
                }
                case "$nottypeof": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.notTypeOf(k, (Value.Type)jsonObject.get(k)));
                    break;
                }
                case "$matches": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.matches(k, jsonObject.getString(k)));
                    break;
                }
                case "$notmatches": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.notMatches(k, jsonObject.getString(k)));
                    break;
                }
                case "$like": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.like(k, jsonObject.getString(k)));
                    break;
                }
                case "$notlike": {
                    JSONObject jsonObject = jsonCondition.getJSONObject(key);
                    jsonObject.keySet().forEach(k -> condition.notLike(k, jsonObject.getString(k)));
                    break;
                }
                default: {
                    System.out.println("default");
                }
            }
        });
    }

    private void inNotIn(JSONObject jsonObject, BiFunction<String, List<? extends Object>, QueryCondition> f) {
        jsonObject.keySet().forEach(k -> {
            JSONArray jsonArray = jsonObject.getJSONArray(k);
            ArrayList<Object> inList = new ArrayList<Object>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                inList.add(jsonArray.get(i));
            }
            f.apply((String)k, (List<? extends Object>)inList);
        });
    }

    private void executeMethod(QueryCondition condition, String key, QueryCondition.Op op, Object value) {
        if (value instanceof Integer) {
            condition.is(key, op, ((Integer)value).intValue());
        } else if (value instanceof Boolean) {
            condition.is(key, op, ((Boolean)value).booleanValue());
        } else if (value instanceof Double) {
            condition.is(key, op, ((Double)value).doubleValue());
        } else if (value instanceof String) {
            condition.is(key, op, (String)value);
        } else if (value instanceof Float) {
            condition.is(key, op, ((Float)value).floatValue());
        } else if (value instanceof Short) {
            condition.is(key, op, ((Short)value).shortValue());
        } else if (value instanceof Byte) {
            condition.is(key, op, ((Byte)value).byteValue());
        } else if (value instanceof Long) {
            condition.is(key, op, ((Long)value).longValue());
        } else {
            throw new TypeException("Unsupported type");
        }
    }

    public Query where(QueryCondition condition) throws OjaiException, IllegalArgumentException {
        this.checkNotBuilt();
        if (!condition.isEmpty()) {
            this.queryCondition = condition;
        }
        return this;
    }

    public Query orderBy(String ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        return this.orderBy(Fields.toFieldPathArray((String[])fieldPaths));
    }

    public Query orderBy(FieldPath ... fieldPaths) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((fieldPaths != null && fieldPaths.length > 0 ? 1 : 0) != 0, (Object)"no sort keys specified");
        for (FieldPath fieldPath : fieldPaths) {
            this.orderBy(fieldPath, SortOrder.ASC);
        }
        return this;
    }

    public Query orderBy(String field, String order) throws IllegalArgumentException {
        this.checkNotBuilt();
        return this.orderBy(FieldPath.parseFrom((String)field), SortOrder.valueOf((String)order));
    }

    public Query orderBy(String field, SortOrder order) throws IllegalArgumentException {
        this.checkNotBuilt();
        return this.orderBy(FieldPath.parseFrom((String)field), order);
    }

    public Query orderBy(FieldPath field, SortOrder order) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (Object)"fieldPath must be non-null");
        Preconditions.checkArgument((order != null ? 1 : 0) != 0, (Object)"sortOrder must be non-null");
        if (this.sortKeys == null) {
            this.sortKeys = new LinkedList<Map.Entry<FieldPath, SortOrder>>();
        }
        this.sortKeys.add(new AbstractMap.SimpleEntry<FieldPath, SortOrder>(field, order));
        return this;
    }

    public Query offset(long offset) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"offset must be non-negative");
        this.offset = offset;
        return this;
    }

    public Query limit(long limit) throws IllegalArgumentException {
        this.checkNotBuilt();
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be non-negative");
        this.limit = limit;
        return this;
    }

    public boolean isBuilt() {
        return this.built;
    }

    public Query build() {
        this.checkNotBuilt();
        if (this.queryCondition != null && !this.queryCondition.isBuilt()) {
            this.queryCondition.build();
        }
        ObjectMapper mapper = ThinDriver.getMapper();
        ObjectNode queryNode = mapper.createObjectNode();
        try {
            ArrayNode arrayNode;
            if (this.selectFields.size() > 0) {
                arrayNode = mapper.createArrayNode();
                for (FieldPath fieldPath : this.selectFields) {
                    arrayNode.add(fieldPath.asPathString());
                }
                queryNode.set("$select", (JsonNode)arrayNode);
            }
            if (this.queryCondition != null) {
                JsonNode whereNode = mapper.readTree(this.queryCondition.asJsonString());
                queryNode.set("$where", whereNode);
            }
            if (this.sortKeys != null) {
                arrayNode = mapper.createArrayNode();
                for (Map.Entry entry : this.sortKeys) {
                    ObjectNode sortNode = mapper.createObjectNode();
                    sortNode.put(((FieldPath)entry.getKey()).asPathString(), ((SortOrder)entry.getValue()).toString());
                    arrayNode.add((JsonNode)sortNode);
                }
                queryNode.set("$orderby", (JsonNode)arrayNode);
            }
            if (this.limit != -1L) {
                queryNode.put("$limit", this.limit);
            }
            if (this.offset != -1L) {
                queryNode.put("$offset", this.offset);
            }
            this.jsonString = mapper.writeValueAsString((Object)queryNode);
            this.built = true;
            return this;
        }
        catch (IOException e) {
            throw new OjaiException((Throwable)e);
        }
    }

    public String asJsonString() {
        Preconditions.checkState((boolean)this.built, (Object)"Query is not built!");
        return this.jsonString;
    }

    public boolean isEmpty() {
        return this.limit < 0L && this.offset < 0L && this.selectFields.size() == 0 && this.queryCondition == null && this.sortKeys == null;
    }

    private void checkNotBuilt() {
        Preconditions.checkState((!this.built ? 1 : 0) != 0, (Object)"The OJAI Query is already built!");
    }

    public String toString() {
        return this.jsonString;
    }
}

