/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.google.common.base.Preconditions;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ByteBufferReader
extends ByteReader {
    private final int baseIdx;
    private final int length;
    private final ByteBuffer buffer;

    ByteBufferReader(ByteBuffer buff) {
        Preconditions.checkNotNull((Object)buff);
        this.buffer = buff;
        this.length = buff.remaining();
        this.baseIdx = buff.position();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte nextUnsafe() {
        return this.buffer.get();
    }

    @Override
    public byte getByte(int idx) {
        return this.buffer.get(this.baseIdx + idx);
    }

    @Override
    public ByteReader mark() {
        this.buffer.mark();
        return this;
    }

    @Override
    public ByteReader reset() {
        this.buffer.reset();
        return this;
    }

    @Override
    public byte[] copyOfRange(int from, int to) {
        return Arrays.copyOfRange(Bytes.getBytes(this.buffer), from, to);
    }

    public static ByteReader wrap(ByteBuffer buff) {
        return new ByteBufferReader(buff);
    }
}

