/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import sun.misc.Unsafe;

public class Classpath {
    private static final ClassLoader classLoader;

    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            Classpath.run(args);
        }
    }

    public static void run(String[] args) {
        String firstArg;
        switch (firstArg = args[0]) {
            case "-path": 
            case "-classpath": {
                System.out.println(System.getProperty("java.class.path"));
                break;
            }
            case "-urls": 
            case "-classurls": {
                URL[] urls = Classpath.getURLs(classLoader);
                if (urls != null) {
                    for (URL url : urls) {
                        System.out.println(url);
                    }
                    break;
                }
                System.err.println("The current classloader is not an instance of URLClassLoader.");
                break;
            }
            default: {
                URL url = classLoader.getResource(firstArg);
                if (url != null) {
                    System.out.println(url);
                    break;
                }
                System.err.printf("The resource '%s' wasn't found in the classpath.\n", firstArg);
            }
        }
    }

    public static URL[] getURLs(ClassLoader cl) {
        if (cl instanceof URLClassLoader) {
            return ((URLClassLoader)cl).getURLs();
        }
        if (cl.getClass().getName().startsWith("jdk.internal.loader.ClassLoaders$AppClassLoader")) {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                Unsafe unsafe = (Unsafe)field.get(null);
                Field ucpField = cl.getClass().getDeclaredField("ucp");
                long ucpFieldOffset = unsafe.objectFieldOffset(ucpField);
                Object ucpObject = unsafe.getObject(cl, ucpFieldOffset);
                Field pathField = ucpField.getType().getDeclaredField("path");
                long pathFieldOffset = unsafe.objectFieldOffset(pathField);
                List path = (List)unsafe.getObject(ucpObject, pathFieldOffset);
                return path.toArray(new URL[path.size()]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Classpath.class.getClassLoader();
        }
        classLoader = cl;
    }
}

