/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.google.common.base.Preconditions;
import com.mapr.utils.ByteReader;
import java.util.Arrays;

public class ByteArrayReader
extends ByteReader {
    private final int baseIdx;
    private final int length;
    private final int maxIdx;
    private final byte[] buffer;
    private int cursor;
    private int mark = -1;

    ByteArrayReader(byte[] buff, int offset, int len) {
        Preconditions.checkNotNull((Object)buff);
        this.buffer = buff;
        this.length = len;
        this.baseIdx = this.cursor = offset;
        this.maxIdx = offset + len;
        Preconditions.checkArgument((this.maxIdx <= buff.length ? 1 : 0) != 0, (Object)"Either the offset of the length is outside the array boundary");
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte nextUnsafe() {
        return this.buffer[this.cursor++];
    }

    @Override
    public byte getByte(int idx) {
        return this.buffer[this.baseIdx + idx];
    }

    @Override
    public ByteReader mark() {
        this.mark = this.cursor;
        return this;
    }

    @Override
    public ByteReader reset() {
        if (this.mark != -1) {
            this.cursor = this.mark;
            this.mark = -1;
        }
        return this;
    }

    @Override
    public byte[] copyOfRange(int from, int to) {
        return Arrays.copyOfRange(this.buffer, from, to);
    }
}

