/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.mapr.utils.IndentingStringBuilder;

public class PrependingStringBuilder
extends IndentingStringBuilder {
    private final IndentingStringBuilder isb;
    private boolean triggered = false;
    private final String prependString;

    public PrependingStringBuilder(IndentingStringBuilder isb, String prependString) {
        super(new StringBuilder(0));
        this.isb = isb;
        this.prependString = prependString;
    }

    @Override
    public String toString() {
        return this.isb.toString();
    }

    @Override
    public int length() {
        return this.isb.length();
    }

    public boolean triggered() {
        return this.triggered;
    }

    private void checkTrigger() {
        if (!this.triggered) {
            this.isb.append(this.prependString);
            this.triggered = true;
        }
    }

    @Override
    public IndentingStringBuilder append(String v) {
        this.checkTrigger();
        this.isb.append(v);
        return this;
    }

    @Override
    public IndentingStringBuilder append(char v) {
        this.checkTrigger();
        this.isb.append(v);
        return this;
    }

    @Override
    public IndentingStringBuilder append(long v) {
        this.checkTrigger();
        this.isb.append(v);
        return this;
    }

    @Override
    public IndentingStringBuilder nextLine() {
        this.isb.nextLine();
        return this;
    }

    @Override
    public IndentingStringBuilder pushIndent() {
        this.isb.pushIndent();
        return this;
    }

    @Override
    public IndentingStringBuilder popIndent() {
        this.isb.popIndent();
        return this;
    }

    @Override
    public IndentingStringBuilder addComment(String comment) {
        this.isb.addComment(comment);
        return this;
    }
}

