/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import com.mapr.utils.ByteArrayReader;
import com.mapr.utils.ByteBufferReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ByteReader {
    private ByteOrder order = ByteOrder.nativeOrder();

    public static ByteReader wrap(byte[] buff) {
        return new ByteArrayReader(buff, 0, buff.length);
    }

    public static ByteReader wrap(byte[] buff, int offset, int length) {
        return new ByteArrayReader(buff, offset, length);
    }

    public static ByteReader wrap(ByteBuffer buff) {
        return new ByteBufferReader(buff);
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public ByteReader setOrder(ByteOrder order) {
        this.order = order;
        return this;
    }

    public abstract int length();

    public abstract byte nextUnsafe();

    public abstract byte getByte(int var1);

    public abstract ByteReader mark();

    public abstract ByteReader reset();

    public abstract byte[] copyOfRange(int var1, int var2);

    public int getInt(int idx) {
        return this.order == ByteOrder.BIG_ENDIAN ? this.getIntB(idx) : this.getIntL(idx);
    }

    public long getLong(int idx) {
        return this.order == ByteOrder.BIG_ENDIAN ? this.getLongB(idx) : this.getLongL(idx);
    }

    protected int getIntL(int idx) {
        return this.makeInt(this.getByte(idx + 3), this.getByte(idx + 2), this.getByte(idx + 1), this.getByte(idx));
    }

    protected int getIntB(int idx) {
        return this.makeInt(this.getByte(idx), this.getByte(idx + 1), this.getByte(idx + 2), this.getByte(idx + 3));
    }

    protected int makeInt(byte b3, byte b2, byte b1, byte b0) {
        return b3 << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | b0 & 0xFF;
    }

    protected long getLongL(int idx) {
        return this.makeLong(this.getByte(idx + 7), this.getByte(idx + 6), this.getByte(idx + 5), this.getByte(idx + 4), this.getByte(idx + 3), this.getByte(idx + 2), this.getByte(idx + 1), this.getByte(idx));
    }

    protected long getLongB(int idx) {
        return this.makeLong(this.getByte(idx), this.getByte(idx + 1), this.getByte(idx + 2), this.getByte(idx + 3), this.getByte(idx + 4), this.getByte(idx + 5), this.getByte(idx + 6), this.getByte(idx + 7));
    }

    protected long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
        return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
    }
}

