/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.service;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mapr.config.Config;
import com.mapr.service.Lifecycle;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Future;
import lombok.NonNull;

public abstract class AbstractComponent
implements Lifecycle<AbstractComponent> {
    protected Lifecycle.State state = Lifecycle.State.Unknown;
    private final String name;
    private final LinkedList<AbstractComponent> subComponentList;
    private final Iterable<AbstractComponent> reverseSubComponentItrbl = new Iterable<AbstractComponent>(){

        @Override
        public Iterator<AbstractComponent> iterator() {
            return AbstractComponent.this.subComponentList.descendingIterator();
        }
    };
    @NonNull
    protected Config conf;

    public AbstractComponent() {
        this.name = this.getClass().getSimpleName() + "@" + super.hashCode();
        this.subComponentList = new LinkedList();
    }

    @Override
    public boolean isRunning() {
        return this.state == Lifecycle.State.Running;
    }

    @Override
    public AbstractComponent init(Config gConf) {
        Preconditions.checkNotNull((Object)gConf);
        Preconditions.checkState((this.state == Lifecycle.State.Unknown ? 1 : 0) != 0, (String)"%s is already initialized!", (Object)this.name);
        this.conf = gConf;
        this.initComponent();
        this.state = Lifecycle.State.Initialized;
        return this;
    }

    protected abstract void initComponent();

    @Override
    public AbstractComponent start() {
        Preconditions.checkState((!this.isRunning() ? 1 : 0) != 0, (String)"%s is already running!", (Object)this.name);
        this.state = Lifecycle.State.Running;
        try {
            this.startComponent();
        }
        catch (Throwable t) {
            this.state = Lifecycle.State.Aborted;
            throw t;
        }
        return this;
    }

    protected abstract void startComponent();

    @Override
    public void update(Config gConf) {
        this.conf = gConf;
        this.updateComponent();
    }

    protected abstract void updateComponent();

    @Override
    public ListenableFuture<?> stop() {
        Preconditions.checkState((boolean)this.isRunning(), (Object)"%s is not running!");
        ListenableFuture<?> future = this.initComponentShutdown();
        this.state = Lifecycle.State.AwatingShutdown;
        return future;
    }

    protected abstract ListenableFuture<?> initComponentShutdown();

    protected void initSubComponent(AbstractComponent subComponent) {
        subComponent.init(this.conf);
        this.subComponentList.add(subComponent);
    }

    protected void startSubComponents() {
        for (AbstractComponent component : this.subComponentList) {
            component.start();
        }
    }

    protected void updateSubComponents() {
        for (AbstractComponent component : this.subComponentList) {
            component.update(this.conf);
        }
    }

    protected Future<?> initSubComponentsShutdown() {
        LinkedList futures = new LinkedList();
        for (AbstractComponent component : this.reverseSubComponentItrbl) {
            futures.add(component.stop());
        }
        return Futures.allAsList(futures);
    }
}

