/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

public class Regexes {
    private static final String REGEX_OPTIONAL_CHARS = "?*";
    private static final String REGEX_SPECIAL_CHARS = "^.+*?()[{\\|$";

    public static String getRegexPrefix(String regexString) {
        boolean lastEscaped = false;
        boolean inRegexQuote = false;
        StringBuilder prefixSB = new StringBuilder();
        if (regexString.length() == 0) {
            return prefixSB.toString();
        }
        if (regexString.charAt(0) == '^') {
            regexString = regexString.substring(1);
        }
        for (int i = 0; i < regexString.length(); ++i) {
            char ch = regexString.charAt(i);
            if (inRegexQuote) {
                prefixSB.append(ch);
            }
            if (lastEscaped) {
                lastEscaped = false;
                if (ch == 'Q') {
                    inRegexQuote = true;
                    continue;
                }
                if (ch == 'E') {
                    if (inRegexQuote) {
                        prefixSB.setLength(prefixSB.length() - 2);
                    }
                    inRegexQuote = false;
                    continue;
                }
                if (REGEX_SPECIAL_CHARS.indexOf(ch) == -1) break;
                prefixSB.append(ch);
                continue;
            }
            if (ch == '\\') {
                lastEscaped = true;
                continue;
            }
            if (inRegexQuote) continue;
            if (REGEX_OPTIONAL_CHARS.indexOf(ch) != -1) {
                if (prefixSB.length() <= 0) break;
                prefixSB.setLength(prefixSB.length() - 1);
                break;
            }
            if (REGEX_SPECIAL_CHARS.indexOf(ch) != -1) break;
            prefixSB.append(ch);
        }
        return prefixSB.toString();
    }
}

