/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.tests.utils;

import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class BytesTest {
    @Test(expected=NullPointerException.class)
    public void test_createStopKeyForPrefix_null_prefix() {
        Bytes.createStopKeyForPrefix(null);
    }

    @Test
    public void test_createStopKeyForPrefix_empty_prefix() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])Bytes.EMPTY_BYTE_ARRAY);
        Assert.assertArrayEquals((byte[])Bytes.EMPTY_BYTE_ARRAY, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_0x00() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{0});
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_0x00_0x01() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{0, 1});
        Assert.assertArrayEquals((byte[])new byte[]{0, 2}, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_0x00_0xff() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{0, -1});
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_maxkey_one_byte() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{-1});
        Assert.assertArrayEquals((byte[])Bytes.EMPTY_BYTE_ARRAY, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_0xfe() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{-2});
        Assert.assertArrayEquals((byte[])new byte[]{-1}, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_maxkey_two_bytes() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{-1, -1});
        Assert.assertArrayEquals((byte[])Bytes.EMPTY_BYTE_ARRAY, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_0xfe_0xff() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{-2, -1});
        Assert.assertArrayEquals((byte[])new byte[]{-1}, (byte[])stopKey);
    }

    @Test
    public void test_createStopKeyForPrefix_maxkey_many_bytes() {
        byte[] stopKey = Bytes.createStopKeyForPrefix((byte[])new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        Assert.assertArrayEquals((byte[])Bytes.EMPTY_BYTE_ARRAY, (byte[])stopKey);
    }
}

