/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.tests.objectinstrumentation;

import com.google.common.collect.Lists;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;
import com.mapr.tests.BaseTest;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInstrumentationTest
extends BaseTest {
    private static Logger _logger = LoggerFactory.getLogger(ObjectInstrumentationTest.class);
    long instrumentations = 0L;
    int histogramThreshold = 10000;
    protected final AtomicLong totalObjectCount = new AtomicLong(0L);
    protected final AtomicLong totalObjectSize = new AtomicLong(0L);
    protected final Map<String, AtomicLong> classInstanceMap = new HashMap<String, AtomicLong>();
    protected final Map<String, AtomicLong> arrayInstanceMap = new HashMap<String, AtomicLong>();
    protected final LinkedList<AtomicLong> counters = new LinkedList();
    protected final Sampler objectSampler = new Sampler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sampleAllocation(int count, String clazz, Object newObj, long size) {
            if (ObjectInstrumentationTest.this.hasType(InstrumentationType.COUNT_OF_OBJECT)) {
                ObjectInstrumentationTest.this.totalObjectCount.incrementAndGet();
            }
            if (ObjectInstrumentationTest.this.hasType(InstrumentationType.SIZE_OF_OBJECTS)) {
                ObjectInstrumentationTest.this.totalObjectSize.addAndGet(size);
            }
            if (ObjectInstrumentationTest.this.hasType(InstrumentationType.CLASS_HISTOGRAM)) {
                AtomicLong counter = null;
                if (count < 0) {
                    counter = ObjectInstrumentationTest.this.classInstanceMap.get(clazz);
                    if (counter == null) {
                        Map<String, AtomicLong> map = ObjectInstrumentationTest.this.classInstanceMap;
                        synchronized (map) {
                            counter = ObjectInstrumentationTest.this.classInstanceMap.get(clazz);
                            if (counter == null && ObjectInstrumentationTest.this.counters.size() > 0) {
                                counter = ObjectInstrumentationTest.this.counters.poll();
                                ObjectInstrumentationTest.this.classInstanceMap.put(clazz, counter);
                            }
                        }
                    }
                } else {
                    counter = ObjectInstrumentationTest.this.arrayInstanceMap.get(clazz);
                    if (counter == null) {
                        Map<String, AtomicLong> map = ObjectInstrumentationTest.this.arrayInstanceMap;
                        synchronized (map) {
                            counter = ObjectInstrumentationTest.this.arrayInstanceMap.get(clazz);
                            if (counter == null && ObjectInstrumentationTest.this.counters.size() > 0) {
                                counter = ObjectInstrumentationTest.this.counters.poll();
                                ObjectInstrumentationTest.this.arrayInstanceMap.put(clazz, counter);
                            }
                        }
                    }
                }
                counter.incrementAndGet();
            }
        }
    };

    protected void setTypes(InstrumentationType ... types) {
        this.instrumentations = 0L;
        if (types != null) {
            for (InstrumentationType type : types) {
                this.instrumentations |= type.bit;
            }
        }
    }

    protected boolean hasType(InstrumentationType type) {
        return (this.instrumentations & type.bit) != 0L;
    }

    protected void setHistogramThreshold(int threshold) {
        this.histogramThreshold = threshold;
    }

    @Before
    public void beforeTest() {
        if (this.hasType(InstrumentationType.CLASS_HISTOGRAM)) {
            this.counters.clear();
            for (int i = 0; i < 10000; ++i) {
                this.counters.offer(new AtomicLong(0L));
            }
            this.classInstanceMap.clear();
            this.arrayInstanceMap.clear();
        }
        if (this.hasType(InstrumentationType.COUNT_OF_OBJECT)) {
            this.totalObjectCount.set(0L);
        }
        if (this.hasType(InstrumentationType.SIZE_OF_OBJECTS)) {
            this.totalObjectSize.set(0L);
        }
    }

    @After
    public void afterTest() {
        if (this.hasType(InstrumentationType.SIZE_OF_OBJECTS)) {
            _logger.info("Total number of objects created for test {}: {}.", (Object)this.TEST_NAME.getMethodName(), (Object)this.totalObjectCount.longValue());
        }
        if (this.hasType(InstrumentationType.COUNT_OF_OBJECT)) {
            _logger.info("Total size of objects created for test {}: {} bytes.", (Object)this.TEST_NAME.getMethodName(), (Object)this.totalObjectSize.longValue());
        }
        if (this.hasType(InstrumentationType.CLASS_HISTOGRAM)) {
            Map.Entry kv;
            int limit;
            ArrayList sortedList = Lists.newArrayListWithCapacity((int)(this.classInstanceMap.size() + this.arrayInstanceMap.size()));
            sortedList.addAll(this.classInstanceMap.entrySet());
            for (Map.Entry<String, AtomicLong> entry : this.arrayInstanceMap.entrySet()) {
                sortedList.add(new AbstractMap.SimpleEntry<String, AtomicLong>(entry.getKey() + "[]", entry.getValue()));
            }
            Collections.sort(sortedList, new Comparator<Map.Entry<String, AtomicLong>>(){

                @Override
                public int compare(Map.Entry<String, AtomicLong> o1, Map.Entry<String, AtomicLong> o2) {
                    return o2.getValue().intValue() - o1.getValue().intValue();
                }
            });
            StringBuilder sb = new StringBuilder();
            Iterator it = sortedList.iterator();
            int n = limit = System.getProperty("print.all.allocations") == null ? this.histogramThreshold : 1;
            while (it.hasNext() && ((AtomicLong)(kv = (Map.Entry)it.next()).getValue()).longValue() >= (long)limit) {
                sb.append(' ').append((String)kv.getKey()).append("\t").append(((AtomicLong)kv.getValue()).longValue()).append('\n');
            }
            _logger.info("Allocation histogram (with at least {} instances) for test {}#{}()\n{}", new Object[]{limit, this.getClass().getSimpleName(), this.TEST_NAME.getMethodName(), sb});
        }
    }

    protected void startSampling() {
        AllocationRecorder.addSampler((Sampler)this.objectSampler);
    }

    protected void stopSampling() {
        AllocationRecorder.removeSampler((Sampler)this.objectSampler);
    }

    static {
        ROOT_LOGGER.setLevel(Level.OFF);
        MAPR_LOGGER.setLevel(Level.INFO);
        ObjectInstrumentationTest.createLogger("com.mapr.tests.objectinstrumentation", new Appender[]{LOG_FILE});
    }

    protected static enum InstrumentationType {
        ALL(-1L),
        COUNT_OF_OBJECT(1L),
        SIZE_OF_OBJECTS(2L),
        CLASS_HISTOGRAM(4L);

        private final long bit;

        private InstrumentationType(long bit) {
            this.bit = bit;
        }
    }
}

