/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.utils;

import java.net.URL;
import java.net.URLClassLoader;

public class Classpath {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public Classpath() {
        if (this.classLoader == null) {
            this.classLoader = Classpath.class.getClassLoader();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0) {
            new Classpath().run(args);
        }
    }

    public void run(String[] args) {
        if ("-classpath".equals(args[0])) {
            System.out.println(System.getProperty("java.class.path"));
        } else if ("-classurls".equals(args[0])) {
            if (this.classLoader instanceof URLClassLoader) {
                URLClassLoader classloader = (URLClassLoader)this.classLoader;
                for (URL url : classloader.getURLs()) {
                    System.out.println(url);
                }
            } else {
                System.err.println("The current classloader is not an instance of URLClassLoader.");
            }
        } else {
            URL url = this.classLoader.getResource(args[0]);
            System.out.println(url);
        }
    }
}

