/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.tests;

import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.mapr.tests.annotations.ClusterTest;

public class SampleTest extends BaseTest {
  private static Logger logger = LoggerFactory.getLogger(SampleTest.class);
  private static org.apache.log4j.Logger _logger = org.apache.log4j.Logger.getLogger(SampleTest.class);

  @Test
  public void sampleTest() {
    logger.info("slf4j: Running sample test.");
    _logger.info("log4j: Running sample test.");
    Assert.assertTrue("Always true", true);
  }

  @Test
  @Category(ClusterTest.class)
  public void sampleClusterTest() {
    Assert.assertTrue(isClusterTest());
  }

  @AfterClass
  public static void afterTest() {
    _logger.error("Sample error message on screen.");
  }

}
