/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.utils;

public final class Crypto {
  private static final long FNV_offset_basis_64 = 0xCBF29CE484222325L;
  private static final long FNV_prime_64 = 1099511628211L;

  private static final int FNV_offset_basis_32 = 0x811c9dc5;
  private static final int FNV_prime_32 = 16777619;

  public static int fnvHash32(int val) {
    //from http://en.wikipedia.org/wiki/Fowler_Noll_Vo_hash
    int hashval = FNV_offset_basis_32;
    for (int i = 0; i < 4; i++) {
      int octet = val & 0x00ff;
      val = val >> 8;
      hashval = hashval ^ octet;
      hashval = hashval * FNV_prime_32;
    }
    return Math.abs(hashval);
  }

  public static long fnvHash64(long val) {
    //from http://en.wikipedia.org/wiki/Fowler_Noll_Vo_hash
    long hashval = FNV_offset_basis_64;
    for (int i = 0; i < 8; i++) {
      long octet = val & 0x00ff;
      val = val >> 8;
      hashval = hashval ^ octet;
      hashval = hashval * FNV_prime_64;
    }
    return Math.abs(hashval);
  }

}
