/* Copyright (c) 2015 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.utils;

import java.net.URL;
import java.net.URLClassLoader;

public class Classpath {
  private ClassLoader classLoader;
  {
    classLoader = Thread.currentThread().getContextClassLoader();
    if (classLoader == null) {
      classLoader = Classpath.class.getClassLoader();
    }
  }

  public static void main(String[] args) throws Exception {
    if (args != null && args.length > 0) {
      new Classpath().run(args);
    }
  }

  public void run(String[] args) {
    if ("-classpath".equals(args[0])) {
      System.out.println(System.getProperty("java.class.path"));
    } else if ("-classurls".equals(args[0])) {
      if (classLoader instanceof URLClassLoader) {
        URLClassLoader classloader = (URLClassLoader)classLoader;
        for (URL url : classloader.getURLs()) {
          System.out.println(url);
        }
      } else {
        System.err.println("The current classloader is not an instance of URLClassLoader.");
      }
    } else {
      URL url = classLoader.getResource(args[0]);
      System.out.println(url);
    }
  }

}
