/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.tests;

import com.mapr.tests.utils.Tests;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.rolling.FixedWindowRollingPolicy;
import org.apache.log4j.rolling.RollingFileAppender;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class BaseTest {
    long testDuration;
    private static Logger _logger = Logger.getLogger(BaseTest.class);
    static final String ROOT_MARKER_FILE = "repo-root-marker";
    @Rule
    public TestName TEST_NAME = new TestName();
    final TestLogReporter LOG_OUTCOME;
    @Rule
    public final TestLogReporter logOutcome = this.LOG_OUTCOME = new TestLogReporter();
    protected static final Logger ROOT_LOGGER;
    protected static final Logger MAPR_LOGGER;
    protected static final ConsoleAppender STDOUT;
    protected static final FileAppender LOG_FILE;
    static volatile boolean not_rolled;

    @Before
    public void printID() throws Exception {
        String beginMsg = String.format("%s######%s Running %s#%s ", Tests.yellow(), Tests.reset(), this.getClass().getSimpleName(), this.TEST_NAME.getMethodName());
        int numDots = 120 - beginMsg.length();
        System.err.printf(beginMsg + new String(new char[numDots]).replace('\u0000', '.'), new Object[0]);
        this.testDuration = System.currentTimeMillis();
    }

    public static Path getSourceRoot() {
        Path buildFsDirPath = BaseTest.searchPath(ROOT_MARKER_FILE);
        if (buildFsDirPath != null) {
            return buildFsDirPath.getParent();
        }
        return null;
    }

    public static Path searchPath(String inputName) {
        FileSystem lfs = FileSystems.getDefault();
        Path localPath = lfs.getPath(".", new String[0]).toAbsolutePath();
        Iterable<Path> dirs = lfs.getRootDirectories();
        boolean found = false;
        Path root = null;
        for (Path name : dirs) {
            if (localPath.getRoot() != name) continue;
            root = name;
            found = true;
            break;
        }
        if (!found) {
            _logger.info((Object)("Could not find root dir for current directory " + localPath));
            return null;
        }
        _logger.info((Object)("search for directory " + inputName + " from current directory " + localPath + " to root directory " + root));
        Path retPath = null;
        while (localPath != root) {
            try {
                retPath = localPath.resolve(inputName);
                if (Files.exists(retPath, new LinkOption[0])) break;
                localPath = localPath.getParent();
            }
            catch (InvalidPathException e) {
                localPath = localPath.getParent();
            }
        }
        return retPath;
    }

    protected static boolean isClusterTest() {
        return System.getProperty("tests") != null && !System.getProperty("tests").equals("simple");
    }

    protected static FileAppender createFileAppender(String pattern) {
        String logDir = System.getProperty("MAPR_TESTS_LOG_DIR", "./target/test-logs");
        String log4jLogFile = System.getProperty("MAPR_TESTS_LOG_FILE", String.format("mapr-tests.log", System.currentTimeMillis() / 1000L));
        String logFile = logDir + "/" + log4jLogFile;
        RollingFileAppender fa = new RollingFileAppender();
        fa.setName("FileLogger");
        fa.setFile(logFile);
        fa.setLayout((Layout)new PatternLayout(pattern));
        fa.setThreshold((Priority)Level.DEBUG);
        fa.setAppend(true);
        fa.setTriggeringPolicy(new TriggeringPolicy(){

            public void activateOptions() {
            }

            public synchronized boolean isTriggeringEvent(Appender arg0, LoggingEvent arg1, String arg2, long arg3) {
                if (not_rolled) {
                    not_rolled = false;
                    return true;
                }
                return not_rolled;
            }
        });
        FixedWindowRollingPolicy rollingPolicy = new FixedWindowRollingPolicy();
        rollingPolicy.setFileNamePattern(logFile.toLowerCase().endsWith(".log") ? logFile.substring(0, logFile.length() - 4) + ".%i.log" : logFile + ".%i");
        fa.setRollingPolicy((RollingPolicy)rollingPolicy);
        fa.activateOptions();
        return fa;
    }

    protected static Logger createLogger(String loggerId, Appender ... appenders) {
        Logger logger = Logger.getLogger((String)loggerId);
        logger.setAdditivity(false);
        for (Appender appender : appenders) {
            logger.addAppender(appender);
        }
        logger.setLevel(Level.DEBUG);
        return logger;
    }

    protected InputStream getResourceStream(String resourceName) {
        return this.getClass().getClassLoader().getResourceAsStream(resourceName);
    }

    static {
        String pattern = System.getProperty("MAPR_TESTS_LOG_PATTERN", "%d %-5p [%t] %c - %m%n");
        LOG_FILE = BaseTest.createFileAppender(pattern);
        STDOUT = new ConsoleAppender();
        STDOUT.setLayout((Layout)new PatternLayout(pattern));
        STDOUT.activateOptions();
        STDOUT.setThreshold((Priority)Level.ERROR);
        ROOT_LOGGER = Logger.getRootLogger();
        ROOT_LOGGER.setLevel(Level.toLevel((String)System.getProperty("MAPR_TESTS_ROOT_LOGGER_LEVEL"), (Level)Level.INFO));
        ROOT_LOGGER.addAppender((Appender)STDOUT);
        ROOT_LOGGER.addAppender((Appender)LOG_FILE);
        MAPR_LOGGER = BaseTest.createLogger("com.mapr", new Appender[]{STDOUT, LOG_FILE});
        not_rolled = true;
    }

    private class TestLogReporter
    extends TestWatcher {
        private TestLogReporter() {
        }

        protected void failed(Throwable e, Description description) {
            System.err.printf("(%s) [%sFAILED%s]\n", this.getDuration(), Tests.red(), Tests.reset());
        }

        public void succeeded(Description description) {
            System.err.printf("(%s) [%sPASSED%s]\n", this.getDuration(), Tests.green(), Tests.reset());
        }

        private String getDuration() {
            return String.format("%.3f s", (double)(System.currentTimeMillis() - BaseTest.this.testDuration) / 1000.0);
        }
    }
}

