/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.listener;

import com.mapr.fs.jni.NativeData;
import com.mapr.kafka.eventstreams.impl.listener.ListenerRecord;
import com.mapr.kafka.eventstreams.impl.listener.NativeDataParser;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class NativeDataParserV10
extends NativeDataParser {
    public NativeDataParserV10(NativeData nativeData) {
        super(nativeData);
    }

    @Override
    protected List<ListenerRecord> getListenerRecords(String topicName, TopicPartition p, long numMsgs) {
        ArrayList<ListenerRecord> recs = new ArrayList<ListenerRecord>();
        int prevProducerOff = 0;
        String prevProducer = null;
        int i = 0;
        while ((long)i < numMsgs) {
            long msgSeq = this.getLongData();
            long timestamp = this.getLongData();
            int timestampType = (int)this.getLongData();
            int keySz = (int)this.getLongData();
            int keyOff = (int)this.getLongData();
            int valSz = (int)this.getLongData();
            int valOff = (int)this.getLongData();
            int producerSz = (int)this.getLongData();
            int producerOff = (int)this.getLongData();
            int numHeaders = (int)this.getLongData();
            RecordHeaders headers = new RecordHeaders();
            for (int j = 0; j < numHeaders; ++j) {
                int hKeySz = (int)this.getLongData();
                int hKeyOff = (int)this.getLongData();
                int hValSz = (int)this.getLongData();
                int hValOff = (int)this.getLongData();
                String hKey = new String(this.nativeData.byte_data, hKeyOff, hKeySz);
                byte[] hVal = null;
                if (hValSz > 0) {
                    hVal = new byte[hValSz];
                    System.arraycopy(this.nativeData.byte_data, hValOff, hVal, 0, hValSz);
                }
                RecordHeader header = new RecordHeader(hKey, hVal);
                headers.add((Header)header);
            }
            byte[] key = null;
            byte[] value = null;
            String producer = null;
            if (keySz > 0) {
                key = new byte[keySz];
                System.arraycopy(this.nativeData.byte_data, keyOff, key, 0, keySz);
            }
            if (valSz > 0) {
                value = new byte[valSz];
                System.arraycopy(this.nativeData.byte_data, valOff, value, 0, valSz);
            }
            if (producerSz > 0) {
                if (producerOff == prevProducerOff) {
                    producer = prevProducer;
                } else {
                    producer = new String(this.nativeData.byte_data, producerOff, producerSz);
                    prevProducerOff = producerOff;
                    prevProducer = producer;
                }
            }
            recs.add(new ListenerRecord(topicName, p.partition(), msgSeq, timestamp, timestampType, key, value, (Headers)headers, producer));
            ++i;
        }
        return recs;
    }
}

