/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl;

import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.proto.Marlinserver;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamsDocument
extends DBDocumentImpl {
    static final Logger LOG = LoggerFactory.getLogger(StreamsDocument.class);
    private static final Marlinserver.MarlinInternalDefaults MDEF = Marlinserver.MarlinInternalDefaults.getDefaultInstance();
    private static Map<String, Integer> fieldIdMap;
    private static final int ID_FIELDID = 1;
    private static final int PARTITION_FIELDID = 2;
    private static final int TOPIC_FIELDID = 3;
    private static final int OFFSET_FIELDID = 4;
    private static final int PRODUCER_FIELDID = 5;
    private static final int KEY_FIELDID = 6;
    private static final int VALUE_FIELDID = 7;
    private static final FieldPath ID_PATH;
    private static final FieldPath PARTITION_PATH;
    private static final FieldPath TOPIC_PATH;
    private static final FieldPath OFFSET_PATH;
    private static final FieldPath PRODUCER_PATH;
    private static final FieldPath KEY_PATH;
    private static final FieldPath VALUE_PATH;
    private static final FieldPath DB_KEY_PATH;
    private static final FieldPath DB_VAL_PATH;
    private static final FieldPath MSG_OFFSET_DELTA;
    private int documentSize;
    private int msgsOffsetDelta;

    public static List<Integer> getProjectionIdList(List<FieldPath> ps) {
        if (ps == null) {
            return null;
        }
        ArrayList<Integer> projections = new ArrayList<Integer>();
        for (FieldPath path : ps) {
            if (path == null) {
                throw new IllegalArgumentException("NULL projection not allowed");
            }
            String str = path.asPathString();
            Integer i = fieldIdMap.get(str);
            if (i == null) {
                throw new IllegalArgumentException("Invalid field " + path);
            }
            projections.add(i);
        }
        return projections;
    }

    public StreamsDocument(String rowIdStr, int rowPartition, String rowTopic, long rowOffset, String producer, Document rowMsgDoc, int indexInRow, List<Integer> projectedPathIds) {
        Integer delta;
        LOG.debug("Topic: {} Partition: {} Offset: {}", new Object[]{rowTopic, rowPartition, rowOffset});
        this.documentSize = 0;
        this.msgsOffsetDelta = 0;
        boolean isMsgDocPresent = false;
        if (rowMsgDoc != null) {
            isMsgDocPresent = true;
        }
        Integer n = delta = isMsgDocPresent ? rowMsgDoc.getIntObj(MSG_OFFSET_DELTA) : null;
        if (delta != null) {
            this.msgsOffsetDelta = delta;
        }
        if (projectedPathIds != null && projectedPathIds.size() > 0) {
            block9: for (Integer pathId : projectedPathIds) {
                switch (pathId) {
                    case 1: {
                        String docIdStr = rowIdStr + ":" + indexInRow;
                        this.set(ID_PATH, docIdStr);
                        continue block9;
                    }
                    case 2: {
                        this.set(PARTITION_PATH, rowPartition);
                        continue block9;
                    }
                    case 3: {
                        this.set(TOPIC_PATH, rowTopic);
                        LOG.debug("set topic");
                        continue block9;
                    }
                    case 4: {
                        this.set(OFFSET_PATH, rowOffset + (long)indexInRow + (long)this.msgsOffsetDelta);
                        continue block9;
                    }
                    case 5: {
                        if (producer == null) continue block9;
                        this.set(PRODUCER_PATH, producer);
                        continue block9;
                    }
                    case 6: {
                        ByteBuffer rowKey = isMsgDocPresent ? rowMsgDoc.getBinary(DB_KEY_PATH) : null;
                        if (rowKey == null) continue block9;
                        this.documentSize += rowKey.limit();
                        this.set(KEY_PATH, rowKey);
                        continue block9;
                    }
                    case 7: {
                        ByteBuffer rowValue = isMsgDocPresent ? rowMsgDoc.getBinary(DB_VAL_PATH) : null;
                        this.set(VALUE_PATH, rowValue);
                        this.documentSize += rowValue.limit();
                        continue block9;
                    }
                }
                assert (false);
            }
        } else {
            ByteBuffer rowValue;
            ByteBuffer rowKey;
            String docIdStr = rowIdStr + ":" + indexInRow;
            this.set(ID_PATH, docIdStr);
            this.set(PARTITION_PATH, rowPartition);
            this.set(TOPIC_PATH, rowTopic);
            this.set(OFFSET_PATH, rowOffset + (long)indexInRow + (long)this.msgsOffsetDelta);
            if (producer != null) {
                this.set(PRODUCER_PATH, producer);
            }
            ByteBuffer byteBuffer = rowKey = isMsgDocPresent ? rowMsgDoc.getBinary(DB_KEY_PATH) : null;
            if (rowKey != null) {
                this.documentSize = rowKey.limit();
                this.set(KEY_PATH, rowKey);
            }
            ByteBuffer byteBuffer2 = rowValue = isMsgDocPresent ? rowMsgDoc.getBinary(DB_VAL_PATH) : null;
            if (rowValue != null) {
                this.set(VALUE_PATH, rowValue);
                this.documentSize += rowValue.limit();
            }
        }
        this.documentSize += this.documentSize / 4;
    }

    public int size() {
        return this.documentSize;
    }

    static {
        ID_PATH = FieldPath.parseFrom((String)"_id");
        PARTITION_PATH = FieldPath.parseFrom((String)"partition");
        TOPIC_PATH = FieldPath.parseFrom((String)"topic");
        OFFSET_PATH = FieldPath.parseFrom((String)"offset");
        PRODUCER_PATH = FieldPath.parseFrom((String)"producer");
        KEY_PATH = FieldPath.parseFrom((String)"key");
        VALUE_PATH = FieldPath.parseFrom((String)"value");
        DB_KEY_PATH = FieldPath.parseFrom((String)MDEF.getFMsgsKey());
        DB_VAL_PATH = FieldPath.parseFrom((String)MDEF.getFMsgsValue());
        MSG_OFFSET_DELTA = FieldPath.parseFrom((String)MDEF.getFMsgsOffsetDelta());
        fieldIdMap = new HashMap<String, Integer>();
        fieldIdMap.put("_id", 1);
        fieldIdMap.put("partition", 2);
        fieldIdMap.put("topic", 3);
        fieldIdMap.put("offset", 4);
        fieldIdMap.put("producer", 5);
        fieldIdMap.put("key", 6);
        fieldIdMap.put("value", 7);
    }
}

