/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kafka.eventstreams.impl.admin;

import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.db.exceptions.TableNotFoundException;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.License;
import com.mapr.fs.proto.Marlinserver;
import com.mapr.fs.proto.Security;
import com.mapr.kafka.eventstreams.Admin;
import com.mapr.kafka.eventstreams.TopicDescriptor;
import com.mapr.kafka.eventstreams.impl.admin.MarlinAdminImpl;
import com.mapr.kafka.eventstreams.impl.admin.TopicFeedInfo;
import com.mapr.security.UnixUserGroupHelper;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterClientQuotasOptions;
import org.apache.kafka.clients.admin.AlterClientQuotasResult;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.AlterPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.CreateDelegationTokenOptions;
import org.apache.kafka.clients.admin.CreateDelegationTokenResult;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsOptions;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeleteTopicsOptions;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.clients.admin.DescribeAclsOptions;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.clients.admin.DescribeClientQuotasOptions;
import org.apache.kafka.clients.admin.DescribeClientQuotasResult;
import org.apache.kafka.clients.admin.DescribeClusterOptions;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeDelegationTokenOptions;
import org.apache.kafka.clients.admin.DescribeDelegationTokenResult;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.ExpireDelegationTokenOptions;
import org.apache.kafka.clients.admin.ExpireDelegationTokenResult;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.ListOffsetsOptions;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsOptions;
import org.apache.kafka.clients.admin.ListPartitionReassignmentsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.RenewDelegationTokenOptions;
import org.apache.kafka.clients.admin.RenewDelegationTokenResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarlinAdminClientImpl
extends AdminClient {
    private static final Logger LOG;
    private Admin admin;
    private String defaultStreamName;

    static AdminClient createInternal(AdminClientConfig conf) {
        return new MarlinAdminClientImpl(conf);
    }

    MarlinAdminClientImpl(AdminClientConfig conf) {
        try {
            this.admin = new MarlinAdminImpl(new Configuration());
            this.defaultStreamName = conf.getString("streams.admin.default.stream");
            if (this.defaultStreamName.equals("")) {
                this.defaultStreamName = null;
            }
        }
        catch (Exception e) {
            throw new KafkaException("Failed to create MarlinAdminClient", (Throwable)e);
        }
    }

    MarlinAdminClientImpl(Admin admin, String defaultStreamName) {
        this.admin = admin;
        this.defaultStreamName = defaultStreamName;
    }

    public void close(Duration timeout) {
        this.admin.close(timeout);
    }

    public CreateTopicsResult createTopics(Collection<NewTopic> newTopics, CreateTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> createTopicResult = new HashMap<String, KafkaFutureImpl>();
        String fullTopicPath = null;
        String streamPath = null;
        String topicName = null;
        for (NewTopic n : newTopics) {
            fullTopicPath = n.name();
            String[] tokens = fullTopicPath.split(":");
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (tokens.length == 2) {
                streamPath = tokens[0];
                topicName = tokens[1];
            } else {
                if (this.defaultStreamName == null) {
                    KafkaException e = new KafkaException("No stream name specified in the topic path or in the default stream configuration options");
                    future.completeExceptionally((Throwable)e);
                    createTopicResult.put(fullTopicPath, future);
                    continue;
                }
                streamPath = this.defaultStreamName;
                topicName = fullTopicPath;
            }
            try {
                this.admin.createTopic(streamPath, topicName, n.numPartitions());
                future.complete(null);
            }
            catch (TableNotFoundException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
            }
            catch (FileAlreadyExistsException e) {
                future.completeExceptionally((Throwable)new TopicExistsException(e.getMessage()));
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)e);
            }
            createTopicResult.put(fullTopicPath, future);
        }
        return new CreateTopicsResult(createTopicResult);
    }

    public DeleteTopicsResult deleteTopics(Collection<String> topics, DeleteTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> deleteTopicsResult = new HashMap<String, KafkaFutureImpl>();
        String streamPath = null;
        String topicName = null;
        for (String fullTopicPath : topics) {
            String[] tokens = fullTopicPath.split(":");
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (tokens.length == 2) {
                streamPath = tokens[0];
                topicName = tokens[1];
            } else {
                if (this.defaultStreamName == null) {
                    KafkaException e = new KafkaException("No stream name specified in the topic path or in the default stream configuration options");
                    future.completeExceptionally((Throwable)e);
                    deleteTopicsResult.put(fullTopicPath, future);
                    continue;
                }
                streamPath = this.defaultStreamName;
                topicName = fullTopicPath;
            }
            try {
                this.admin.deleteTopic(streamPath, topicName);
                future.complete(null);
            }
            catch (TableNotFoundException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
            }
            catch (NoSuchFileException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(e.getMessage()));
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)e);
            }
            deleteTopicsResult.put(fullTopicPath, future);
        }
        return new DeleteTopicsResult(deleteTopicsResult);
    }

    public ListTopicsResult listTopics(ListTopicsOptions options) {
        if (this.defaultStreamName == null) {
            throw new KafkaException("No default stream name specified in the configuration options");
        }
        return this.listTopicsForStream(this.defaultStreamName, options);
    }

    public ListTopicsResult listTopics(String streamPath, ListTopicsOptions options) {
        return this.listTopicsForStream(streamPath, options);
    }

    private ListTopicsResult listTopicsForStream(String streamPath, ListTopicsOptions options) {
        KafkaFutureImpl topicListingFuture = new KafkaFutureImpl();
        try {
            List<String> topicNamesList = this.admin.listTopics(streamPath);
            HashMap<String, TopicListing> topicListingMap = new HashMap<String, TopicListing>();
            for (String topicName : topicNamesList) {
                topicListingMap.put(topicName, new TopicListing(topicName, false));
            }
            topicListingFuture.complete(topicListingMap);
        }
        catch (TableNotFoundException e) {
            topicListingFuture.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
        }
        catch (Exception e) {
            topicListingFuture.completeExceptionally((Throwable)e);
        }
        return new ListTopicsResult((KafkaFuture)topicListingFuture);
    }

    public DescribeTopicsResult describeTopics(Collection<String> topicNames, DescribeTopicsOptions options) {
        HashMap<String, KafkaFutureImpl> describeTopicsResult = new HashMap<String, KafkaFutureImpl>();
        String streamPath = null;
        String topicName = null;
        for (String fullTopicPath : topicNames) {
            String[] tokens = fullTopicPath.split(":");
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (tokens.length == 2) {
                streamPath = tokens[0];
                topicName = tokens[1];
            } else {
                if (this.defaultStreamName == null) {
                    KafkaException e = new KafkaException("No stream name specified in the topic path or in the default stream configuration options");
                    future.completeExceptionally((Throwable)e);
                    describeTopicsResult.put(fullTopicPath, future);
                    continue;
                }
                streamPath = this.defaultStreamName;
                topicName = fullTopicPath;
            }
            try {
                TopicDescriptor marlinTopDesc = this.admin.getTopicDescriptor(streamPath, topicName);
                ArrayList<TopicPartitionInfo> partitions = new ArrayList<TopicPartitionInfo>();
                Node leader = new Node(0, "127.0.0.1", 7200);
                ArrayList<Node> replicas = new ArrayList<Node>();
                replicas.add(leader);
                for (int p = 0; p < marlinTopDesc.getPartitions(); ++p) {
                    partitions.add(new TopicPartitionInfo(p, leader, replicas, replicas));
                }
                TopicDescription kafkaTopDesc = new TopicDescription(streamPath + ":" + topicName, false, partitions);
                future.complete((Object)kafkaTopDesc);
            }
            catch (TableNotFoundException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
            }
            catch (NoSuchFileException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(e.getMessage()));
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)e);
            }
            describeTopicsResult.put(streamPath + ":" + topicName, future);
        }
        return new DescribeTopicsResult(describeTopicsResult);
    }

    public CreatePartitionsResult createPartitions(Map<String, NewPartitions> newPartitions, CreatePartitionsOptions options) {
        HashMap<String, KafkaFutureImpl> createPartitionsResult = new HashMap<String, KafkaFutureImpl>();
        String streamPath = null;
        String topicName = null;
        for (String fullTopicPath : newPartitions.keySet()) {
            String[] tokens = fullTopicPath.split(":");
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (tokens.length == 2) {
                streamPath = tokens[0];
                topicName = tokens[1];
            } else {
                if (this.defaultStreamName == null) {
                    KafkaException e = new KafkaException("No stream name specified in the topic path or in the default stream configuration options");
                    future.completeExceptionally((Throwable)e);
                    createPartitionsResult.put(fullTopicPath, future);
                    continue;
                }
                streamPath = this.defaultStreamName;
                topicName = fullTopicPath;
            }
            NewPartitions n = newPartitions.get(fullTopicPath);
            try {
                this.admin.editTopic(streamPath, topicName, n.totalCount());
                future.complete(null);
            }
            catch (TableNotFoundException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
            }
            catch (NoSuchFileException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(e.getMessage()));
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)e);
            }
            createPartitionsResult.put(fullTopicPath, future);
        }
        return new CreatePartitionsResult(createPartitionsResult);
    }

    public DescribeReplicaLogDirsResult describeReplicaLogDirs(Collection<TopicPartitionReplica> replicas, DescribeReplicaLogDirsOptions options) {
        throw new KafkaException("describeReplicaLogDirs API not implemented");
    }

    public DescribeLogDirsResult describeLogDirs(Collection<Integer> brokers, DescribeLogDirsOptions options) {
        throw new KafkaException("describeLogDirs API not implemented");
    }

    public AlterConfigsResult alterConfigs(Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
        throw new KafkaException("alterConfigs API not implemented");
    }

    public AlterConfigsResult incrementalAlterConfigs(Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        throw new KafkaException("incrementalAlterConfigs API not implemented");
    }

    public AlterReplicaLogDirsResult alterReplicaLogDirs(Map<TopicPartitionReplica, String> replicaAssignment, AlterReplicaLogDirsOptions options) {
        throw new KafkaException("alterReplicaLogDirs API not implemented");
    }

    public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
        throw new KafkaException("describeConfigs API not implemented");
    }

    public DeleteAclsResult deleteAcls(Collection<AclBindingFilter> filters, DeleteAclsOptions options) {
        throw new KafkaException("deleteAcls API not implemented");
    }

    public CreateAclsResult createAcls(Collection<AclBinding> acls, CreateAclsOptions options) {
        throw new KafkaException("createAcls API not implemented");
    }

    public DeleteRecordsResult deleteRecords(Map<TopicPartition, RecordsToDelete> recordsToDelete, DeleteRecordsOptions options) {
        throw new KafkaException("deleteRecords API not implemented");
    }

    public DescribeAclsResult describeAcls(AclBindingFilter filter, DescribeAclsOptions options) {
        throw new KafkaException("describeAcls API not implemented");
    }

    private License.LicenseIdResponse fetchClusterID(String cluster, Security.CredentialsMsg creds) throws Exception {
        License.LicenseIdResponse resp = null;
        License.LicenseIdRequest req = License.LicenseIdRequest.newBuilder().setCreds(License.LicenseCredentialsMsg.newBuilder().setUid(creds.getUid()).addAllGids((Iterable)creds.getGidsList()).build()).build();
        byte[] data = cluster != null && !cluster.isEmpty() ? CLDBRpcCommonUtils.getInstance().sendRequest(cluster, Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetLicenseIdProc.getNumber(), (MessageLite)req, License.LicenseIdResponse.class) : CLDBRpcCommonUtils.getInstance().sendRequest(Common.MapRProgramId.CldbProgramId.getNumber(), CLDBProto.CLDBProg.GetLicenseIdProc.getNumber(), (MessageLite)req, License.LicenseIdResponse.class);
        if (data == null) {
            return null;
        }
        resp = License.LicenseIdResponse.parseFrom((byte[])data);
        return resp;
    }

    private Security.CredentialsMsg getUserCredentials() {
        UnixUserGroupHelper ui = new UnixUserGroupHelper();
        String user = ui.getLoggedinUsername();
        int uid = ui.getUserId(user);
        int[] gids = ui.getGroups(user);
        Security.CredentialsMsg.Builder msg = Security.CredentialsMsg.newBuilder().setUid(uid);
        for (int gid : gids) {
            msg.addGids(gid);
        }
        return msg.build();
    }

    public DescribeClusterResult describeCluster(DescribeClusterOptions options) {
        KafkaFutureImpl describeClusterFuture = new KafkaFutureImpl();
        KafkaFutureImpl controllerFuture = new KafkaFutureImpl();
        KafkaFutureImpl clusterIdFuture = new KafkaFutureImpl();
        String curCluster = CLDBRpcCommonUtils.getInstance().getCurrentClusterName();
        try {
            License.LicenseIdResponse licId = this.fetchClusterID(curCluster, this.getUserCredentials());
            clusterIdFuture.complete((Object)licId.getClusterid());
        }
        catch (Exception e) {
            clusterIdFuture.completeExceptionally((Throwable)e);
        }
        Node controller = new Node(0, "127.0.0.1", 7200);
        ArrayList<Node> brokers = new ArrayList<Node>();
        brokers.add(controller);
        describeClusterFuture.complete(brokers);
        controllerFuture.complete((Object)controller);
        return new DescribeClusterResult((KafkaFuture)describeClusterFuture, (KafkaFuture)controllerFuture, (KafkaFuture)clusterIdFuture, null);
    }

    public DescribeConsumerGroupsResult describeConsumerGroups(Collection<String> groupIds, DescribeConsumerGroupsOptions options) {
        throw new KafkaException("describeConsumerGroups API not implemented");
    }

    public ListConsumerGroupsResult listConsumerGroups(ListConsumerGroupsOptions options) {
        if (this.defaultStreamName == null) {
            throw new KafkaException("No default stream name specified in the configuration options");
        }
        KafkaFutureImpl all = new KafkaFutureImpl();
        try {
            all.complete(this.admin.listConsumerGroups(this.defaultStreamName));
        }
        catch (IOException e) {
            all.completeExceptionally((Throwable)e);
        }
        return new ListConsumerGroupsResult(all);
    }

    public ListConsumerGroupOffsetsResult listConsumerGroupOffsets(String groupId, ListConsumerGroupOffsetsOptions options) {
        throw new KafkaException("listConsumerGroupOffsets API not implemented");
    }

    public DeleteConsumerGroupsResult deleteConsumerGroups(Collection<String> groupIds, DeleteConsumerGroupsOptions options) {
        throw new KafkaException("deleteConsumerGroups API not implemented");
    }

    public DeleteConsumerGroupOffsetsResult deleteConsumerGroupOffsets(String groupId, Set<TopicPartition> partitions, DeleteConsumerGroupOffsetsOptions options) {
        throw new KafkaException("deleteConsumerGroupOffsets API not implemented");
    }

    public ElectLeadersResult electLeaders(ElectionType electionType, Set<TopicPartition> partitions, ElectLeadersOptions options) {
        throw new KafkaException("electLeaders API not implemented");
    }

    public AlterPartitionReassignmentsResult alterPartitionReassignments(Map<TopicPartition, Optional<NewPartitionReassignment>> reassignments, AlterPartitionReassignmentsOptions options) {
        throw new KafkaException("alterPartitionReassignments API not implemented");
    }

    public ListPartitionReassignmentsResult listPartitionReassignments(Optional<Set<TopicPartition>> partitions, ListPartitionReassignmentsOptions options) {
        throw new KafkaException("listPartitionReassignments API not implemented");
    }

    public RemoveMembersFromConsumerGroupResult removeMembersFromConsumerGroup(String groupId, RemoveMembersFromConsumerGroupOptions options) {
        throw new KafkaException("removeMembersFromConsumerGroup API not implemented");
    }

    public AlterConsumerGroupOffsetsResult alterConsumerGroupOffsets(String groupId, Map<TopicPartition, OffsetAndMetadata> offsets, AlterConsumerGroupOffsetsOptions options) {
        throw new KafkaException("alterConsumerGroupOffsets API not implemented");
    }

    public ListOffsetsResult listOffsets(Map<TopicPartition, OffsetSpec> topicPartitionOffsets, ListOffsetsOptions options) {
        HashMap<TopicPartition, KafkaFutureImpl> futures = new HashMap<TopicPartition, KafkaFutureImpl>(topicPartitionOffsets.size());
        HashMap<String, Map<String, List<TopicFeedInfo>>> streamsInfo = new HashMap<String, Map<String, List<TopicFeedInfo>>>(topicPartitionOffsets.size());
        for (TopicPartition topicPartition : topicPartitionOffsets.keySet()) {
            String fullTopicPath = topicPartition.topic();
            String streamPath = null;
            String topicName = null;
            String[] tokens = fullTopicPath.split(":");
            KafkaFutureImpl future = new KafkaFutureImpl();
            if (tokens.length == 2) {
                streamPath = tokens[0];
                topicName = tokens[1];
            } else {
                if (this.defaultStreamName == null) {
                    KafkaException e = new KafkaException("No stream name specified in the topic path or in the default stream configuration options");
                    future.completeExceptionally((Throwable)e);
                    futures.put(topicPartition, future);
                    continue;
                }
                streamPath = this.defaultStreamName;
                topicName = fullTopicPath;
            }
            try {
                Map<String, List<TopicFeedInfo>> topicsForStream;
                if (streamsInfo.containsKey(streamPath)) {
                    topicsForStream = (Map<String, List<TopicFeedInfo>>)streamsInfo.get(streamPath);
                } else {
                    topicsForStream = this.admin.listTopicsForStream(streamPath);
                    streamsInfo.put(streamPath, topicsForStream);
                }
                if (topicsForStream.containsKey(topicName)) {
                    boolean checkPartitionExist = false;
                    for (TopicFeedInfo topicFeedInfo : topicsForStream.get(topicName)) {
                        Marlinserver.TopicFeedStatInfo tinfo = topicFeedInfo.stat();
                        if (topicPartition.partition() != tinfo.getFeedId()) continue;
                        future.complete((Object)new ListOffsetsResult.ListOffsetsResultInfo(tinfo.getMaxSeq(), tinfo.getTimeRange().getMaxTS(), null));
                        checkPartitionExist = true;
                        break;
                    }
                    if (!checkPartitionExist) {
                        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Partition %d cannot be found in the topic %s", topicPartition.partition(), topicPartition.topic())));
                    }
                } else {
                    future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException(String.format("Topic %s cannot be found in the stream %s", topicName, streamPath)));
                }
            }
            catch (TableNotFoundException e) {
                future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException("Stream " + streamPath + " does not exist."));
            }
            catch (IOException e) {
                future.completeExceptionally((Throwable)e);
            }
            futures.put(topicPartition, future);
        }
        return new ListOffsetsResult(new HashMap(futures));
    }

    public DescribeClientQuotasResult describeClientQuotas(ClientQuotaFilter filter, DescribeClientQuotasOptions options) {
        throw new KafkaException("describeClientQuotas API not implemented");
    }

    public AlterClientQuotasResult alterClientQuotas(Collection<ClientQuotaAlteration> entries, AlterClientQuotasOptions options) {
        throw new KafkaException("alterClientQuotas API not implemented");
    }

    public Map<MetricName, ? extends Metric> metrics() {
        throw new KafkaException("metrics API not implemented");
    }

    public CreateDelegationTokenResult createDelegationToken(CreateDelegationTokenOptions options) {
        throw new KafkaException("createDelegationToken API not implemented");
    }

    public RenewDelegationTokenResult renewDelegationToken(byte[] hmac, RenewDelegationTokenOptions options) {
        throw new KafkaException("renewDelegationToken API not implemented");
    }

    public ExpireDelegationTokenResult expireDelegationToken(byte[] hmac, ExpireDelegationTokenOptions options) {
        throw new KafkaException("expireDelegationToken API not implemented");
    }

    public DescribeDelegationTokenResult describeDelegationToken(DescribeDelegationTokenOptions options) {
        throw new KafkaException("describeDelegationToken API not implemented");
    }

    static {
        ShimLoader.load();
        LOG = LoggerFactory.getLogger(MarlinAdminClientImpl.class);
    }
}

