/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

public class TestReadWrite
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Path testDir;
    Configuration conf;
    public static final Log LOG = LogFactory.getLog(TestReadWrite.class);

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
        this.testDir = new Path("/TestWrite");
        this.fs.mkdirs(this.testDir);
        this.data = new byte[24576];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testDummy() {
        TestReadWrite.assertTrue((boolean)true);
    }

    public void testWrite() {
        Path p = new Path("/testfile");
        try {
            FSDataOutputStream os = this.fs.create(p, null, true, 4096, (short)1, 65536L, null);
            os.write(this.data, 0, 8192);
            os.close();
        }
        catch (Exception e) {
            TestReadWrite.assertTrue((boolean)false);
        }
    }

    public void testRead() throws IOException {
        Path p = new Path("/testfile");
        FSDataOutputStream out = this.fs.create(p, true, 4096, (short)1, 65536L);
        out.write(this.data, 0, 16380);
        out.close();
        FSDataInputStream is = this.fs.open(p, 8192);
        byte[] buf = new byte[16384];
        int count = is.read(0L, buf, 0, 8192);
        System.out.println("read " + (count += is.read(8192L, buf, 8192, 8192)) + "bytes");
        is.close();
    }

    public void testReadWrite() throws IOException {
        Path path = new Path("/testfile1");
        FSDataOutputStream out = this.fs.create(path, true, 4096, (short)1, 65536L);
        out.write(this.data, 0, 8192);
        out.close();
        if (8192L != this.fs.getFileStatus(path).getLen()) {
            TestReadWrite.assertTrue((boolean)false);
        }
        FSDataInputStream in = this.fs.open(path, 4096);
        byte[] buf = new byte[8192];
        int count = in.read(buf, 0, 8192);
        System.out.println("count  = " + count);
        in.close();
        for (int i = 0; i < 8192; ++i) {
            if (this.data[i] == buf[i]) continue;
            System.out.println("i " + i + "data[] byte " + this.data[i] + "buf[] byte " + buf[i]);
            TestReadWrite.assertTrue((boolean)false);
        }
    }
}

