/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BlockLocationFileGenTest {
    static long fsize = 0x28000000L;
    static long chunksize = 0x4000000L;
    static String filePath = "/maprtbl";
    static Configuration conf;
    static FileSystem fs;
    public static final String MAPRFS_URI = "maprfs://localhost:7222/";

    public static void Usage() {
        System.err.println("usage: BlockLocationFileGen [-fsize filesize] [-csize chunksize] [-fpath /file/path]");
        System.exit(1);
    }

    public static void SetMaprFilesystemConfig() throws Exception {
        conf = new Configuration();
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        fs = FileSystem.get((URI)URI.create(conf.get("fs.default.name", MAPRFS_URI)), (Configuration)conf);
    }

    public static void WriteFile() throws Exception {
        byte[] data = new byte[0x4000000];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10);
        }
        Path f = new Path(filePath);
        FSDataOutputStream out = fs.create(f, false, 8192, (short)1, chunksize);
        out.write(data, 0, 65536);
        out.hsync();
        long outSize = 65536L;
        long i = 0L;
        while (outSize < fsize) {
            System.out.println("Block " + i);
            out.writeChar(60);
            out.hsync();
            FileStatus fstatus = fs.getFileStatus(f);
            BlockLocation[] bloc = fs.getFileBlockLocations(fstatus, i * chunksize, outSize += 2L);
            if (bloc == null) {
                System.out.println("null ********");
                System.exit(-1);
            } else {
                for (int j = 0; j < bloc.length; ++j) {
                    String[] hostnames = bloc[j].getHosts();
                    for (int k = 0; k < hostnames.length; ++k) {
                        String s = hostnames[k] + ";";
                        out.writeChars(s);
                        outSize += 2L * (long)s.length();
                    }
                }
                out.writeChar(62);
                outSize += 2L;
                out.hsync();
            }
            int blength = new Long((i + 1L) * chunksize - outSize).intValue();
            out.write(data, 0, blength);
            outSize += (long)blength;
            out.hsync();
            ++i;
        }
        out.close();
    }

    public static void ParseArgs(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-fsize")) {
                fsize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-csize")) {
                chunksize = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-fpath")) {
                filePath = args[++i];
                continue;
            }
            BlockLocationFileGenTest.Usage();
        }
        System.out.println("fsize = " + fsize + "\nchunksize = " + chunksize + "\nfilePath = " + filePath + "\n");
    }

    public static void main(String[] args) throws Exception {
        BlockLocationFileGenTest.ParseArgs(args);
        BlockLocationFileGenTest.SetMaprFilesystemConfig();
        BlockLocationFileGenTest.WriteFile();
        System.out.println("BlockLocationFileGenTest completed.");
    }
}

