/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.utils.ssh;

import com.mapr.fs.utils.ssh.SSHSession;
import com.mapr.fs.utils.ssh.SSHSessionManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public abstract class NodeTask<T>
implements Callable<T> {
    private static final int SSH_SUCCESS = 0;
    private static final int SSH_ERROR = 1;
    private static final int SSH_FATAL_ERROR = 2;
    private final String host;
    private final String user;

    protected NodeTask(String host) {
        this(null, host);
    }

    protected NodeTask(String user, String host) {
        this.user = user;
        this.host = host;
    }

    @Override
    public T call() throws Exception {
        SSHSessionManager mgr = this.user == null ? SSHSessionManager.getDefaultSessionManager() : SSHSessionManager.getSessionManager(this.user);
        SSHSession session = mgr.getSession(this.host);
        Thread.currentThread().setName(session.getUserName() + "@" + session.getHost());
        return this.run(session);
    }

    protected void ack(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    protected int checkAck(InputStream in) throws IOException {
        int b = in.read();
        switch (b) {
            case 1: 
            case 2: {
                int c;
                StringBuilder sb = new StringBuilder();
                sb.append("Error: " + b + ". ");
                while ((c = in.read()) != 10) {
                    sb.append((char)c);
                }
                throw new IOException(sb.toString());
            }
        }
        return b;
    }

    protected abstract T run(SSHSession var1) throws Exception;

    public String getHost() {
        return this.host;
    }
}

