/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RWSpeedTest {
    public static final String MAPRFS_URI = "maprfs:///";

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length > 4) {
            System.err.println("usage: RWSpeedTest filename [-]megabytes uri [writeBufferSize]");
            System.exit(1);
        }
        int ac = 0;
        String filename = args[ac++];
        int numMeg = Integer.parseInt(args[ac++]);
        String uri = args[ac++];
        Configuration conf = new Configuration();
        int writeBufferSize = args.length == 4 ? Integer.parseInt(args[ac++]) : 65536;
        System.out.println("writeBufferSize: " + writeBufferSize + " byte");
        conf.set("fs.default.name", uri);
        if (uri.equals(MAPRFS_URI)) {
            conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        }
        if (uri.contains("hdfs")) {
            conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
        }
        boolean writing = true;
        if (numMeg < 0) {
            writing = false;
            numMeg = -numMeg;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        Path p = new Path(filename);
        if (writing) {
            byte[] b = new byte[writeBufferSize];
            long lenToWrite = numMeg;
            lenToWrite *= 0x100000L;
            FSDataOutputStream out = fs.create(p);
            long sT = System.currentTimeMillis();
            for (long i = 0L; i < lenToWrite; i += (long)b.length) {
                out.write(b, 0, b.length);
                out.flush();
            }
            out.close();
            long eT = System.currentTimeMillis();
            double rate = lenToWrite;
            rate /= (double)(eT -= sT);
            System.out.println("Write rate: " + (rate /= 1000.0) + " M/s");
        } else {
            int lenread;
            byte[] b = new byte[65591];
            long lenToRead = numMeg;
            lenToRead *= 0x100000L;
            FSDataInputStream in = fs.open(p);
            long sT = System.currentTimeMillis();
            for (long i = 0L; i < lenToRead && (lenread = in.read(b, 0, b.length)) >= b.length; i += (long)b.length) {
            }
            in.close();
            long eT = System.currentTimeMillis();
            double rate = lenToRead;
            rate /= (double)(eT -= sT);
            System.out.println("Read rate: " + (rate /= 1000.0) + " M/s");
        }
    }
}

