/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import java.net.URI;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class BulkWriteTest {
    static String rootDir;
    static Path baseDir;
    static FileSystem fs;
    static byte[] dataBuf;
    static final long fileSize = 0x6400000L;

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("usage: BulkWriteTest rootDir numFiles writeSize");
            return;
        }
        rootDir = args[0];
        int numThreads = Integer.parseInt(args[1]);
        int writeSize = Integer.parseInt(args[2]);
        String uri = "maprfs:///";
        Configuration conf = new Configuration();
        conf.set("fs.default.name", uri);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        baseDir = new Path(rootDir);
        dataBuf = new byte[2 * writeSize];
        int j = 64;
        for (int i = 0; i < dataBuf.length; ++i) {
            BulkWriteTest.dataBuf[i] = j;
            if ((j = (int)((byte)(j + 1))) != 135) continue;
            j = 64;
        }
        long startTime = System.currentTimeMillis();
        SmallWriteThread[] tid = new SmallWriteThread[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            tid[i] = new SmallWriteThread(i);
            tid[i].start();
        }
        long numChunks = 0L;
        for (int i = 0; i < numThreads; ++i) {
            tid[i].join();
        }
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        long totalMB = 100 * numThreads;
        System.out.println("Wrote " + totalMB + "MB in " + elapsedTime + "ms");
        double tput = totalMB * 1000L / elapsedTime;
        System.out.println("Throughput (MBps) = " + tput);
    }

    static class SmallWriteThread
    extends Thread {
        int myId;
        Path myFile;
        Random r;

        SmallWriteThread(int id) {
            this.myId = id;
            this.myFile = new Path(baseDir, "file-" + this.myId);
            this.r = new Random(id);
        }

        void DoSmallWrites() throws Exception {
            FSDataOutputStream os = fs.create(this.myFile);
            int writeSize = this.r.nextInt(dataBuf.length) + 1;
            for (long sz = 0L; sz < 0x6400000L; sz += (long)writeSize) {
                os.write(dataBuf, 0, writeSize);
                os.hsync();
            }
            os.close();
            fs.delete(this.myFile, false);
        }

        @Override
        public void run() {
            try {
                this.DoSmallWrites();
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return;
            }
        }
    }
}

