/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.TestReadWrite;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;

public class BasicReadTest {
    public static final Log LOG = LogFactory.getLog(TestReadWrite.class);

    public static void main(String[] args) throws Exception {
        BasicReadTest.fsops();
    }

    public static void fsops() throws Exception {
        int len = 8192;
        byte[] data = new byte[8192];
        MapRFileSystem fs = new MapRFileSystem();
        Configuration conf = new Configuration();
        try {
            URI uri = new URI("maprfs://10.10.10.21:7222");
            fs.initialize(uri, conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
        Path path = new Path("/jni-test-file");
        FSDataOutputStream out = fs.create(path, true, 4096, (short)1, 65536L);
        out.write(data, 0, 8192);
        out.close();
        if (8192L != fs.getFileStatus(path).getLen()) {
            throw new IllegalStateException("Invalid file length.");
        }
        FSDataInputStream in = fs.open(path, 4096);
        byte[] buf = new byte[8192];
        int count = in.read(buf, 0, 8192);
        System.out.println("count  = " + count);
        in.close();
        for (int i = 0; i < 8192; ++i) {
            if (data[i] == buf[i]) continue;
            throw new IllegalStateException("Invalid file length.");
        }
        fs.delete(path);
        fs.close();
    }

    static {
        System.out.println("Loaded Basic Read Test in " + BasicReadTest.class.getClassLoader());
    }
}

