/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class TestVolMount
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Configuration conf;
    String mountPath = "/a/b/c/d";
    public static final Log LOG = LogFactory.getLog(TestVolMount.class);

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testVolMountAndUnmount() throws IOException {
        Path dir = new Path("/a/b/c");
        this.fs.mkdirs(dir);
        int ret = this.fs.mountVolume(null, "test.vol", this.mountPath, null);
        TestVolMount.assertTrue((ret == 0 ? 1 : 0) != 0);
        ret = this.fs.unmountVolume(null, "test.vol", this.mountPath, null, 0, 0, 0);
        TestVolMount.assertTrue((ret == 0 ? 1 : 0) != 0);
    }

    public void testVolMountInvalidName() {
        String relativePath = "x/y";
        int ret = this.fs.mountVolume(null, "test.vol", relativePath, null);
        TestVolMount.assertTrue((ret != 0 ? 1 : 0) != 0);
    }
}

