/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.conf;

import com.google.common.base.Preconditions;
import com.mapr.fs.FSTests;
import com.mapr.fs.beans.QueryServiceParam;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestQueryServiceParam
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestQueryServiceParam.class);
    private static final int[] GREP_SUCCESS_CODES = new int[]{0, 1};
    private static String clusterZkConnect = null;
    private static String clusterId;
    private static String storagePlugin;
    private static String znode;
    private static Boolean enabled;

    @BeforeClass
    public static void setupTestQueryServiceParam() throws Exception {
        RunCommand rc = TestCluster.runCommand("grep '^[^#]*cldb.zookeeper.servers' /opt/mapr/conf/cldb.conf", GREP_SUCCESS_CODES);
        Assert.assertEquals((long)0L, (long)rc.getExitCode());
        String zk_line = rc.getStdOut();
        Assert.assertNotNull((Object)zk_line);
        _logger.debug("Zookeeper connection property from cldb.conf: '{}'", (Object)zk_line);
        String[] parts = zk_line.split("=");
        Assert.assertEquals((long)2L, (long)parts.length);
        clusterZkConnect = parts[1].trim();
        String enabledStr = TestQueryServiceParam.getNodeValue("/queryservice/enabled");
        enabled = Boolean.valueOf(enabledStr);
        if (enabledStr != null) {
            clusterId = TestQueryServiceParam.getNodeValue("/queryservice/connection/clusterid");
            storagePlugin = TestQueryServiceParam.getNodeValue("/queryservice/connection/storageplugin");
            znode = TestQueryServiceParam.getNodeValue("/queryservice/connection/znode");
        }
    }

    private static String getNodeValue(String nodeKey) throws Exception {
        Preconditions.checkState((clusterZkConnect != null ? 1 : 0) != 0);
        String cmd = "/opt/mapr/zookeeper/zookeeper-3*/bin/zkCli.sh -server " + clusterZkConnect + " get " + nodeKey + " | tail -n 1";
        RunCommand rc = TestCluster.runCommand(cmd);
        Assert.assertEquals((long)0L, (long)rc.getExitCode());
        String err = rc.getStdErr().toLowerCase();
        return err.contains("node does not exist") ? null : rc.getStdOut().replaceAll("\\s+", "");
    }

    @Test
    public void testQueryServiceParam() throws IOException, InterruptedException {
        QueryServiceParam qsParam = FSTests.maprfs().getQueryServiceParam();
        _logger.debug("QueryServiceParam: {}", (Object)qsParam);
        Assert.assertEquals((Object)enabled, (Object)qsParam.isEnabled());
        Assert.assertEquals((Object)clusterZkConnect, (Object)qsParam.getZookeeperConnect());
        if (enabled.booleanValue()) {
            Map qsConnect = qsParam.getConnectionParams();
            Assert.assertEquals((Object)clusterId, qsConnect.get("clusterid"));
            Assert.assertEquals((Object)storagePlugin, qsConnect.get("storageplugin"));
            Assert.assertEquals((Object)znode, qsConnect.get("znode"));
        }
    }
}

