/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.hadoop.yarn.configuration;

import com.mapr.hadoop.yarn.configuration.YarnSiteMyriadXmlBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class TemplateEscapingTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void templateEscapingTest() throws Exception {
        boolean isHAEnabled = false;
        String newYarnSiteXml = new YarnSiteMyriadXmlBuilder("myriadeng.marathon.mesos", "yarn-site.xml", isHAEnabled).build();
        Assert.assertTrue((boolean)newYarnSiteXml.contains("${myriad.yarn.nodemanager.webapp.address}"));
        Assert.assertFalse((boolean)newYarnSiteXml.contains("\\$\\{myriad.yarn.nodemanager.webapp.address\\}"));
        InputStream haTemplateStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("yarn-site-test.xml");
        if (haTemplateStream == null) {
            Assert.fail((String)"Can not find test resource file: yarn-site-test.xml");
        }
        File tempFile = File.createTempFile("test-yarn-xml", null);
        tempFile.deleteOnExit();
        FileOutputStream ostr = new FileOutputStream(tempFile);
        try {
            int readBytes;
            byte[] buf = new byte[1024];
            while ((readBytes = haTemplateStream.read(buf, 0, buf.length)) > 0) {
                ((OutputStream)ostr).write(buf, 0, readBytes);
            }
        }
        finally {
            ((OutputStream)ostr).close();
            haTemplateStream.close();
        }
        newYarnSiteXml = new YarnSiteMyriadXmlBuilder("myriadeng.marathon.mesos", tempFile.getAbsolutePath(), isHAEnabled).build();
        Assert.assertTrue((boolean)newYarnSiteXml.contains("${myriad.yarn.nodemanager.webapp.address}"));
        Assert.assertFalse((boolean)newYarnSiteXml.contains("\\$\\{myriad.yarn.nodemanager.webapp.address\\}"));
        Assert.assertTrue((boolean)newYarnSiteXml.contains("<property>\n    <name>my.property</name>\n    <value>my.property.value</value>\n  </property>"));
    }
}

