/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.BackgroundWork;
import com.mapr.fs.ClusterConf;
import com.mapr.fs.Inode;
import com.mapr.fs.MapRBlockLocation;
import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFsDataInputStream;
import com.mapr.fs.MapRFsDataOutputStream;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRConstants;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FidInfo;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Progressable;

public class MapRFileSystem
extends FileSystem
implements MapRConstants {
    private static final Log LOG = LogFactory.getLog(MapRFileSystem.class);
    private static final Pattern FID_PATTERN = Pattern.compile("[0-9]+.[0-9]+.[0-9]+");
    private static final Pattern FID_SPLITTER = Pattern.compile("\\.");
    private static ClusterConf clusterConf = new ClusterConf();
    private static Map<String, Object> mapClntTable = new HashMap<String, Object>();
    private static Integer numInstances = 0;
    private static Boolean initialized = false;
    private static boolean disableNameCache_ = false;
    private static URI uri;
    private static String clusterName;
    private static String userName;
    private Path workingDir;
    private long chunkSize;
    private boolean chunkSizePresentInConf_;
    public static final String[] emptyStringArray;

    public MapRFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileSystem(String cName, String[] cldbLocations) throws IOException {
        Map<String, Object> map = mapClntTable;
        synchronized (map) {
            if (!mapClntTable.containsKey(cName)) {
                clusterConf.updateClusterEntry(cName, cldbLocations);
                clusterName = cName;
            }
        }
    }

    static Path adjustWorkingDir(String workingDirStr) {
        if (workingDirStr != null && !workingDirStr.isEmpty()) {
            workingDirStr = userName != null ? workingDirStr.replaceAll("\\$USERNAME", userName) : "/";
            if (!workingDirStr.endsWith("/")) {
                workingDirStr = workingDirStr + "/";
            }
        } else {
            workingDirStr = userName != null ? "/user/" + userName + "/" : "/";
        }
        return new Path(workingDirStr);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.initConfig(name, conf);
        this.setConf(conf);
        this.workingDir = MapRFileSystem.adjustWorkingDir(conf.get("fs.mapr.working.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfig(URI name, Configuration conf) throws IOException {
        Comparable<Boolean> comparable;
        this.chunkSize = conf.getLong("fs.mapr.block.size", -1L);
        boolean bl = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
        if (!this.chunkSizePresentInConf_) {
            this.chunkSize = conf.getLong("dfs.block.size", -1L);
            boolean bl2 = this.chunkSizePresentInConf_ = this.chunkSize >= 0L;
            if (!this.chunkSizePresentInConf_) {
                this.chunkSize = 0x10000000L;
            }
        }
        if (this.chunkSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        if (!initialized.booleanValue()) {
            comparable = initialized;
            synchronized (comparable) {
                if (!initialized.booleanValue()) {
                    block27: {
                        int memPoolSize;
                        disableNameCache_ = conf.getBoolean("fs.mapr.disable.namecache", false);
                        boolean aggregateWrites = conf.getBoolean("fs.mapr.aggregate.writes", true);
                        int numWriters = conf.getInt("fs.mapr.threads", aggregateWrites ? 8 : 64);
                        if (numWriters <= 0) {
                            int n = numWriters = aggregateWrites ? 8 : 64;
                        }
                        if ((memPoolSize = conf.getInt("fs.mapr.shmpool.size", 2560)) < 0) {
                            memPoolSize = 2560;
                        }
                        String allTrace = conf.get("fs.mapr.trace");
                        boolean disableLocalIO = conf.getBoolean("fs.mapr.io.remoteonly", false);
                        int rpcTimeout = conf.getInt("fs.mapr.rpc.timeout", 0);
                        String spoofedUser = conf.get("hadoop.spoofed.user.username", "root");
                        int spoofedUid = conf.getInt("hadoop.spoofed.user.uid", 0);
                        if (spoofedUid < 0) {
                            spoofedUid = 0;
                        }
                        String spoofedGroup = conf.get("hadoop.spoofed.user.groupname", "root");
                        int spoofedGid = conf.getInt("hadoop.spoofed.user.gid", 0);
                        if (spoofedUid < 0) {
                            spoofedGid = 0;
                        }
                        if (MapRClient.initSpoofedUser((String)spoofedUser, (int)spoofedUid, (String)spoofedGroup, (int)spoofedGid) != 0) {
                            throw new IOException("Failed to initialize spoofed user");
                        }
                        MapRConstants.JniUsername jniusername = new MapRConstants.JniUsername();
                        if (MapRClient.init((int)memPoolSize, (String)allTrace, (boolean)disableLocalIO, (boolean)aggregateWrites, (int)numWriters, (MapRConstants.JniUsername)jniusername, (int)rpcTimeout) != 0) {
                            throw new IOException("Failed to initialize config");
                        }
                        if (jniusername.username != null && !jniusername.username.isEmpty()) {
                            userName = jniusername.username;
                        }
                        Inode.allocWriteBuffers(memPoolSize);
                        MapRClientImpl.setReadBuffering(conf.getBoolean("fs.mapr.readbuffering", true));
                        try {
                            ClusterConf.ClusterEntry centry = clusterConf.getClusterByUri(name);
                            clusterName = centry.getClusterName();
                            if (name.getHost() != null) {
                                uri = name;
                                break block27;
                            }
                            try {
                                uri = new URI(name.getScheme(), "", name.getPath(), null, null);
                            }
                            catch (URISyntaxException uriException) {
                                throw new IOException("Could not build URI");
                            }
                        }
                        catch (IOException e) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)"Could not find any cluster, defaulting to localhost");
                            }
                            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByAddr("127.0.0.1", 7222);
                            clusterName = centry.getClusterName();
                            String authority = "127.0.0.1:7222";
                            try {
                                uri = new URI("maprfs", authority, "/", null, null);
                            }
                            catch (URISyntaxException uriException) {
                                throw new IOException("Could not build URI");
                            }
                        }
                    }
                    initialized = true;
                }
            }
        }
        comparable = numInstances;
        synchronized (comparable) {
            if (numInstances == 0) {
                BackgroundWork.init();
            }
            Integer n = numInstances;
            Integer n2 = numInstances = Integer.valueOf(numInstances + 1);
        }
    }

    private void initError(MapRConstants.ErrorValue err) {
        err.error = 0;
        err.trailpath = null;
    }

    private Object lookupClient(ClusterConf.ClusterEntry centry) throws IOException {
        String cluster = centry.getClusterName();
        Map<String, Object> map = mapClntTable;
        synchronized (map) {
            if (mapClntTable.containsKey(cluster)) {
                return mapClntTable.get(cluster);
            }
            try {
                MapRClientImpl client = new MapRClientImpl(cluster, centry.getIPs(), "", this.statistics, disableNameCache_);
                mapClntTable.put(cluster, (Object)client);
                return client;
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }

    private Object lookupClient(Path p) throws IOException {
        ClusterConf.ClusterEntry centry = clusterConf.getClusterByPath(this.makeAbsolute(p).toUri(), uri, clusterName);
        if (centry == null) {
            throw new IOException("Could not resolve path: " + p.toString());
        }
        return this.lookupClient(centry);
    }

    public FSDataOutputStream create(Path f, int mask, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        MapRFsOutStream os;
        MapRClientImpl client;
        if (blockSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int mode = MapRClientImpl.getModeBits(permission, this.getConf());
        int clusterCount = 0;
        do {
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                throw new IOException("Bad URI - no such cluster");
            }
            this.initError(err);
            os = client.create(this.getName(f), mask, mode, overwrite, replication, blockSize, progress, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (os != null) {
            return new MapRFsDataOutputStream(os, client.getStatistics());
        }
        return null;
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, 128, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), overwrite, 0, this.getDefaultReplication(), this.chunkSize, null);
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, 0, this.getDefaultReplication(), this.chunkSize, progress);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, 0, replication, this.chunkSize, null);
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), true, 0, replication, this.chunkSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, null);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.create(f, this.shouldUseDefaultBlockSize(), FsPermission.getDefault(), overwrite, bufferSize, this.getDefaultReplication(), this.chunkSize, progress);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        MapRFsInStream is;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                return null;
            }
            this.initError(err);
            is = client.open(this.getName(f), err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (is != null) {
            return new MapRFsDataInputStream(is);
        }
        return null;
    }

    public URI getUri() {
        return uri;
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        MapRFsOutStream os;
        MapRClientImpl client;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                return null;
            }
            this.initError(err);
            os = client.append(this.getName(f), err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (os != null) {
            return new MapRFsDataOutputStream(os, client.getStatistics());
        }
        return null;
    }

    public boolean rename(Path src, Path dst) throws IOException {
        int ret;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(src))) == null) {
                return false;
            }
            this.initError(err);
            ret = client.rename(this.getName(src), this.getName(dst), err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            src = new Path(err.trailpath);
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (ret == 18) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Cannot rename across volumes, falling back on copy/delete semantics");
            }
            return FileUtil.copy((FileSystem)this, (Path)src, (FileSystem)this, (Path)dst, (boolean)true, (Configuration)this.getConf());
        }
        if (ret == 2) {
            throw new IOException("Invalid source or target");
        }
        if (ret != 0) {
            throw new IOException("Error: " + Errno.toString((int)(ret < 0 ? -ret : ret)));
        }
        return true;
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            FileStatus fStatus;
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                return false;
            }
            this.initError(err);
            error = client.delete(this.getName(f), recursive, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (error == 136) {
                f = new Path(err.trailpath);
                continue;
            }
            if (error == 0 || recursive || !(fStatus = this.getMapRFileStatus(f)).isDir()) continue;
            throw new IOException("Could not delete dir " + f + ", Error: " + Errno.toString((int)err.error) + ", Try with recursive flag set to true");
        } while (error == 136);
        return error == 0;
    }

    public boolean delete(Path f) throws IOException {
        return this.delete(f, true);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.workingDir = MapRFileSystem.adjustWorkingDir(this.makeAbsolute(new_dir).toString());
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.chunkSize;
    }

    int shouldUseDefaultBlockSize() {
        return this.chunkSizePresentInConf_ ? 128 : 0;
    }

    public short getDefaultReplication() {
        return 3;
    }

    String makeDir(Path p, int mask, int mode, boolean z, long chunkSize, boolean needFid) throws IOException {
        int error;
        if (chunkSize % 65536L != 0L) {
            throw new IOException("chunksize should be a multiple of 64K");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(p))) == null) {
                throw new IOException("Bad URI: no such cluster, path: " + p);
            }
            this.initError(err);
            error = client.mkdirs(this.getName(p), mask, mode, z, chunkSize, err, needFid);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (error != 136) continue;
            p = new Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            if (error < 0) {
                error = -error;
            }
            throw new IOException("Error: " + Errno.toString((int)error) + "(" + error + ")" + ", file: " + p.getName());
        }
        return needFid ? err.fid : null;
    }

    public boolean mkdirs(Path p, FsPermission permission) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(permission, this.getConf()), true, this.chunkSize, false);
        return true;
    }

    public boolean mkdirs(Path p, FsPermission permission, boolean compress) throws IOException {
        this.makeDir(p, this.shouldUseDefaultBlockSize() | 0x40, MapRClientImpl.getModeBits(permission, this.getConf()), compress, this.chunkSize, false);
        return true;
    }

    public boolean mkdirs(Path f, FsPermission permission, long chunkSize) throws IOException {
        this.makeDir(f, 128, MapRClientImpl.getModeBits(permission, this.getConf()), true, chunkSize, false);
        return true;
    }

    public boolean mkdirs(Path f, FsPermission permission, boolean compress, long chunkSize) throws IOException {
        this.makeDir(f, 192, MapRClientImpl.getModeBits(permission, this.getConf()), compress, chunkSize, false);
        return true;
    }

    private static MapRFileStatus adjustFileStatus(MapRFileStatus fstatus, boolean needAuthority, String authority) {
        if (needAuthority) {
            Path p = new Path("maprfs", authority, fstatus.getPath().toString());
            fstatus.setPath(p);
        }
        return fstatus;
    }

    public FileStatus getMapRFileStatus(Path f) throws IOException {
        MapRFileStatus fstatus;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        boolean needAuthority = authority != null && !authority.isEmpty();
        String rawPath = u.getPath();
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            return MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr", System.currentTimeMillis()), needAuthority, authority);
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                return null;
            }
            this.initError(err);
            fstatus = client.getFileStatus(this.getNameStr(rawPath), needSlashMapr, authority, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            rawPath = this.makeAbsolute(f).toUri().getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (fstatus == null) {
            throw new FileNotFoundException("Requested file " + f + " does not exist" + (f.isAbsolute() ? "." : " (Absolute path: " + rawPath + ")."));
        }
        return fstatus;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.getMapRFileStatus(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRFileStatus[] listMapRStatus(Path f, boolean showVols, boolean showHidden) throws IOException {
        MapRFileStatus status;
        String name;
        MapRClientImpl client;
        URI u = this.makeAbsolute(f).toUri();
        String authority = u.getAuthority();
        boolean needAuthority = authority != null && !authority.isEmpty();
        String rawPath = u.getPath();
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            List<ClusterConf.ClusterEntry> clusterList = clusterConf.getClusterList();
            if (clusterList.isEmpty()) {
                return null;
            }
            MapRFileStatus[] result = new MapRFileStatus[clusterList.size()];
            List<ClusterConf.ClusterEntry> list = clusterList;
            synchronized (list) {
                int i = 0;
                long time = System.currentTimeMillis();
                for (ClusterConf.ClusterEntry centry : clusterList) {
                    result[i] = MapRFileSystem.adjustFileStatus(new MapRFileStatus("/mapr/" + centry.getClusterName(), time), needAuthority, authority);
                    ++i;
                }
            }
            return result;
        }
        boolean needSlashMapr = rawPath.startsWith("/mapr/");
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        int clusterCount = 0;
        do {
            if ((client = (MapRClientImpl)((Object)this.lookupClient(f))) == null) {
                return null;
            }
            this.initError(err);
            name = this.getNameStr(rawPath);
            status = client.getFileStatus(name, needSlashMapr, authority, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            f = new Path(err.trailpath);
            rawPath = this.makeAbsolute(f).toUri().getPath();
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        if (status == null) {
            return null;
        }
        if (status.isDir()) {
            MapRFileStatus[] result = client.listStatus(name, showVols, needSlashMapr, showHidden, authority, err);
            if (result == null) {
                if (err.error < 0) {
                    err.error = -err.error;
                }
                if (err.error == 13 || err.error == 1) {
                    throw new IOException("Failed to list contents of dir " + f + ", err: " + Errno.toString((int)err.error) + "(" + err.error + ")");
                }
            }
            return result;
        }
        return new MapRFileStatus[]{status};
    }

    public MapRFileStatus[] listStatus(Path f) throws IOException {
        return this.listMapRStatus(f, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Integer n = numInstances;
        synchronized (n) {
            Integer n2 = numInstances;
            Integer n3 = numInstances = Integer.valueOf(numInstances - 1);
            if (numInstances == 0) {
                BackgroundWork.close();
            }
        }
        super.close();
    }

    public int createSymlink(String target, Path link, boolean createParent) throws IOException {
        String scheme;
        URI u = this.makeAbsolute(new Path(target)).toUri();
        if (u != null && (scheme = u.getScheme()) != null && !scheme.equalsIgnoreCase("maprfs")) {
            throw new IOException("Cannot create symlinks to non-maprfs filesystems");
        }
        MapRConstants.ErrorValue linkErr = new MapRConstants.ErrorValue();
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(link))) == null) {
                return -1;
            }
            client.createSymlink(target, this.getName(link).toString(), linkErr);
            if (linkErr.error < 0) {
                linkErr.error = -linkErr.error;
            }
            if (linkErr.error != 136) continue;
            link = new Path(linkErr.trailpath);
        } while (linkErr.error == 136);
        return linkErr.error;
    }

    public int createVolLink(String cluster, String volName, Path volLink, boolean writeable, boolean isHidden) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
        if (client == null) {
            return -1;
        }
        return client.createVolLink(volName, this.getName(volLink).toString(), writeable, isHidden);
    }

    public int deleteVolLink(String cluster, String volLink) throws IOException {
        ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
        if (client == null) {
            return -1;
        }
        return client.deleteVolLink(volLink);
    }

    public Path getHomeDirectory() {
        return this.workingDir;
    }

    public Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public String getNameStr(String str) {
        if (str.startsWith("/mapr/")) {
            String[] strArr = str.split("/", 4);
            if (strArr.length <= 3) {
                return "/";
            }
            return "/" + strArr[3];
        }
        return str;
    }

    public String getName(Path p) {
        return this.getNameStr(this.makeAbsolute(p).toUri().getPath());
    }

    public MapRBlockLocation[] getMapRFileBlockLocations(FileStatus file, long start, long len, boolean usePrimaryFid, boolean needDiskBlocks) throws IOException {
        MapRBlockLocation[] result;
        if (file == null) {
            return null;
        }
        String path = this.getName(file.getPath());
        if (path == null) {
            return new MapRBlockLocation[0];
        }
        if (start < 0L) {
            throw new IOException("Negative offset is not supported.");
        }
        if (len < 0L) {
            throw new IOException("Negative length is not supported.");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        Path p = file.getPath();
        int clusterCount = 0;
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(p))) == null) {
                return new MapRBlockLocation[0];
            }
            this.initError(err);
            result = client.getBlockLocations(path, start, len, usePrimaryFid, needDiskBlocks, err);
            if (err.error < 0) {
                err.error = -err.error;
            }
            if (err.error != 136) continue;
            path = err.trailpath;
            ++clusterCount;
        } while (err.error == 136 && clusterCount < 8);
        return result == null ? new MapRBlockLocation[]{} : result;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.getMapRFileBlockLocations(file, start, len, false, false);
    }

    public void setOwner(Path p, String user, String group) throws IOException {
        int error;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setOwner: Path = " + p + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new IOException("Invalid user/group arguments " + user + "/" + group + " for path " + p);
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(p))) == null) {
                return;
            }
            this.initError(err);
            error = client.setOwner(this.getName(p), user, group, err);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            p = new Path(err.trailpath);
        } while (error == 136);
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for path " + p);
        }
    }

    public void setOwnerFid(String pfid, String user, String group) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setOwner: pfid = " + pfid + " User = " + user + " Group = " + group));
        }
        if (user == null && group == null) {
            throw new IOException("Invalid user/group arguments " + user + "/" + group + " for path " + pfid);
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        this.initError(err);
        int error = client.setOwnerFid(pfid, user, group, err);
        if (error < 0) {
            error = -error;
        }
        if (error != 0) {
            throw new IOException("Could not set owner/group " + user + "/" + group + " for fid " + pfid);
        }
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        if (mtime != -1L || atime != -1L) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                MapRClientImpl client;
                if ((client = (MapRClientImpl)((Object)this.lookupClient(p))) == null) {
                    return;
                }
                this.initError(err);
                error = client.setTimes(this.getName(p), mtime, atime, err);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set mtime/atime for " + p);
            }
        }
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        if (permission != null) {
            int error;
            MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
            do {
                MapRClientImpl client;
                if ((client = (MapRClientImpl)((Object)this.lookupClient(p))) == null) {
                    return;
                }
                this.initError(err);
                error = client.setPermission(this.getName(p), permission.toShort(), err);
                if (error < 0) {
                    error = -error;
                }
                if (error != 136) continue;
                p = new Path(err.trailpath);
            } while (error == 136);
            if (error != 0) {
                throw new IOException("Could not set permission for " + p);
            }
        }
    }

    public FsStatus getStatus() throws IOException {
        return this.getStatus(null);
    }

    public FsStatus getStatus(Path p) throws IOException {
        MapRClientImpl client = p == null ? (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName))) : (MapRClientImpl)((Object)this.lookupClient(p));
        if (client == null) {
            return null;
        }
        return client.getStatus();
    }

    public int setCompression(Path path, boolean val, String compName) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(path))) == null) {
                return -1;
            }
            this.initError(err);
            error = client.setCompression(this.getName(path).toString(), val, compName, err);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new Path(err.trailpath);
        } while (error == 136);
        return error;
    }

    public int setChunkSize(Path path, long val) throws IOException {
        int error;
        MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
        do {
            MapRClientImpl client;
            if ((client = (MapRClientImpl)((Object)this.lookupClient(path))) == null) {
                return -1;
            }
            this.initError(err);
            error = client.setChunkSize(this.getName(path).toString(), val, err);
            if (error < 0) {
                error = -error;
            }
            if (error != 136) continue;
            path = new Path(err.trailpath);
        } while (error == 136);
        return error;
    }

    public int mountVolume(String cluster, String volName, String mountPath, String username) {
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("mountVolume: mount path " + mountPath + " is not absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            return client.mountVolume(volName, mountPath, username);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int unmountVolume(String cluster, String volName, String mountPath, String username, int pCid, int pCinum, int pUniq) {
        if (mountPath.charAt(0) != '/') {
            LOG.error((Object)("unmountVolume: mount path " + mountPath + " is not " + "absolute"));
            return -1;
        }
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            return client.unmountVolume(volName, mountPath, username, pCid, pCinum, pUniq);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getMountPathFid(String fidStr) throws IOException {
        String[] fidTriple = FID_SPLITTER.split(fidStr);
        if (fidTriple.length != 3) {
            throw new IOException(fidStr + ": Invalid fid format");
        }
        try {
            int[] fidInts = new int[]{Integer.valueOf(fidTriple[0]), Integer.valueOf(fidTriple[1]), Integer.valueOf(fidTriple[2])};
            return this.getMountPath(null, userName, fidInts[0], fidInts[1], fidInts[2]);
        }
        catch (NumberFormatException e) {
            throw new IOException(fidStr + ": Invalid fid format", e);
        }
    }

    public String getMountPath(String cluster, String username, int pCid, int pCinum, int pUniq) {
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            return client.getMountPath(username, pCid, pCinum, pUniq);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in getNewMountPath", (Throwable)e);
            return null;
        }
    }

    public int createSnapshot(String cluster, String volumeName, int volId, int rootCid, String snapshotName, boolean mirrorSnapshot, String username) {
        try {
            ClusterConf.ClusterEntry centry = cluster != null && !cluster.isEmpty() ? clusterConf.getClusterEntryByName(cluster) : clusterConf.getClusterEntryByName(clusterName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            if (client == null) {
                return -1;
            }
            return client.createSnapshot(volumeName, volId, rootCid, snapshotName, mirrorSnapshot, username);
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String getZkConnectStringInternal(String cName) {
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(cName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            if (client == null) {
                return null;
            }
            return client.getZkConnectString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getZkConnectString() throws IOException {
        return this.getZkConnectStringInternal(clusterName);
    }

    private Object getMapRClient(String uri) throws IOException {
        String cName;
        if (!uri.startsWith("maprfs:///")) {
            throw new IOException("Invalid prefix in " + uri + " expecting " + "maprfs:///");
        }
        if ((uri = uri.replaceFirst("maprfs:///", "")).isEmpty()) {
            cName = clusterName;
        } else {
            if (uri.matches("mapr/+")) {
                throw new IOException("Invalid cluster path in " + uri + " expecting " + "maprfs:///");
            }
            uri = uri.replaceFirst("mapr/", "");
            cName = uri = uri.replaceAll("/+$", "");
        }
        try {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(cName);
            return this.lookupClient(centry);
        }
        catch (Exception e) {
            return null;
        }
    }

    public InetSocketAddress[] getJobTrackerAddrs(Configuration conf) throws IOException {
        URI jobTrackerUri;
        if (conf == null) {
            ClusterConf.ClusterEntry centry = clusterConf.getClusterEntryByName(clusterName);
            MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(centry));
            if (client != null) {
                return client.getJobTrackerAddrs();
            }
            throw new IOException("Invalid Configuration");
        }
        String jobTrackerStr = conf.get("mapred.job.tracker", "maprdummy").trim();
        try {
            jobTrackerUri = new URI(jobTrackerStr);
        }
        catch (Exception e) {
            return this.getAddrsFromConf(conf);
        }
        if ("maprfs".equals(jobTrackerUri.getScheme())) {
            MapRClientImpl client = (MapRClientImpl)((Object)this.getMapRClient(jobTrackerStr));
            if (client != null) {
                return client.getJobTrackerAddrs();
            }
            throw new IOException("Failed to get cluster information for " + jobTrackerStr);
        }
        return this.getAddrsFromConf(conf);
    }

    private InetSocketAddress[] getAddrsFromConf(Configuration conf) {
        String[] jobTrackerStrs = MapRFileSystem.getTrimmedStrings(conf.get("mapred.job.tracker", "maprdummy"));
        InetSocketAddress[] jobTrackerAddrs = new InetSocketAddress[jobTrackerStrs.length];
        for (int i = 0; i < jobTrackerStrs.length; ++i) {
            jobTrackerAddrs[i] = NetUtils.createSocketAddr((String)jobTrackerStrs[i]);
        }
        return jobTrackerAddrs;
    }

    public static ClusterConf getClusterConf() {
        return clusterConf;
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return emptyStringArray;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public void createSymbolicLink(Path target, Path link) throws IOException {
        int err = this.createSymlink(target.toString(), link, false);
        if (err != 0) {
            throw new IOException("Failed to create symbolic link: " + link + " -> " + target + "." + "Error: " + Errno.toString((int)err));
        }
    }

    private static void validateFid2(FidInfo fid) throws IOException {
        if (fid.cid <= 0 || fid.cinum < 0 || fid.uniq < 0) {
            throw new IOException("Invalid fid " + fid.toString());
        }
    }

    public FSDataInputStream openFid2(FidInfo pfid, String file, int readAheadBytesHint) throws IOException {
        MapRClientImpl client;
        MapRFileSystem.validateFid2(pfid);
        if (readAheadBytesHint < 0) {
            throw new IOException("readAheadBytesHint cannot be negative");
        }
        if (readAheadBytesHint == 0) {
            String pfidstr = String.valueOf(pfid.cid) + "." + String.valueOf(pfid.cinum) + "." + String.valueOf(pfid.uniq);
            return this.openFid(pfidstr, file, pfid.ips);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("openFid2: " + pfid.toString() + (file != null ? "/" + file : "")));
        }
        if ((client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)))) == null) {
            throw new IOException("Failed to lookup cluster " + clusterName);
        }
        MapRFsInStream is = client.openFid2(pfid, file, readAheadBytesHint);
        return new MapRFsDataInputStream(is);
    }

    public FSDataOutputStream createFid2(FidInfo pfid, String file, FsPermission perm) throws IOException {
        MapRFileSystem.validateFid2(pfid);
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            throw new IOException("Failed to lookup cluster " + clusterName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid2: " + pfid.toString() + (file != null ? "/" + file : "")));
        }
        return null;
    }

    public FSDataOutputStream createFid2(FidInfo pfid, String file) throws IOException {
        return this.createFid2(pfid, file, FsPermission.getDefault());
    }

    public void deleteFid2(FidInfo pfid, String dir) throws IOException {
        MapRFileSystem.validateFid2(pfid);
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            throw new IOException("Failed to lookup cluster " + clusterName);
        }
    }

    public PathId mkdirsFid2(FidInfo pfid, String dir, FsPermission perm) throws IOException {
        MapRFileSystem.validateFid2(pfid);
        if (dir == null || dir.isEmpty()) {
            throw new IOException("Invalid directory");
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            throw new IOException("Failed to lookup cluster " + clusterName);
        }
        return null;
    }

    public PathId mkdirsFid2(FidInfo pfid, String dir) throws IOException {
        return this.mkdirsFid2(pfid, dir, FsPermission.getDefault());
    }

    public void setOwnerFid2(FidInfo fid, String path, String user, String group) throws IOException {
    }

    public void setPermissionFid2(FidInfo fid, String path, FsPermission perm) throws IOException {
    }

    public MapRFileStatus getFileStatus2(FidInfo fid, String path) throws IOException {
        return null;
    }

    private static void validateFid(String fid) throws IOException {
        if (fid == null || !FID_PATTERN.matcher(fid).matches()) {
            throw new IOException(fid + ": Incorrect fid format");
        }
    }

    public FSDataInputStream openFid(String fid, long[] ips, long chunkSize, long fileSize) throws IOException {
        MapRFileSystem.validateFid(fid);
        if (chunkSize < 0L) {
            throw new IOException("Incorrect chunkSize");
        }
        if (fileSize < 0L) {
            throw new IOException("Incorrect file size");
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            return null;
        }
        MapRFsInStream is = client.openFid(fid, ips, chunkSize, fileSize);
        return new MapRFsDataInputStream(is);
    }

    public FSDataInputStream openFid(String pfid, String file, long[] ips) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            return null;
        }
        MapRFsInStream is = client.openFid(pfid, file, ips);
        return new MapRFsDataInputStream(is);
    }

    public FSDataOutputStream createFid(String pfid, String file) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (file == null || file.isEmpty()) {
            throw new IOException("Invalid file");
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createFid: " + pfid + " / " + file));
        }
        MapRFsOutStream os = client.createFid(pfid, file, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), this.chunkSize);
        return new MapRFsDataOutputStream(os);
    }

    public boolean deleteFid(String pfid, String dir) throws IOException {
        MapRFileSystem.validateFid(pfid);
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            return false;
        }
        int error = client.deleteFid(pfid, dir);
        return error == 0;
    }

    public String mkdirsFid(String pfid, String dir) throws IOException {
        MapRFileSystem.validateFid(pfid);
        if (dir == null || dir.isEmpty()) {
            throw new IOException("Invalid directory");
        }
        MapRClientImpl client = (MapRClientImpl)((Object)this.lookupClient(clusterConf.getClusterEntryByName(clusterName)));
        if (client == null) {
            throw new IOException("Unable to connect to MapR cluster!");
        }
        return client.mkdirsFid(pfid, dir, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize);
    }

    public String mkdirsFid(Path p) throws IOException {
        return this.makeDir(p, this.shouldUseDefaultBlockSize(), MapRClientImpl.getModeBits(FsPermission.getDefault(), this.getConf()), true, this.chunkSize, true);
    }

    static {
        userName = null;
        emptyStringArray = new String[0];
        ShimLoader.load();
    }
}

