/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import com.mapr.fs.PageList;
import com.mapr.fs.jni.Errno;
import com.mapr.fs.jni.InodeAttributes;
import com.mapr.fs.jni.JNILoggerProxy;
import com.mapr.fs.jni.MapRClient;
import com.mapr.fs.jni.MapRConstants;
import com.mapr.fs.jni.Page;
import com.mapr.fs.jni.SFid;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.FidInfo;

final class Inode {
    private JNILoggerProxy LOG;
    private static final int MaxAttrAttempts = 5;
    static final int DirtyThreshold = 16;
    public static List<Closeable> allInStreams = new List();
    public static List<Closeable> allOutStreams = new List();
    static CmpPageId pageCmp_ = new CmpPageId();
    static Lock wpoolLock_ = new ReentrantLock();
    static PageList wpoolList_ = new PageList(wpoolLock_);
    Page[] dirtyPages_;
    int dirtyPageCount_;
    int totalDirtyPages_;
    ListElem<Closeable> outStreamElem_;
    boolean writeClosed_;
    ICache cache_;
    Lock cacheLock_;
    PageList lru_;
    Page[] allPages_;
    long fileP;
    long clusterP;
    String filename_;
    volatile InodeAttributes attrs_;
    private int err_;
    ListElem<Closeable> inStreamElem_;

    public static void allocWriteBuffers(int numPages) {
    }

    private void commonInit(long clusterPtr, long filePtr, String filename, InodeAttributes attr, JNILoggerProxy logger) throws IOException {
        this.LOG = logger;
        this.clusterP = clusterPtr;
        this.fileP = filePtr;
        this.filename_ = filename;
        this.allPages_ = null;
        this.lru_ = null;
        this.cache_ = null;
        this.cacheLock_ = null;
        this.dirtyPageCount_ = 0;
        this.totalDirtyPages_ = 0;
        this.dirtyPages_ = null;
        this.inStreamElem_ = null;
        this.outStreamElem_ = null;
        this.writeClosed_ = true;
        this.err_ = 0;
        if (attr != null) {
            this.attrs_ = attr;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)(">Inode Open file: " + this.filename_ + ", size: " + this.attrs_.filesize + ", chunkSize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString()));
            }
        } else {
            this.attrs_ = new InodeAttributes();
            if (this.fileP != 0L) {
                int attempts = 0;
                while (attempts < 5) {
                    long size = MapRClient.getAttrs((long)this.clusterP, (long)this.fileP, (InodeAttributes)this.attrs_);
                    if (size < 0L) {
                        throw new IOException(">Inode GetAttr: Failed to get attributes for file " + this.filename_ + ", size: " + size + ", chunkSize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString());
                    }
                    if (size != this.attrs_.filesize) {
                        this.LOG.error((Object)(">Inode GetAttr: attempt#: " + attempts + ", file: " + this.filename_ + ", incorrect size: " + this.attrs_.filesize + ", expected: " + size + ", chunksize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString()));
                        if (++attempts != 5) continue;
                        throw new IOException(">Inode GetAttr: Failed to get attributes for file " + this.filename_ + ", after " + 5 + " attempts");
                    }
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)(">Inode GetAttr: file: " + this.filename_ + ", size: " + this.attrs_.filesize + ", chunksize: " + this.attrs_.chunksize + ", fid: " + this.attrs_.toString()));
                    }
                    break;
                }
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)(">Inode Open with no getattr for file: " + this.filename_));
            }
        }
    }

    public String getFidStr() {
        return this.attrs_.toString();
    }

    public long[] getFidServers() {
        return MapRClient.getFidServers((long)this.clusterP, (int)this.attrs_.cid);
    }

    public long getChunkSize() {
        return this.attrs_.chunksize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode(long clusterPtr, long filePtr, String filename, MapRFsOutStream outStream, JNILoggerProxy logger) throws IOException {
        this.commonInit(clusterPtr, filePtr, filename, null, logger);
        this.dirtyPages_ = new Page[16];
        this.writeClosed_ = false;
        this.outStreamElem_ = new ListElem<MapRFsOutStream>(outStream);
        List<Closeable> list = allOutStreams;
        synchronized (list) {
            allOutStreams.add(this.outStreamElem_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Inode(long clusterPtr, long filePtr, String filename, MapRFsInStream inStream, InodeAttributes attr, JNILoggerProxy logger) throws IOException {
        this.commonInit(clusterPtr, filePtr, filename, attr, logger);
        int numPages = inStream.getCacheSize(this.attrs_);
        this.cache_ = new ICache(numPages);
        this.cacheLock_ = new ReentrantLock();
        this.lru_ = new PageList(this.cacheLock_);
        this.allPages_ = new Page[numPages];
        this.cacheLock_.lock();
        for (int i = 0; i < this.allPages_.length; ++i) {
            Page p = new Page(this.cacheLock_, false, 8192);
            this.lru_.push(p);
            this.allPages_[i] = p;
        }
        this.cacheLock_.unlock();
        this.inStreamElem_ = new ListElem<MapRFsInStream>(inStream);
        List<Closeable> list = allInStreams;
        synchronized (list) {
            allInStreams.add(this.inStreamElem_);
        }
    }

    public Inode(long clusterPtr, long filePtr, String filename, MapRFsInStream inStream, JNILoggerProxy logger) throws IOException {
        this(clusterPtr, filePtr, filename, inStream, null, logger);
    }

    public InodeAttributes attrs() {
        return this.attrs_;
    }

    public String toString() {
        return this.attrs_.toString() + " " + this.filename();
    }

    void pr(String s) {
        this.LOG.error((Object)(this + s));
    }

    long lastOffsetInPage(long pageId) {
        return (pageId << 13) + 8192L;
    }

    public long eof() {
        return this.attrs_.filesize;
    }

    public boolean haveEof() {
        return true;
    }

    public String filename() {
        return this.filename_ != null ? this.filename_ : "";
    }

    void markFailed(int err) {
        this.err_ = err;
    }

    void throwIfFailed() throws IOException {
        if (this.err_ != 0) {
            throw new IOException(this.toString() + " (" + Errno.toString((int)Math.abs(this.err_)) + ")");
        }
    }

    void printstack() {
        StackTraceElement[] se = Thread.currentThread().getStackTrace();
        for (int i = 0; i < se.length; ++i) {
            this.LOG.error((Object)("\t " + se[i]));
        }
    }

    void printstack(Exception e) {
        StackTraceElement[] se = e.getStackTrace();
        for (int i = 0; i < se.length; ++i) {
            this.LOG.error((Object)("\t " + se[i]));
        }
    }

    MapRFsOutStream nextStream() {
        return this.outStreamElem_.next != null ? (MapRFsOutStream)this.outStreamElem_.next.elem : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page allocatePage(long startPos) throws IOException {
        this.throwIfFailed();
        long pageId = startPos >> 13;
        Page p = null;
        wpoolLock_.lock();
        if (!wpoolList_.empty()) {
            p = wpoolList_.popOldest();
        }
        wpoolLock_.unlock();
        if (p == null) {
            p = new Page(wpoolLock_, false, 8192);
        }
        Inode inode = this;
        synchronized (inode) {
            ++this.totalDirtyPages_;
        }
        p.invalidate();
        p.pageId = pageId;
        p.iattr = this.attrs_;
        p.ref = 1;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushPages(Page[] parray, boolean flushJniBuffers, long flushToPos) throws IOException {
        int i;
        boolean needsSorting = false;
        long prevPageId = -1L;
        for (i = 0; i < parray.length; ++i) {
            Page p = parray[i];
            if (prevPageId != -1L) {
                needsSorting = prevPageId > p.pageId;
            }
            prevPageId = p.pageId;
        }
        if (needsSorting) {
            Arrays.sort(parray, pageCmp_);
        }
        int ret = 0;
        try {
            ret = MapRClient.writeRPC((long)this.clusterP, (long)this.fileP, (Page[])parray, (long)flushToPos, (boolean)flushJniBuffers);
        }
        finally {
            if (ret < 0) {
                this.LOG.error((Object)("Write failed for file: " + this.filename() + ", error: " + Errno.toString((int)(-ret))));
                this.markFailed(-ret);
            }
            wpoolLock_.lock();
            for (i = 0; i < parray.length; ++i) {
                wpoolList_.push(parray[i]);
            }
            wpoolLock_.unlock();
            Inode inode = this;
            synchronized (inode) {
                this.totalDirtyPages_ -= parray.length;
                this.notify();
            }
        }
        this.throwIfFailed();
    }

    void flushJniBuffers(long flushToPos) throws IOException {
        int ret = MapRClient.flushJniBuffers((long)this.clusterP, (long)this.fileP, (long)flushToPos);
        if (ret < 0) {
            this.LOG.error((Object)("Flush failed for file: " + this.filename() + ", error: " + Errno.toString((int)(-ret))));
            this.markFailed(-ret);
        }
        this.throwIfFailed();
    }

    Page[] copyDirtyPages() {
        Page[] parray = new Page[this.dirtyPageCount_];
        for (int i = 0; i < parray.length; ++i) {
            Page p = parray[i] = this.dirtyPages_[i];
            this.dirtyPages_[i] = null;
            p.dirty = false;
        }
        return parray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDirty(Page p) throws IOException {
        if (this.err_ != 0) {
            wpoolLock_.lock();
            wpoolList_.push(p);
            wpoolLock_.unlock();
            Inode inode = this;
            synchronized (inode) {
                --this.totalDirtyPages_;
                this.notify();
            }
            this.throwIfFailed();
        }
        Page[] dirtyList = null;
        if (p.ref <= 0) {
            this.pr(":releaseDirty() Page has low refcount, pageId: " + p.pageId + ", dirty: " + p.dirty + ", ref: " + p.ref);
            this.printstack();
        } else {
            --p.ref;
        }
        if (!p.dirty) {
            p.dirty = true;
            Inode inode = this;
            synchronized (inode) {
                this.dirtyPages_[this.dirtyPageCount_++] = p;
                if (this.dirtyPageCount_ >= 16) {
                    dirtyList = this.copyDirtyPages();
                    this.dirtyPageCount_ = 0;
                }
            }
        }
        if (dirtyList != null) {
            this.flushPages(dirtyList, false, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncInternal(boolean waitForFlush, long flushToPos) throws IOException {
        Page[] pp = null;
        Inode inode = this;
        synchronized (inode) {
            if (this.dirtyPageCount_ > 0) {
                pp = this.copyDirtyPages();
                this.dirtyPageCount_ = 0;
            }
        }
        if (pp != null) {
            this.flushPages(pp, waitForFlush, flushToPos);
        } else if (waitForFlush) {
            this.flushJniBuffers(flushToPos);
        }
    }

    public void syncUpto(long pos) throws IOException {
        this.syncInternal(true, pos);
    }

    void sync() throws IOException {
        this.syncInternal(true, 0L);
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void closeWrite() throws IOException {
        if (!this.writeClosed_) {
            try {
                this.sync();
            }
            finally {
                this.removeFromOutStreams();
                this.writeClosed_ = true;
            }
        }
    }

    void returnPage(Page p) {
        if (p.ref <= 0) {
            this.pr(":returnPage() Page has low refcount, ref: " + p.ref + ", p.attr: " + p.iattr);
            this.printstack();
        }
        if (--p.ref == 0) {
            if (p.valid()) {
                this.lru_.push(p);
            } else {
                this.lru_.pushOldest(p);
            }
        }
    }

    public void returnPageToCache(Page p) {
        this.cacheLock_.lock();
        this.returnPage(p);
        this.cacheLock_.unlock();
    }

    public void discardPage(Page p) {
        this.cacheLock_.lock();
        if (p.ref <= 0) {
            this.pr(":discardPage()  Page has low refcount, ref: " + p.ref + ", p.attr " + p.iattr);
            this.printstack();
        }
        if (--p.ref == 0) {
            this.lru_.pushOldest(p);
        }
        this.cacheLock_.unlock();
    }

    Page createNewPage(long pageId) {
        Page p = this.lru_.popOldest();
        if (p.valid()) {
            this.cache_.remove(p);
            p.invalidate();
        }
        p.validStart = 0;
        p.validLen = 8192;
        p.pageId = pageId;
        p.iattr = this.attrs_;
        this.cache_.insert(p);
        p.ref = 1;
        return p;
    }

    public Page[] allocateReadaheadPages(long startPos, int bytes) {
        Page p;
        Page[] pagesToFill = null;
        long pageId = startPos >> 13;
        int numPages = (bytes + 8192 - 1) / 8192;
        this.cacheLock_.lock();
        for (int i = 0; i < numPages && (p = this.cache_.lookup(this.attrs_, pageId)) == null && !this.lru_.empty(); ++i) {
            p = this.createNewPage(pageId);
            p.setFilling();
            if (pagesToFill == null) {
                pagesToFill = new Page[numPages];
            }
            pagesToFill[i] = p;
            ++pageId;
        }
        this.cacheLock_.unlock();
        return pagesToFill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readPages(Page[] pagesToFill) {
        int bytesRecd = -1;
        try {
            bytesRecd = MapRClient.readRPC((long)this.clusterP, (long)this.fileP, (Page[])pagesToFill, null, (int)0, (int)0, (int)0, null, null, null, null);
        }
        finally {
            if (bytesRecd == Integer.MAX_VALUE) {
                this.markFailed(-5);
                bytesRecd = 0;
            } else if (bytesRecd < 0) {
                bytesRecd = -bytesRecd;
                --bytesRecd;
            }
        }
        return bytesRecd;
    }

    public void cleanupAfterRead(Page[] pagesToFill, int bytesRecd) {
        Page p;
        int i;
        boolean eofPresent = false;
        if (bytesRecd == Integer.MAX_VALUE) {
            this.markFailed(-5);
            bytesRecd = 0;
        } else if (bytesRecd < 0) {
            bytesRecd = -bytesRecd;
            --bytesRecd;
            eofPresent = true;
        } else if (bytesRecd < 8192 * pagesToFill.length) {
            eofPresent = true;
        }
        this.cacheLock_.lock();
        for (i = 0; i < pagesToFill.length && (p = pagesToFill[i]) != null; ++i) {
            if (bytesRecd > 0) {
                p.setValid();
                if (bytesRecd < 8192) {
                    p.validStart = 0;
                    p.validLen = bytesRecd;
                    bytesRecd = 0;
                    eofPresent = false;
                } else {
                    p.validStart = 0;
                    p.validLen = 8192;
                    bytesRecd -= 8192;
                }
            } else {
                this.cache_.remove(p);
                p.invalidate();
            }
            p.cv.signal();
        }
        for (i = 0; i < pagesToFill.length && pagesToFill[i] != null; ++i) {
            this.returnPage(pagesToFill[i]);
        }
        this.cacheLock_.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillPages(Page[] pagesToFill, SFid sfid, FidInfo pfid, String file) throws IOException {
        int bytesRecd = 0;
        try {
            if (pfid != null) {
                MapRConstants.ErrorValue err = new MapRConstants.ErrorValue();
                bytesRecd = MapRClient.readRPC((long)this.clusterP, (long)this.fileP, (Page[])pagesToFill, (SFid)sfid, (int)pfid.cid, (int)pfid.cinum, (int)pfid.uniq, (long[])pfid.ips, (String)file, (MapRConstants.ErrorValue)err, (InodeAttributes)this.attrs_);
                this.fileP = err.fileptr;
            } else {
                bytesRecd = MapRClient.readRPC((long)this.clusterP, (long)this.fileP, (Page[])pagesToFill, (SFid)sfid, (int)0, (int)0, (int)0, null, null, null, null);
            }
        }
        finally {
            this.cleanupAfterRead(pagesToFill, bytesRecd);
        }
        if (pfid != null && this.fileP == 0L) {
            throw new IOException("openFid2: Failed to open inode for pfid: " + pfid.toString() + ", file: " + (file != null ? file : ""));
        }
        this.throwIfFailed();
    }

    public Page getDataIntoCache(long startPos, int length, SFid sfid, FidInfo pfid, String file) throws IOException {
        Page p;
        Page resultPage = null;
        long endPos = startPos + (long)length;
        long pageId = startPos >> 13;
        this.throwIfFailed();
        ArrayList<Page> pagesToFill = null;
        ArrayList<Page> pagesToWaitOn = null;
        this.cacheLock_.lock();
        while (true) {
            if (pfid == null && (p = this.cache_.lookup(this.attrs_, pageId)) != null) {
                this.lru_.pop(p);
                ++p.ref;
                if (resultPage == null) {
                    resultPage = p;
                    ++p.ref;
                }
                if (p.filling()) {
                    if (pagesToWaitOn == null) {
                        pagesToWaitOn = new ArrayList<Page>();
                    }
                    pagesToWaitOn.add(p);
                } else {
                    this.returnPage(p);
                }
            } else {
                if (this.lru_.empty()) {
                    this.lru_.waitTillNotEmpty();
                    continue;
                }
                p = this.createNewPage(pageId);
                p.setFilling();
                if (pagesToFill == null) {
                    pagesToFill = new ArrayList<Page>();
                }
                pagesToFill.add(p);
                if (resultPage == null) {
                    resultPage = p;
                    ++p.ref;
                }
            }
            if (this.lastOffsetInPage(pageId) >= endPos) break;
            ++pageId;
        }
        if (resultPage == null) {
            this.pr(": resultPage null, " + this.attrs_ + ", startPos " + startPos + ", len " + length);
            this.printstack();
        } else if (resultPage.ref <= 0) {
            this.pr(": resultPage bad ref " + resultPage.pageId + ", " + this.attrs_ + ", startPos " + startPos + ", len " + length);
            this.printstack();
        }
        this.cacheLock_.unlock();
        if (pagesToFill != null) {
            Page[] pp = new Page[pagesToFill.size()];
            pp = pagesToFill.toArray(pp);
            this.fillPages(pp, sfid, pfid, file);
        }
        if (pagesToWaitOn != null) {
            for (int i = 0; i < pagesToWaitOn.size(); ++i) {
                p = (Page)pagesToWaitOn.get(i);
                this.cacheLock_.lock();
                while (p.filling()) {
                    p.cv.awaitUninterruptibly();
                }
                this.returnPage(p);
                this.cacheLock_.unlock();
            }
        }
        if (resultPage != null && !resultPage.invalid()) {
            this.cacheLock_.lock();
            if (resultPage.ref <= 0) {
                this.pr(":getDataIntoCache() Page has low refcount in resultPage, page: " + resultPage);
                this.printstack();
                this.cacheLock_.lock();
            }
            this.cacheLock_.unlock();
            return resultPage;
        }
        this.pr(" Returning bad page to cache page: " + resultPage);
        this.returnPageToCache(resultPage);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromInStreams() {
        if (this.inStreamElem_ != null) {
            List<Closeable> list = allInStreams;
            synchronized (list) {
                if (this.inStreamElem_ != null) {
                    allInStreams.remove(this.inStreamElem_);
                }
                this.inStreamElem_ = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromOutStreams() {
        if (this.outStreamElem_ != null) {
            List<Closeable> list = allOutStreams;
            synchronized (list) {
                if (this.outStreamElem_ != null) {
                    allOutStreams.remove(this.outStreamElem_);
                }
                this.outStreamElem_ = null;
            }
        }
    }

    public void adviseFile(int type, long offset, long count) throws IOException {
        int ret = MapRClient.adviseFile((long)this.clusterP, (long)this.fileP, (int)type, (long)offset, (long)count);
        if (ret < 0) {
            this.LOG.error((Object)("AdviseFile failed for file: " + this.filename() + ", offset = " + offset + ", count = " + count + ", error: " + Errno.toString((int)(-ret))));
            throw new IOException("AdviseFile failed for file: " + this.filename() + ", offset: " + offset + ", count: " + count + ", error: " + Errno.toString((int)(-ret)));
        }
    }

    public void close() throws IOException {
        this.closeWrite();
        this.closeRead();
        if (this.fileP != 0L) {
            MapRClient.closeFile((long)this.clusterP, (long)this.fileP);
        }
    }

    void closeRead() {
        this.removeFromInStreams();
        if (this.allPages_ != null) {
            for (int i = 0; i < this.allPages_.length; ++i) {
                this.allPages_[i].releaseStorage();
            }
            this.allPages_ = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Closeable i = null;
        do {
            List<Closeable> list = allInStreams;
            synchronized (list) {
                i = allInStreams.first();
            }
            if (i == null) continue;
            try {
                i.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (i != null);
        Closeable o = null;
        do {
            List<Closeable> list = allOutStreams;
            synchronized (list) {
                o = allOutStreams.first();
            }
            if (o == null) continue;
            try {
                o.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (o != null);
    }

    static class List<E> {
        ListElem<E> head_;
        ListElem<E> tail_;

        List() {
        }

        void add(ListElem<E> e) {
            if (e.inList) {
                return;
            }
            e.inList = true;
            e.next = null;
            e.prev = this.tail_;
            if (this.tail_ != null) {
                this.tail_.next = e;
            } else {
                this.head_ = e;
            }
            this.tail_ = e;
        }

        void remove(ListElem<E> e) {
            if (!e.inList) {
                return;
            }
            e.inList = false;
            ListElem p = e.prev;
            ListElem n = e.next;
            if (p != null) {
                p.next = n;
            } else {
                this.head_ = n;
            }
            if (n != null) {
                n.prev = p;
            } else {
                this.tail_ = p;
            }
        }

        E first() {
            return this.head_ != null ? (E)this.head_.elem : null;
        }
    }

    static class ListElem<E> {
        public ListElem<E> prev;
        public ListElem<E> next;
        public E elem;
        public boolean inList;

        ListElem(E e) {
            this.elem = e;
            this.inList = false;
            this.next = null;
            this.prev = null;
        }
    }

    static class ICache {
        Page[] tab_;
        int size_;

        ICache(int numEntries) {
            this.size_ = numEntries + 1;
            this.tab_ = new Page[this.size_];
        }

        int hash(InodeAttributes a, long pageId) {
            return (int)pageId % this.size_;
        }

        Page lookup(InodeAttributes iattr, long pageId) {
            Page p = this.tab_[this.hash(iattr, pageId)];
            while (p != null && !p.eq(iattr, pageId)) {
                p = p.hnext;
            }
            return p;
        }

        void remove(Page page) {
            int hv = this.hash(page.iattr, page.pageId);
            Page p = this.tab_[hv];
            Page prev = null;
            while (p != null && !p.eq(page)) {
                prev = p;
                p = p.hnext;
            }
            if (p != null) {
                if (prev != null) {
                    prev.hnext = p.hnext;
                } else {
                    this.tab_[hv] = p.hnext;
                }
            }
        }

        void insert(Page p) {
            int hv = this.hash(p.iattr, p.pageId);
            p.hnext = this.tab_[hv];
            this.tab_[hv] = p;
        }
    }

    static class CmpPageId
    implements Comparator {
        CmpPageId() {
        }

        public int compare(Object o1, Object o2) {
            Page p1 = (Page)o1;
            Page p2 = (Page)o2;
            long res = p2.pageId - p1.pageId;
            if (res < 0L) {
                return -1;
            }
            if (res > 0L) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }
}

