/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.jni.MapRConstants;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClusterConf
implements MapRConstants {
    private static final Log LOG = LogFactory.getLog(ClusterConf.class);
    private String clusterConfFile;
    private List<ClusterEntry> clusterList;

    public static long ipToLong(String addr) throws UnknownHostException {
        long result = 0L;
        String[] addrArray = InetAddress.getByName(addr).getHostAddress().split("\\.");
        for (int i = 3; i >= 0; --i) {
            result |= Long.parseLong(addrArray[3 - i]) << i * 8;
        }
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    private void addIpPortToList(List<IpPort> ipList, String addrArr, String cName) {
        for (String addr : addrArr.split(";")) {
            IpPort ipPort;
            if ((addr = addr.trim()).isEmpty()) continue;
            int idx = addr.indexOf(",");
            String hostname = null;
            if (idx != -1) {
                hostname = addr.substring(0, idx);
                addr = addr.substring(idx + 1);
            }
            if (addr.contains(":")) {
                String[] arr = addr.split(":");
                int port = Integer.parseInt(arr[1]);
                if (port < 0 || port > 65535) {
                    if (cName == null || cName.isEmpty()) continue;
                    System.err.println("Invalid port # for cluster " + cName);
                    continue;
                }
                ipPort = new IpPort(hostname, arr[0], port);
            } else {
                ipPort = new IpPort(hostname, addr, 7222);
            }
            ipList.add(ipPort);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterEntry(String cName, String[] cldbLocations) {
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            Iterator<ClusterEntry> iter = this.clusterList.iterator();
            while (iter.hasNext()) {
                ClusterEntry centry = iter.next();
                if (!centry.getClusterName().equals(cName)) continue;
                iter.remove();
            }
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            try {
                for (String cldb : cldbLocations) {
                    this.addIpPortToList(ipList, cldb, null);
                }
                if (ipList.size() != 0) {
                    ClusterEntry centry = new ClusterEntry(cName, ipList);
                    this.clusterList.add(centry);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterConf() {
        List<ClusterEntry> list = this.clusterList = new ArrayList<ClusterEntry>();
        synchronized (list) {
            String maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null && (maprHome = System.getenv("MAPR_HOME")) == null) {
                maprHome = "/opt/mapr/";
            }
            if (maprHome.startsWith("\"")) {
                maprHome = maprHome.substring(1, maprHome.length() - 1);
            }
            this.clusterConfFile = maprHome + "/conf/mapr-clusters.conf";
            try {
                FileReader fr = new FileReader(this.clusterConfFile);
                if (fr != null) {
                    String strLine;
                    BufferedReader b = new BufferedReader(fr);
                    while ((strLine = b.readLine()) != null) {
                        String[] tokens;
                        if ((strLine = strLine.trim()).isEmpty() || strLine.startsWith("#") || (tokens = strLine.split("[\\s]+")).length < 2) continue;
                        String clusterName = tokens[0];
                        ArrayList<IpPort> ipList = new ArrayList<IpPort>();
                        for (int i = 1; i < tokens.length; ++i) {
                            this.addIpPortToList(ipList, tokens[i], clusterName);
                        }
                        if (ipList.size() == 0) continue;
                        ClusterEntry centry = new ClusterEntry(clusterName, ipList);
                        this.clusterList.add(centry);
                    }
                }
            }
            catch (FileNotFoundException fe) {
            }
            catch (Exception e) {
                this.clusterList.clear();
                System.err.println("Failed to build cluster list from " + this.clusterConfFile);
                System.err.println(e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClusterEntry getFirstClusterEntry() {
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            if (this.clusterList.size() == 0) {
                return null;
            }
            return this.clusterList.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByAddr(String ip, int port) {
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            for (ClusterEntry centry : this.clusterList) {
                for (IpPort ipPort : centry.getIpList()) {
                    if (!ipPort.getAddr().equalsIgnoreCase(ip) || ipPort.getPort() != port) continue;
                    return centry;
                }
            }
            ArrayList<IpPort> ipList = new ArrayList<IpPort>();
            IpPort ipPort = new IpPort("", ip, port);
            ipList.add(ipPort);
            String clusterName = ip + ":" + port;
            try {
                ClusterEntry centry = new ClusterEntry(clusterName, ipList);
                this.clusterList.add(centry);
                return centry;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterEntry getClusterEntryByName(String clusterName) {
        List<ClusterEntry> list = this.clusterList;
        synchronized (list) {
            for (ClusterEntry centry : this.clusterList) {
                if (!centry.getClusterName().equals(clusterName)) continue;
                return centry;
            }
        }
        return null;
    }

    public ClusterEntry getClusterByUri(URI name) throws IOException {
        if (name.getHost() == null) {
            ClusterEntry centry = this.getFirstClusterEntry();
            if (centry == null) {
                throw new IOException("No default cluster in " + this.clusterConfFile);
            }
            return centry;
        }
        String ip = name.getHost();
        int port = name.getPort();
        if (port <= 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Invalid port " + port + "specified in " + this.clusterConfFile + ", using default port " + 7222 + " instead"));
            }
            port = 7222;
        }
        return this.getClusterEntryByAddr(ip, port);
    }

    private ClusterEntry fastClusterByPath(URI p, URI fsUri, String fsClusterName) throws IOException {
        if (p.getHost() == null) {
            ClusterEntry centry = this.getClusterEntryByName(fsClusterName);
            if (centry == null) {
                throw new IOException("Cluster " + fsClusterName + " not found in " + this.clusterConfFile);
            }
            return centry;
        }
        String ip = p.getHost();
        int port = p.getPort();
        if (port <= 0) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("Invalid port " + port + "specified in " + this.clusterConfFile + ", using default port " + 7222 + " instead"));
            }
            port = 7222;
        }
        return this.getClusterEntryByAddr(ip, port);
    }

    public ClusterEntry getClusterByPath(URI p, URI fsUri, String fsClusterName) throws IOException {
        String rawPath = p.getPath();
        if (!rawPath.startsWith("/") || !rawPath.startsWith("/mapr")) {
            return this.fastClusterByPath(p, fsUri, fsClusterName);
        }
        if (rawPath.matches("^/mapr/.+")) {
            String clusterName = rawPath.split("/")[2];
            ClusterEntry centry = this.getClusterEntryByName(clusterName);
            if (centry == null) {
                throw new IOException("Cluster " + clusterName + " has no entry in " + this.clusterConfFile);
            }
            return centry;
        }
        if (rawPath.equals("/mapr") || rawPath.equals("/mapr/")) {
            throw new IOException("Invalid path " + rawPath + ". " + "The correct format for fully-qualified names is: " + "/mapr/" + "<cluster>/<path>");
        }
        return this.fastClusterByPath(p, fsUri, fsClusterName);
    }

    public List<ClusterEntry> getClusterList() {
        return this.clusterList;
    }

    public class ClusterEntry {
        private String clusterName;
        private List<IpPort> ipList;
        private long[] ips = null;

        public ClusterEntry(String clusterName, List<IpPort> ipList) throws UnknownHostException {
            this.clusterName = clusterName;
            this.ipList = ipList;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public List<IpPort> getIpList() {
            return this.ipList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long[] getIPs() throws IOException {
            if (this.ips == null) {
                ClusterEntry clusterEntry = this;
                synchronized (clusterEntry) {
                    ArrayList<Long> arr = new ArrayList<Long>();
                    for (IpPort ipPort : this.ipList) {
                        try {
                            long val = (ClusterConf.ipToLong(ipPort.getAddr()) << 32) + ((long)ipPort.getPort() & 0xFFFFL);
                            arr.add(val);
                        }
                        catch (UnknownHostException e) {
                            if (!LOG.isWarnEnabled()) continue;
                            LOG.warn((Object)("Could not resolve CLDB hostname " + ipPort.getAddr() + ", for cluster: " + this.clusterName));
                        }
                    }
                    if (!arr.isEmpty()) {
                        Collections.shuffle(arr);
                        this.ips = new long[arr.size()];
                        for (int i = 0; i < arr.size(); ++i) {
                            this.ips[i] = (Long)arr.get(i);
                        }
                    }
                }
            }
            if (this.ips == null) {
                throw new IOException("Could not resolve any CLDB hostnames for cluster: " + this.clusterName);
            }
            return this.ips;
        }
    }

    public class IpPort {
        private final String addr;
        private final int port;

        public IpPort(String hname, String addr, int port) {
            this.addr = addr == null || addr.length() == 0 ? hname : addr;
            this.port = port;
        }

        public String getAddr() {
            return this.addr;
        }

        public int getPort() {
            return this.port;
        }
    }
}

