/* Copyright (c) 2011 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ParsedRow {
  public int[] coff;
  public int[] clen;
  public int[] nval;  //Number of values per column
  public int[] valoff;
  public int[] vallen;
  public long[] ts;
  public int[] isDelete;
  public int[] isDeleteExact;
  public int curNVal;
  public int curCoff;
  public int curClen;
  public boolean parseColumnCalled;
  private int MinArraySize;
  private int ncols;
  private int nvals;
  private int colIdx;
  private int valIdx;

  public ParsedRow() {
    MinArraySize = 8;
    ncols = MinArraySize;
    coff = new int[ncols];
    clen = new int[ncols];
    nval = new int[ncols];
    nvals = MinArraySize;
    valoff = new int[nvals];
    vallen = new int[nvals];
    ts = new long[nvals];
    isDelete = new int[nvals];
    isDeleteExact = new int[nvals];
    colIdx = 0;
    valIdx = 0;
    parseColumnCalled = false;
  }

  void Clear() {
    parseColumnCalled = false;
    colIdx = 0;
    valIdx = 0;
  }

  public void addColumn(int off, int len, int numValues) {
    if (colIdx == ncols) {
      int tmpNcols = ncols + MinArraySize;
      int [] tmpCoff = new int[tmpNcols];
      int [] tmpClen = new int[tmpNcols];
      int [] tmpNval = new int[tmpNcols];
      System.arraycopy(coff, 0, tmpCoff, 0, ncols);
      System.arraycopy(clen, 0, tmpClen, 0, ncols);
      System.arraycopy(nval, 0, tmpNval, 0, ncols);
      ncols = tmpNcols;
      coff = tmpCoff;
      clen = tmpClen;
      nval = tmpNval;
    }
    coff[colIdx] = off;
    clen[colIdx] = len;
    nval[colIdx] = numValues;
    ++colIdx;
  }

  public void addValue(int off, int len, long version, int isdel, int isdelexact) {
    if (valIdx == nvals) {
      int tmpNvals = nvals + MinArraySize;
      int [] tmpValoff = new int[tmpNvals];
      int [] tmpVallen = new int[tmpNvals];
      long [] tmpTs = new long[tmpNvals];
      int [] tmpIsDelete = new int[tmpNvals];
      int [] tmpIsDeleteExact = new int[tmpNvals];
      System.arraycopy(valoff, 0, tmpValoff, 0, nvals);
      System.arraycopy(vallen, 0, tmpVallen, 0, nvals);
      System.arraycopy(ts, 0, tmpTs, 0, nvals);
      System.arraycopy(isDelete, 0, tmpIsDelete, 0, nvals);
      System.arraycopy(isDeleteExact, 0, tmpIsDeleteExact, 0, nvals);
      nvals = tmpNvals;
      valoff = tmpValoff;
      vallen = tmpVallen;
      ts = tmpTs;
      isDelete = tmpIsDelete;
      isDeleteExact = tmpIsDeleteExact;
    }
    valoff[valIdx] = off;
    vallen[valIdx] = len;
    ts[valIdx] = version;
    isDelete[valIdx] = isdel;
    isDeleteExact[valIdx] = isdelexact;
    ++valIdx;
  }

  public int getNumColumns() {
    return colIdx;
  }

  public int getNumValues() {
    return valIdx;
  }
}
