/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */
package com.mapr.fs.jni;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;


import com.mapr.fs.jni.Errno;

/* This class is used by the jni layer to return certain data to the Java layer.
 * It is right now used in two ways -
 * 1. To send back the list of subscriptions for this listener.
 * 2. To send back all the messages during a poll.
 */

public class NativeData {
  public long[] long_data;
  public byte[] byte_data;
  public int err;
  public int longArrIndex = 0;
  public int byteArrIndex = 0;

  public NativeData() {}

  public int length() { return long_data.length; }

  public long[] long_data() { return long_data; }

  public byte[] byte_data() { return byte_data; }

  public int error() { return err; }

  public void startParser() {
    longArrIndex = 0;
    byteArrIndex = 0;
  }

  public boolean HasData() { return (longArrIndex < length()); }
}
