/* Copyright (c) 2009 & onwards. MapR Tech, Inc., All rights reserved */

package com.mapr.fs.jni;

public abstract class MarlinJniProducer extends MarlinJniClient {

  protected native final long OpenProducer(String clientId,
                                           int rpcTimeoutMillis,
                                           boolean hardMount,
                                           boolean parallelFlushersPerPartition,
                                           long bufferMaxSize,
                                           long bufferMaxMillis,
                                           long metadataMaxAgeMillis,
                                           String producerDefaultStreamName);


  protected native final String GetDefaultClusterPath(long clntPtr);

  protected native final int Send(long _clntPtr, long producerId,
                                  byte[] topicNameKeyValue, int topicNameKeyValueSz,
                                  int[] offsets, int[] feedIds,
                                  MarlinProducerResult[] results, int numRecords);

  protected native final int Flush(long clntPtr);

  protected native final void CloseProducer(long clntPtr);

  protected native final int GetTopicInfo(long clntPtr, String topic);
}
